/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="License plate found in the image")
@JsonPropertyOrder(value={"LicensePlateText_BestMatch", "LicensePlateText_RunnerUp", "LocationX", "LocationY", "Width", "Height", "LicensePlateRecognitionConfidenceLevel"})
@JsonTypeName(value="DetectedLicensePlate")
public class DetectedLicensePlate {
    public static final String JSON_PROPERTY_LICENSE_PLATE_TEXT_BEST_MATCH = "LicensePlateText_BestMatch";
    private String licensePlateTextBestMatch;
    public static final String JSON_PROPERTY_LICENSE_PLATE_TEXT_RUNNER_UP = "LicensePlateText_RunnerUp";
    private String licensePlateTextRunnerUp;
    public static final String JSON_PROPERTY_LOCATION_X = "LocationX";
    private Integer locationX;
    public static final String JSON_PROPERTY_LOCATION_Y = "LocationY";
    private Integer locationY;
    public static final String JSON_PROPERTY_WIDTH = "Width";
    private Integer width;
    public static final String JSON_PROPERTY_HEIGHT = "Height";
    private Integer height;
    public static final String JSON_PROPERTY_LICENSE_PLATE_RECOGNITION_CONFIDENCE_LEVEL = "LicensePlateRecognitionConfidenceLevel";
    private Double licensePlateRecognitionConfidenceLevel;

    public DetectedLicensePlate licensePlateTextBestMatch(String licensePlateTextBestMatch) {
        this.licensePlateTextBestMatch = licensePlateTextBestMatch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text from the license plate, highest-confidence result")
    @JsonProperty(value="LicensePlateText_BestMatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLicensePlateTextBestMatch() {
        return this.licensePlateTextBestMatch;
    }

    public void setLicensePlateTextBestMatch(String licensePlateTextBestMatch) {
        this.licensePlateTextBestMatch = licensePlateTextBestMatch;
    }

    public DetectedLicensePlate licensePlateTextRunnerUp(String licensePlateTextRunnerUp) {
        this.licensePlateTextRunnerUp = licensePlateTextRunnerUp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Alternate text from the license plate, based on second-highest-confidence result")
    @JsonProperty(value="LicensePlateText_RunnerUp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLicensePlateTextRunnerUp() {
        return this.licensePlateTextRunnerUp;
    }

    public void setLicensePlateTextRunnerUp(String licensePlateTextRunnerUp) {
        this.licensePlateTextRunnerUp = licensePlateTextRunnerUp;
    }

    public DetectedLicensePlate locationX(Integer locationX) {
        this.locationX = locationX;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="X location of the left edge of the license plate, starting from the left edge of the photo (X = 0)")
    @JsonProperty(value="LocationX")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLocationX() {
        return this.locationX;
    }

    public void setLocationX(Integer locationX) {
        this.locationX = locationX;
    }

    public DetectedLicensePlate locationY(Integer locationY) {
        this.locationY = locationY;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Y location of the top edge of the license plate, starting from the top edge of the photo (Y = 0)")
    @JsonProperty(value="LocationY")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLocationY() {
        return this.locationY;
    }

    public void setLocationY(Integer locationY) {
        this.locationY = locationY;
    }

    public DetectedLicensePlate width(Integer width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Width of the license plate's location in pixels")
    @JsonProperty(value="Width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public DetectedLicensePlate height(Integer height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Height of the license plate's location in pixels")
    @JsonProperty(value="Height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public DetectedLicensePlate licensePlateRecognitionConfidenceLevel(Double licensePlateRecognitionConfidenceLevel) {
        this.licensePlateRecognitionConfidenceLevel = licensePlateRecognitionConfidenceLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Confidence score on a range of 0.0 - 1.0 of the accuracy of the detected license plate, with higher scores being better; values about 0.75 are high confidence")
    @JsonProperty(value="LicensePlateRecognitionConfidenceLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getLicensePlateRecognitionConfidenceLevel() {
        return this.licensePlateRecognitionConfidenceLevel;
    }

    public void setLicensePlateRecognitionConfidenceLevel(Double licensePlateRecognitionConfidenceLevel) {
        this.licensePlateRecognitionConfidenceLevel = licensePlateRecognitionConfidenceLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetectedLicensePlate detectedLicensePlate = (DetectedLicensePlate)o;
        return Objects.equals(this.licensePlateTextBestMatch, detectedLicensePlate.licensePlateTextBestMatch) && Objects.equals(this.licensePlateTextRunnerUp, detectedLicensePlate.licensePlateTextRunnerUp) && Objects.equals(this.locationX, detectedLicensePlate.locationX) && Objects.equals(this.locationY, detectedLicensePlate.locationY) && Objects.equals(this.width, detectedLicensePlate.width) && Objects.equals(this.height, detectedLicensePlate.height) && Objects.equals(this.licensePlateRecognitionConfidenceLevel, detectedLicensePlate.licensePlateRecognitionConfidenceLevel);
    }

    public int hashCode() {
        return Objects.hash(this.licensePlateTextBestMatch, this.licensePlateTextRunnerUp, this.locationX, this.locationY, this.width, this.height, this.licensePlateRecognitionConfidenceLevel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DetectedLicensePlate {\n");
        sb.append("    licensePlateTextBestMatch: ").append(this.toIndentedString(this.licensePlateTextBestMatch)).append("\n");
        sb.append("    licensePlateTextRunnerUp: ").append(this.toIndentedString(this.licensePlateTextRunnerUp)).append("\n");
        sb.append("    locationX: ").append(this.toIndentedString(this.locationX)).append("\n");
        sb.append("    locationY: ").append(this.toIndentedString(this.locationY)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    licensePlateRecognitionConfidenceLevel: ").append(this.toIndentedString(this.licensePlateRecognitionConfidenceLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

