/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a delete DOCX table row request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "TablePath", "TableRowRowIndex"})
@JsonTypeName(value="DeleteDocxTableRowRequest")
public class DeleteDocxTableRowRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_TABLE_PATH = "TablePath";
    private String tablePath;
    public static final String JSON_PROPERTY_TABLE_ROW_ROW_INDEX = "TableRowRowIndex";
    private Integer tableRowRowIndex;

    public DeleteDocxTableRowRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public DeleteDocxTableRowRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public DeleteDocxTableRowRequest tablePath(String tablePath) {
        this.tablePath = tablePath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path to the table to delete the row from")
    @JsonProperty(value="TablePath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTablePath() {
        return this.tablePath;
    }

    public void setTablePath(String tablePath) {
        this.tablePath = tablePath;
    }

    public DeleteDocxTableRowRequest tableRowRowIndex(Integer tableRowRowIndex) {
        this.tableRowRowIndex = tableRowRowIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="0-based index of the row to delete (e.g. 0, 1, 2, ...) in the table")
    @JsonProperty(value="TableRowRowIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTableRowRowIndex() {
        return this.tableRowRowIndex;
    }

    public void setTableRowRowIndex(Integer tableRowRowIndex) {
        this.tableRowRowIndex = tableRowRowIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteDocxTableRowRequest deleteDocxTableRowRequest = (DeleteDocxTableRowRequest)o;
        return Arrays.equals(this.inputFileBytes, deleteDocxTableRowRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, deleteDocxTableRowRequest.inputFileUrl) && Objects.equals(this.tablePath, deleteDocxTableRowRequest.tablePath) && Objects.equals(this.tableRowRowIndex, deleteDocxTableRowRequest.tableRowRowIndex);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.tablePath, this.tableRowRowIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeleteDocxTableRowRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    tablePath: ").append(this.toIndentedString(this.tablePath)).append("\n");
        sb.append("    tableRowRowIndex: ").append(this.toIndentedString(this.tableRowRowIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

