/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a delete DOCX table row range request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "TablePath", "TableRowRowIndexStart", "TableRowRowIndexEnd"})
@JsonTypeName(value="DeleteDocxTableRowRangeRequest")
public class DeleteDocxTableRowRangeRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_TABLE_PATH = "TablePath";
    private String tablePath;
    public static final String JSON_PROPERTY_TABLE_ROW_ROW_INDEX_START = "TableRowRowIndexStart";
    private Integer tableRowRowIndexStart;
    public static final String JSON_PROPERTY_TABLE_ROW_ROW_INDEX_END = "TableRowRowIndexEnd";
    private Integer tableRowRowIndexEnd;

    public DeleteDocxTableRowRangeRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public DeleteDocxTableRowRangeRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public DeleteDocxTableRowRangeRequest tablePath(String tablePath) {
        this.tablePath = tablePath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path to the table to delete the row from")
    @JsonProperty(value="TablePath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTablePath() {
        return this.tablePath;
    }

    public void setTablePath(String tablePath) {
        this.tablePath = tablePath;
    }

    public DeleteDocxTableRowRangeRequest tableRowRowIndexStart(Integer tableRowRowIndexStart) {
        this.tableRowRowIndexStart = tableRowRowIndexStart;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="0-based index of the row to begin deleting rows (e.g. 0, 1, 2, ...) in the table")
    @JsonProperty(value="TableRowRowIndexStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTableRowRowIndexStart() {
        return this.tableRowRowIndexStart;
    }

    public void setTableRowRowIndexStart(Integer tableRowRowIndexStart) {
        this.tableRowRowIndexStart = tableRowRowIndexStart;
    }

    public DeleteDocxTableRowRangeRequest tableRowRowIndexEnd(Integer tableRowRowIndexEnd) {
        this.tableRowRowIndexEnd = tableRowRowIndexEnd;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="0-based index of the row to stop deleting rows (e.g. 0, 1, 2, ...) in the table")
    @JsonProperty(value="TableRowRowIndexEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTableRowRowIndexEnd() {
        return this.tableRowRowIndexEnd;
    }

    public void setTableRowRowIndexEnd(Integer tableRowRowIndexEnd) {
        this.tableRowRowIndexEnd = tableRowRowIndexEnd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteDocxTableRowRangeRequest deleteDocxTableRowRangeRequest = (DeleteDocxTableRowRangeRequest)o;
        return Arrays.equals(this.inputFileBytes, deleteDocxTableRowRangeRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, deleteDocxTableRowRangeRequest.inputFileUrl) && Objects.equals(this.tablePath, deleteDocxTableRowRangeRequest.tablePath) && Objects.equals(this.tableRowRowIndexStart, deleteDocxTableRowRangeRequest.tableRowRowIndexStart) && Objects.equals(this.tableRowRowIndexEnd, deleteDocxTableRowRangeRequest.tableRowRowIndexEnd);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.tablePath, this.tableRowRowIndexStart, this.tableRowRowIndexEnd);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeleteDocxTableRowRangeRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    tablePath: ").append(this.toIndentedString(this.tablePath)).append("\n");
        sb.append("    tableRowRowIndexStart: ").append(this.toIndentedString(this.tableRowRowIndexStart)).append("\n");
        sb.append("    tableRowRowIndexEnd: ").append(this.toIndentedString(this.tableRowRowIndexEnd)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

