/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.CsvFileResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Collection of CSV Files")
@JsonPropertyOrder(value={"Successful", "CsvFiles", "FileCount"})
@JsonTypeName(value="CsvCollection")
public class CsvCollection {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_CSV_FILES = "CsvFiles";
    private List<CsvFileResult> csvFiles = null;
    public static final String JSON_PROPERTY_FILE_COUNT = "FileCount";
    private Integer fileCount;

    public CsvCollection successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public CsvCollection csvFiles(List<CsvFileResult> csvFiles) {
        this.csvFiles = csvFiles;
        return this;
    }

    public CsvCollection addCsvFilesItem(CsvFileResult csvFilesItem) {
        if (this.csvFiles == null) {
            this.csvFiles = new ArrayList<CsvFileResult>();
        }
        this.csvFiles.add(csvFilesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of CSV File results")
    @JsonProperty(value="CsvFiles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CsvFileResult> getCsvFiles() {
        return this.csvFiles;
    }

    public void setCsvFiles(List<CsvFileResult> csvFiles) {
        this.csvFiles = csvFiles;
    }

    public CsvCollection fileCount(Integer fileCount) {
        this.fileCount = fileCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Count of the number of CSV files produced")
    @JsonProperty(value="FileCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(Integer fileCount) {
        this.fileCount = fileCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsvCollection csvCollection = (CsvCollection)o;
        return Objects.equals(this.successful, csvCollection.successful) && Objects.equals(this.csvFiles, csvCollection.csvFiles) && Objects.equals(this.fileCount, csvCollection.fileCount);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.csvFiles, this.fileCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CsvCollection {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    csvFiles: ").append(this.toIndentedString(this.csvFiles)).append("\n");
        sb.append("    fileCount: ").append(this.toIndentedString(this.fileCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

