/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request to create a setting")
@JsonPropertyOrder(value={"BucketID", "BucketSecretKey", "SettingName", "SettingType", "SettingValue", "SettingDescription", "SettingTags"})
@JsonTypeName(value="CreateSettingRequest")
public class CreateSettingRequest {
    public static final String JSON_PROPERTY_BUCKET_I_D = "BucketID";
    private String bucketID;
    public static final String JSON_PROPERTY_BUCKET_SECRET_KEY = "BucketSecretKey";
    private String bucketSecretKey;
    public static final String JSON_PROPERTY_SETTING_NAME = "SettingName";
    private String settingName;
    public static final String JSON_PROPERTY_SETTING_TYPE = "SettingType";
    private String settingType;
    public static final String JSON_PROPERTY_SETTING_VALUE = "SettingValue";
    private Object settingValue;
    public static final String JSON_PROPERTY_SETTING_DESCRIPTION = "SettingDescription";
    private String settingDescription;
    public static final String JSON_PROPERTY_SETTING_TAGS = "SettingTags";
    private String settingTags;

    public CreateSettingRequest bucketID(String bucketID) {
        this.bucketID = bucketID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BucketID of the bucket to place the setting in; you can create a bucket by navigating to account.cloudmersive.com, clicking on Settings &gt; API Configuration &gt; Create Bucket")
    @JsonProperty(value="BucketID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBucketID() {
        return this.bucketID;
    }

    public void setBucketID(String bucketID) {
        this.bucketID = bucketID;
    }

    public CreateSettingRequest bucketSecretKey(String bucketSecretKey) {
        this.bucketSecretKey = bucketSecretKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SecretKey of the bucket to place the setting in; you can create a bucket by navigating to account.cloudmersive.com, clicking on Settings &gt; API Configuration &gt; Create Bucket")
    @JsonProperty(value="BucketSecretKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBucketSecretKey() {
        return this.bucketSecretKey;
    }

    public void setBucketSecretKey(String bucketSecretKey) {
        this.bucketSecretKey = bucketSecretKey;
    }

    public CreateSettingRequest settingName(String settingName) {
        this.settingName = settingName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the setting to create")
    @JsonProperty(value="SettingName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSettingName() {
        return this.settingName;
    }

    public void setSettingName(String settingName) {
        this.settingName = settingName;
    }

    public CreateSettingRequest settingType(String settingType) {
        this.settingType = settingType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of setting to create; possible values are STRING, JSON")
    @JsonProperty(value="SettingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSettingType() {
        return this.settingType;
    }

    public void setSettingType(String settingType) {
        this.settingType = settingType;
    }

    public CreateSettingRequest settingValue(Object settingValue) {
        this.settingValue = settingValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Initial value of the setting")
    @JsonProperty(value="SettingValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getSettingValue() {
        return this.settingValue;
    }

    public void setSettingValue(Object settingValue) {
        this.settingValue = settingValue;
    }

    public CreateSettingRequest settingDescription(String settingDescription) {
        this.settingDescription = settingDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the setting")
    @JsonProperty(value="SettingDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSettingDescription() {
        return this.settingDescription;
    }

    public void setSettingDescription(String settingDescription) {
        this.settingDescription = settingDescription;
    }

    public CreateSettingRequest settingTags(String settingTags) {
        this.settingTags = settingTags;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tags to apply to the setting")
    @JsonProperty(value="SettingTags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSettingTags() {
        return this.settingTags;
    }

    public void setSettingTags(String settingTags) {
        this.settingTags = settingTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSettingRequest createSettingRequest = (CreateSettingRequest)o;
        return Objects.equals(this.bucketID, createSettingRequest.bucketID) && Objects.equals(this.bucketSecretKey, createSettingRequest.bucketSecretKey) && Objects.equals(this.settingName, createSettingRequest.settingName) && Objects.equals(this.settingType, createSettingRequest.settingType) && Objects.equals(this.settingValue, createSettingRequest.settingValue) && Objects.equals(this.settingDescription, createSettingRequest.settingDescription) && Objects.equals(this.settingTags, createSettingRequest.settingTags);
    }

    public int hashCode() {
        return Objects.hash(this.bucketID, this.bucketSecretKey, this.settingName, this.settingType, this.settingValue, this.settingDescription, this.settingTags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateSettingRequest {\n");
        sb.append("    bucketID: ").append(this.toIndentedString(this.bucketID)).append("\n");
        sb.append("    bucketSecretKey: ").append(this.toIndentedString(this.bucketSecretKey)).append("\n");
        sb.append("    settingName: ").append(this.toIndentedString(this.settingName)).append("\n");
        sb.append("    settingType: ").append(this.toIndentedString(this.settingType)).append("\n");
        sb.append("    settingValue: ").append(this.toIndentedString(this.settingValue)).append("\n");
        sb.append("    settingDescription: ").append(this.toIndentedString(this.settingDescription)).append("\n");
        sb.append("    settingTags: ").append(this.toIndentedString(this.settingTags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

