/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.XlsxWorksheet;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a Clear Cell in XLSX Worksheet request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "WorksheetToUpdate", "RowIndex", "CellIndex"})
@JsonTypeName(value="ClearXlsxCellRequest")
public class ClearXlsxCellRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_WORKSHEET_TO_UPDATE = "WorksheetToUpdate";
    private XlsxWorksheet worksheetToUpdate;
    public static final String JSON_PROPERTY_ROW_INDEX = "RowIndex";
    private Integer rowIndex;
    public static final String JSON_PROPERTY_CELL_INDEX = "CellIndex";
    private Integer cellIndex;

    public ClearXlsxCellRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public ClearXlsxCellRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public ClearXlsxCellRequest worksheetToUpdate(XlsxWorksheet worksheetToUpdate) {
        this.worksheetToUpdate = worksheetToUpdate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="WorksheetToUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public XlsxWorksheet getWorksheetToUpdate() {
        return this.worksheetToUpdate;
    }

    public void setWorksheetToUpdate(XlsxWorksheet worksheetToUpdate) {
        this.worksheetToUpdate = worksheetToUpdate;
    }

    public ClearXlsxCellRequest rowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="0-based index of the row, 0, 1, 2, ... to clear")
    @JsonProperty(value="RowIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
    }

    public ClearXlsxCellRequest cellIndex(Integer cellIndex) {
        this.cellIndex = cellIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="0-based index of the cell, 0, 1, 2, ... in the row to clear")
    @JsonProperty(value="CellIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCellIndex() {
        return this.cellIndex;
    }

    public void setCellIndex(Integer cellIndex) {
        this.cellIndex = cellIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClearXlsxCellRequest clearXlsxCellRequest = (ClearXlsxCellRequest)o;
        return Arrays.equals(this.inputFileBytes, clearXlsxCellRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, clearXlsxCellRequest.inputFileUrl) && Objects.equals(this.worksheetToUpdate, clearXlsxCellRequest.worksheetToUpdate) && Objects.equals(this.rowIndex, clearXlsxCellRequest.rowIndex) && Objects.equals(this.cellIndex, clearXlsxCellRequest.cellIndex);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.worksheetToUpdate, this.rowIndex, this.cellIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClearXlsxCellRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    worksheetToUpdate: ").append(this.toIndentedString(this.worksheetToUpdate)).append("\n");
        sb.append("    rowIndex: ").append(this.toIndentedString(this.rowIndex)).append("\n");
        sb.append("    cellIndex: ").append(this.toIndentedString(this.cellIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

