/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Result of recognizing a business card, to extract the key information from the business card")
@JsonPropertyOrder(value={"Successful", "PersonName", "PersonTitle", "BusinessName", "AddressString", "PhoneNumber", "EmailAddress", "Timestamp"})
@JsonTypeName(value="BusinessCardRecognitionResult")
public class BusinessCardRecognitionResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_PERSON_NAME = "PersonName";
    private String personName;
    public static final String JSON_PROPERTY_PERSON_TITLE = "PersonTitle";
    private String personTitle;
    public static final String JSON_PROPERTY_BUSINESS_NAME = "BusinessName";
    private String businessName;
    public static final String JSON_PROPERTY_ADDRESS_STRING = "AddressString";
    private String addressString;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "PhoneNumber";
    private String phoneNumber;
    public static final String JSON_PROPERTY_EMAIL_ADDRESS = "EmailAddress";
    private String emailAddress;
    public static final String JSON_PROPERTY_TIMESTAMP = "Timestamp";
    private OffsetDateTime timestamp;

    public BusinessCardRecognitionResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public BusinessCardRecognitionResult personName(String personName) {
        this.personName = personName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the person printed on the business card (if included on the business card)")
    @JsonProperty(value="PersonName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPersonName() {
        return this.personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public BusinessCardRecognitionResult personTitle(String personTitle) {
        this.personTitle = personTitle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The title of the person printed on the business card (if included on the business card)")
    @JsonProperty(value="PersonTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPersonTitle() {
        return this.personTitle;
    }

    public void setPersonTitle(String personTitle) {
        this.personTitle = personTitle;
    }

    public BusinessCardRecognitionResult businessName(String businessName) {
        this.businessName = businessName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the business printed on the business card (if included on the business card)")
    @JsonProperty(value="BusinessName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBusinessName() {
        return this.businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public BusinessCardRecognitionResult addressString(String addressString) {
        this.addressString = addressString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The address printed on the business card (if included on the business card)")
    @JsonProperty(value="AddressString")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddressString() {
        return this.addressString;
    }

    public void setAddressString(String addressString) {
        this.addressString = addressString;
    }

    public BusinessCardRecognitionResult phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The phone number printed on the business card (if included on the business card)")
    @JsonProperty(value="PhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public BusinessCardRecognitionResult emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The email address printed on the business card (if included on the business card)")
    @JsonProperty(value="EmailAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public BusinessCardRecognitionResult timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time printed on the business card (if included on the business card)")
    @JsonProperty(value="Timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessCardRecognitionResult businessCardRecognitionResult = (BusinessCardRecognitionResult)o;
        return Objects.equals(this.successful, businessCardRecognitionResult.successful) && Objects.equals(this.personName, businessCardRecognitionResult.personName) && Objects.equals(this.personTitle, businessCardRecognitionResult.personTitle) && Objects.equals(this.businessName, businessCardRecognitionResult.businessName) && Objects.equals(this.addressString, businessCardRecognitionResult.addressString) && Objects.equals(this.phoneNumber, businessCardRecognitionResult.phoneNumber) && Objects.equals(this.emailAddress, businessCardRecognitionResult.emailAddress) && Objects.equals(this.timestamp, businessCardRecognitionResult.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.personName, this.personTitle, this.businessName, this.addressString, this.phoneNumber, this.emailAddress, this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessCardRecognitionResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    personName: ").append(this.toIndentedString(this.personName)).append("\n");
        sb.append("    personTitle: ").append(this.toIndentedString(this.personTitle)).append("\n");
        sb.append("    businessName: ").append(this.toIndentedString(this.businessName)).append("\n");
        sb.append("    addressString: ").append(this.toIndentedString(this.addressString)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

