/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of the barcode scan")
@JsonPropertyOrder(value={"Successful", "BarcodeType", "RawText"})
@JsonTypeName(value="BarcodeScanResult")
public class BarcodeScanResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_BARCODE_TYPE = "BarcodeType";
    private String barcodeType;
    public static final String JSON_PROPERTY_RAW_TEXT = "RawText";
    private String rawText;

    public BarcodeScanResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public BarcodeScanResult barcodeType(String barcodeType) {
        this.barcodeType = barcodeType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the barcode; possible values are AZTEC, CODABAR, CODE_39, CODE_93, CODE_128, DATA_MATRIX, EAN_8, EAN_13, ITF, MAXICODE, PDF_417, QR_CODE, RSS_14, RSS_EXPANDED, UPC_A, UPC_E, All_1D, UPC_EAN_EXTENSION, MSI, PLESSEY, IMB")
    @JsonProperty(value="BarcodeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBarcodeType() {
        return this.barcodeType;
    }

    public void setBarcodeType(String barcodeType) {
        this.barcodeType = barcodeType;
    }

    public BarcodeScanResult rawText(String rawText) {
        this.rawText = rawText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The barcode text")
    @JsonProperty(value="RawText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRawText() {
        return this.rawText;
    }

    public void setRawText(String rawText) {
        this.rawText = rawText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BarcodeScanResult barcodeScanResult = (BarcodeScanResult)o;
        return Objects.equals(this.successful, barcodeScanResult.successful) && Objects.equals(this.barcodeType, barcodeScanResult.barcodeType) && Objects.equals(this.rawText, barcodeScanResult.rawText);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.barcodeType, this.rawText);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BarcodeScanResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    barcodeType: ").append(this.toIndentedString(this.barcodeType)).append("\n");
        sb.append("    rawText: ").append(this.toIndentedString(this.rawText)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

