/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Details of a specific currency")
@JsonPropertyOrder(value={"ISOCurrencyCode", "CurrencySymbol", "CurrencyEnglishName", "CountryName", "CountryThreeLetterCode", "CountryISOTwoLetterCode", "IsEuropeanUnionMember"})
@JsonTypeName(value="AvailableCurrency")
public class AvailableCurrency {
    public static final String JSON_PROPERTY_IS_O_CURRENCY_CODE = "ISOCurrencyCode";
    private String isOCurrencyCode;
    public static final String JSON_PROPERTY_CURRENCY_SYMBOL = "CurrencySymbol";
    private String currencySymbol;
    public static final String JSON_PROPERTY_CURRENCY_ENGLISH_NAME = "CurrencyEnglishName";
    private String currencyEnglishName;
    public static final String JSON_PROPERTY_COUNTRY_NAME = "CountryName";
    private String countryName;
    public static final String JSON_PROPERTY_COUNTRY_THREE_LETTER_CODE = "CountryThreeLetterCode";
    private String countryThreeLetterCode;
    public static final String JSON_PROPERTY_COUNTRY_I_S_O_TWO_LETTER_CODE = "CountryISOTwoLetterCode";
    private String countryISOTwoLetterCode;
    public static final String JSON_PROPERTY_IS_EUROPEAN_UNION_MEMBER = "IsEuropeanUnionMember";
    private Boolean isEuropeanUnionMember;

    public AvailableCurrency isOCurrencyCode(String isOCurrencyCode) {
        this.isOCurrencyCode = isOCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO 4217 currency three-letter code associated with the country")
    @JsonProperty(value="ISOCurrencyCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIsOCurrencyCode() {
        return this.isOCurrencyCode;
    }

    public void setIsOCurrencyCode(String isOCurrencyCode) {
        this.isOCurrencyCode = isOCurrencyCode;
    }

    public AvailableCurrency currencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Symbol associated with the currency")
    @JsonProperty(value="CurrencySymbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public AvailableCurrency currencyEnglishName(String currencyEnglishName) {
        this.currencyEnglishName = currencyEnglishName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Full name of the currency")
    @JsonProperty(value="CurrencyEnglishName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrencyEnglishName() {
        return this.currencyEnglishName;
    }

    public void setCurrencyEnglishName(String currencyEnglishName) {
        this.currencyEnglishName = currencyEnglishName;
    }

    public AvailableCurrency countryName(String countryName) {
        this.countryName = countryName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the country")
    @JsonProperty(value="CountryName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public AvailableCurrency countryThreeLetterCode(String countryThreeLetterCode) {
        this.countryThreeLetterCode = countryThreeLetterCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Three-letter ISO 3166-1 country code")
    @JsonProperty(value="CountryThreeLetterCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryThreeLetterCode() {
        return this.countryThreeLetterCode;
    }

    public void setCountryThreeLetterCode(String countryThreeLetterCode) {
        this.countryThreeLetterCode = countryThreeLetterCode;
    }

    public AvailableCurrency countryISOTwoLetterCode(String countryISOTwoLetterCode) {
        this.countryISOTwoLetterCode = countryISOTwoLetterCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Two-letter ISO 3166-1 country code")
    @JsonProperty(value="CountryISOTwoLetterCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryISOTwoLetterCode() {
        return this.countryISOTwoLetterCode;
    }

    public void setCountryISOTwoLetterCode(String countryISOTwoLetterCode) {
        this.countryISOTwoLetterCode = countryISOTwoLetterCode;
    }

    public AvailableCurrency isEuropeanUnionMember(Boolean isEuropeanUnionMember) {
        this.isEuropeanUnionMember = isEuropeanUnionMember;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if this country is currently a member of the European Union (EU), false otherwise")
    @JsonProperty(value="IsEuropeanUnionMember")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEuropeanUnionMember() {
        return this.isEuropeanUnionMember;
    }

    public void setIsEuropeanUnionMember(Boolean isEuropeanUnionMember) {
        this.isEuropeanUnionMember = isEuropeanUnionMember;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailableCurrency availableCurrency = (AvailableCurrency)o;
        return Objects.equals(this.isOCurrencyCode, availableCurrency.isOCurrencyCode) && Objects.equals(this.currencySymbol, availableCurrency.currencySymbol) && Objects.equals(this.currencyEnglishName, availableCurrency.currencyEnglishName) && Objects.equals(this.countryName, availableCurrency.countryName) && Objects.equals(this.countryThreeLetterCode, availableCurrency.countryThreeLetterCode) && Objects.equals(this.countryISOTwoLetterCode, availableCurrency.countryISOTwoLetterCode) && Objects.equals(this.isEuropeanUnionMember, availableCurrency.isEuropeanUnionMember);
    }

    public int hashCode() {
        return Objects.hash(this.isOCurrencyCode, this.currencySymbol, this.currencyEnglishName, this.countryName, this.countryThreeLetterCode, this.countryISOTwoLetterCode, this.isEuropeanUnionMember);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AvailableCurrency {\n");
        sb.append("    isOCurrencyCode: ").append(this.toIndentedString(this.isOCurrencyCode)).append("\n");
        sb.append("    currencySymbol: ").append(this.toIndentedString(this.currencySymbol)).append("\n");
        sb.append("    currencyEnglishName: ").append(this.toIndentedString(this.currencyEnglishName)).append("\n");
        sb.append("    countryName: ").append(this.toIndentedString(this.countryName)).append("\n");
        sb.append("    countryThreeLetterCode: ").append(this.toIndentedString(this.countryThreeLetterCode)).append("\n");
        sb.append("    countryISOTwoLetterCode: ").append(this.toIndentedString(this.countryISOTwoLetterCode)).append("\n");
        sb.append("    isEuropeanUnionMember: ").append(this.toIndentedString(this.isEuropeanUnionMember)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

