/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.Thumbnail;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result of converting an entire document to an array of PNG thumbnails")
@JsonPropertyOrder(value={"Successful", "ThumbnailPages"})
@JsonTypeName(value="AutodetectToThumbnailsResult")
public class AutodetectToThumbnailsResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_THUMBNAIL_PAGES = "ThumbnailPages";
    private List<Thumbnail> thumbnailPages = null;

    public AutodetectToThumbnailsResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Index of this thumbnail")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public AutodetectToThumbnailsResult thumbnailPages(List<Thumbnail> thumbnailPages) {
        this.thumbnailPages = thumbnailPages;
        return this;
    }

    public AutodetectToThumbnailsResult addThumbnailPagesItem(Thumbnail thumbnailPagesItem) {
        if (this.thumbnailPages == null) {
            this.thumbnailPages = new ArrayList<Thumbnail>();
        }
        this.thumbnailPages.add(thumbnailPagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A PNG thumbnail of the document page")
    @JsonProperty(value="ThumbnailPages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Thumbnail> getThumbnailPages() {
        return this.thumbnailPages;
    }

    public void setThumbnailPages(List<Thumbnail> thumbnailPages) {
        this.thumbnailPages = thumbnailPages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutodetectToThumbnailsResult autodetectToThumbnailsResult = (AutodetectToThumbnailsResult)o;
        return Objects.equals(this.successful, autodetectToThumbnailsResult.successful) && Objects.equals(this.thumbnailPages, autodetectToThumbnailsResult.thumbnailPages);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.thumbnailPages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutodetectToThumbnailsResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    thumbnailPages: ").append(this.toIndentedString(this.thumbnailPages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

