/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.AlternateFileFormatCandidate;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Result of an autodetect/get-info operation")
@JsonPropertyOrder(value={"Successful", "DetectedFileExtension", "DetectedMimeType", "PageCount", "Author", "DateModified", "AlternateFileTypeCandidates"})
@JsonTypeName(value="AutodetectGetInfoResult")
public class AutodetectGetInfoResult {
    public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
    private Boolean successful;
    public static final String JSON_PROPERTY_DETECTED_FILE_EXTENSION = "DetectedFileExtension";
    private String detectedFileExtension;
    public static final String JSON_PROPERTY_DETECTED_MIME_TYPE = "DetectedMimeType";
    private String detectedMimeType;
    public static final String JSON_PROPERTY_PAGE_COUNT = "PageCount";
    private Long pageCount;
    public static final String JSON_PROPERTY_AUTHOR = "Author";
    private String author;
    public static final String JSON_PROPERTY_DATE_MODIFIED = "DateModified";
    private OffsetDateTime dateModified;
    public static final String JSON_PROPERTY_ALTERNATE_FILE_TYPE_CANDIDATES = "AlternateFileTypeCandidates";
    private List<AlternateFileFormatCandidate> alternateFileTypeCandidates = null;

    public AutodetectGetInfoResult successful(Boolean successful) {
        this.successful = successful;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the operation was successful, false otherwise")
    @JsonProperty(value="Successful")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public AutodetectGetInfoResult detectedFileExtension(String detectedFileExtension) {
        this.detectedFileExtension = detectedFileExtension;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Detected file extension of the file format, with a leading period")
    @JsonProperty(value="DetectedFileExtension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDetectedFileExtension() {
        return this.detectedFileExtension;
    }

    public void setDetectedFileExtension(String detectedFileExtension) {
        this.detectedFileExtension = detectedFileExtension;
    }

    public AutodetectGetInfoResult detectedMimeType(String detectedMimeType) {
        this.detectedMimeType = detectedMimeType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MIME type of this file extension")
    @JsonProperty(value="DetectedMimeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDetectedMimeType() {
        return this.detectedMimeType;
    }

    public void setDetectedMimeType(String detectedMimeType) {
        this.detectedMimeType = detectedMimeType;
    }

    public AutodetectGetInfoResult pageCount(Long pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of pages in a page-based document; for presentations, this is the number of slides and for a spreadsheet this is the number of worksheets.  Contains 0 when the page count cannot be determined, or if the concept of page count does not apply (e.g. for an image)")
    @JsonProperty(value="PageCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(Long pageCount) {
        this.pageCount = pageCount;
    }

    public AutodetectGetInfoResult author(String author) {
        this.author = author;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User name of the creator/author of the document, if available, null if not available")
    @JsonProperty(value="Author")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public AutodetectGetInfoResult dateModified(OffsetDateTime dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The timestamp that the document was last modified, if available, null if not available")
    @JsonProperty(value="DateModified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(OffsetDateTime dateModified) {
        this.dateModified = dateModified;
    }

    public AutodetectGetInfoResult alternateFileTypeCandidates(List<AlternateFileFormatCandidate> alternateFileTypeCandidates) {
        this.alternateFileTypeCandidates = alternateFileTypeCandidates;
        return this;
    }

    public AutodetectGetInfoResult addAlternateFileTypeCandidatesItem(AlternateFileFormatCandidate alternateFileTypeCandidatesItem) {
        if (this.alternateFileTypeCandidates == null) {
            this.alternateFileTypeCandidates = new ArrayList<AlternateFileFormatCandidate>();
        }
        this.alternateFileTypeCandidates.add(alternateFileTypeCandidatesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Alternate file type options and their probability")
    @JsonProperty(value="AlternateFileTypeCandidates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AlternateFileFormatCandidate> getAlternateFileTypeCandidates() {
        return this.alternateFileTypeCandidates;
    }

    public void setAlternateFileTypeCandidates(List<AlternateFileFormatCandidate> alternateFileTypeCandidates) {
        this.alternateFileTypeCandidates = alternateFileTypeCandidates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutodetectGetInfoResult autodetectGetInfoResult = (AutodetectGetInfoResult)o;
        return Objects.equals(this.successful, autodetectGetInfoResult.successful) && Objects.equals(this.detectedFileExtension, autodetectGetInfoResult.detectedFileExtension) && Objects.equals(this.detectedMimeType, autodetectGetInfoResult.detectedMimeType) && Objects.equals(this.pageCount, autodetectGetInfoResult.pageCount) && Objects.equals(this.author, autodetectGetInfoResult.author) && Objects.equals(this.dateModified, autodetectGetInfoResult.dateModified) && Objects.equals(this.alternateFileTypeCandidates, autodetectGetInfoResult.alternateFileTypeCandidates);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.detectedFileExtension, this.detectedMimeType, this.pageCount, this.author, this.dateModified, this.alternateFileTypeCandidates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutodetectGetInfoResult {\n");
        sb.append("    successful: ").append(this.toIndentedString(this.successful)).append("\n");
        sb.append("    detectedFileExtension: ").append(this.toIndentedString(this.detectedFileExtension)).append("\n");
        sb.append("    detectedMimeType: ").append(this.toIndentedString(this.detectedMimeType)).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.pageCount)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    alternateFileTypeCandidates: ").append(this.toIndentedString(this.alternateFileTypeCandidates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

