/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.cloudmersive.client.rt.model.XlsxSpreadsheetRow;
import com.cloudmersive.client.rt.model.XlsxWorksheet;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Input to a Append-Row request")
@JsonPropertyOrder(value={"InputFileBytes", "InputFileUrl", "WorksheetToUpdate", "Row"})
@JsonTypeName(value="AppendXlsxRowRequest")
public class AppendXlsxRowRequest {
    public static final String JSON_PROPERTY_INPUT_FILE_BYTES = "InputFileBytes";
    private byte[] inputFileBytes;
    public static final String JSON_PROPERTY_INPUT_FILE_URL = "InputFileUrl";
    private String inputFileUrl;
    public static final String JSON_PROPERTY_WORKSHEET_TO_UPDATE = "WorksheetToUpdate";
    private XlsxWorksheet worksheetToUpdate;
    public static final String JSON_PROPERTY_ROW = "Row";
    private XlsxSpreadsheetRow row;

    public AppendXlsxRowRequest inputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Bytes of the input file to operate on")
    @JsonProperty(value="InputFileBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getInputFileBytes() {
        return this.inputFileBytes;
    }

    public void setInputFileBytes(byte[] inputFileBytes) {
        this.inputFileBytes = inputFileBytes;
    }

    public AppendXlsxRowRequest inputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: URL of a file to operate on as input.  This can be a public URL, or you can also use the begin-editing API to upload a document and pass in the secure URL result from that operation as the URL here (this URL is not public).")
    @JsonProperty(value="InputFileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInputFileUrl() {
        return this.inputFileUrl;
    }

    public void setInputFileUrl(String inputFileUrl) {
        this.inputFileUrl = inputFileUrl;
    }

    public AppendXlsxRowRequest worksheetToUpdate(XlsxWorksheet worksheetToUpdate) {
        this.worksheetToUpdate = worksheetToUpdate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="WorksheetToUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public XlsxWorksheet getWorksheetToUpdate() {
        return this.worksheetToUpdate;
    }

    public void setWorksheetToUpdate(XlsxWorksheet worksheetToUpdate) {
        this.worksheetToUpdate = worksheetToUpdate;
    }

    public AppendXlsxRowRequest row(XlsxSpreadsheetRow row) {
        this.row = row;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="Row")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public XlsxSpreadsheetRow getRow() {
        return this.row;
    }

    public void setRow(XlsxSpreadsheetRow row) {
        this.row = row;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppendXlsxRowRequest appendXlsxRowRequest = (AppendXlsxRowRequest)o;
        return Arrays.equals(this.inputFileBytes, appendXlsxRowRequest.inputFileBytes) && Objects.equals(this.inputFileUrl, appendXlsxRowRequest.inputFileUrl) && Objects.equals(this.worksheetToUpdate, appendXlsxRowRequest.worksheetToUpdate) && Objects.equals(this.row, appendXlsxRowRequest.row);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.inputFileBytes), this.inputFileUrl, this.worksheetToUpdate, this.row);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppendXlsxRowRequest {\n");
        sb.append("    inputFileBytes: ").append(this.toIndentedString(this.inputFileBytes)).append("\n");
        sb.append("    inputFileUrl: ").append(this.toIndentedString(this.inputFileUrl)).append("\n");
        sb.append("    worksheetToUpdate: ").append(this.toIndentedString(this.worksheetToUpdate)).append("\n");
        sb.append("    row: ").append(this.toIndentedString(this.row)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

