/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Alternate file format possibility")
@JsonPropertyOrder(value={"Probability", "DetectedFileExtension", "DetectedMimeType"})
@JsonTypeName(value="AlternateFileFormatCandidate")
public class AlternateFileFormatCandidate {
    public static final String JSON_PROPERTY_PROBABILITY = "Probability";
    private Double probability;
    public static final String JSON_PROPERTY_DETECTED_FILE_EXTENSION = "DetectedFileExtension";
    private String detectedFileExtension;
    public static final String JSON_PROPERTY_DETECTED_MIME_TYPE = "DetectedMimeType";
    private String detectedMimeType;

    public AlternateFileFormatCandidate probability(Double probability) {
        this.probability = probability;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Probability that this extension is the right one; possible values are between 0.0 (lowest confidence) and 1.0 (highest confidence)")
    @JsonProperty(value="Probability")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getProbability() {
        return this.probability;
    }

    public void setProbability(Double probability) {
        this.probability = probability;
    }

    public AlternateFileFormatCandidate detectedFileExtension(String detectedFileExtension) {
        this.detectedFileExtension = detectedFileExtension;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Detected file extension of the file format, with a leading period")
    @JsonProperty(value="DetectedFileExtension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDetectedFileExtension() {
        return this.detectedFileExtension;
    }

    public void setDetectedFileExtension(String detectedFileExtension) {
        this.detectedFileExtension = detectedFileExtension;
    }

    public AlternateFileFormatCandidate detectedMimeType(String detectedMimeType) {
        this.detectedMimeType = detectedMimeType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MIME type of this file extension")
    @JsonProperty(value="DetectedMimeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDetectedMimeType() {
        return this.detectedMimeType;
    }

    public void setDetectedMimeType(String detectedMimeType) {
        this.detectedMimeType = detectedMimeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlternateFileFormatCandidate alternateFileFormatCandidate = (AlternateFileFormatCandidate)o;
        return Objects.equals(this.probability, alternateFileFormatCandidate.probability) && Objects.equals(this.detectedFileExtension, alternateFileFormatCandidate.detectedFileExtension) && Objects.equals(this.detectedMimeType, alternateFileFormatCandidate.detectedMimeType);
    }

    public int hashCode() {
        return Objects.hash(this.probability, this.detectedFileExtension, this.detectedMimeType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlternateFileFormatCandidate {\n");
        sb.append("    probability: ").append(this.toIndentedString(this.probability)).append("\n");
        sb.append("    detectedFileExtension: ").append(this.toIndentedString(this.detectedFileExtension)).append("\n");
        sb.append("    detectedMimeType: ").append(this.toIndentedString(this.detectedMimeType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

