/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Syntactic validity of email address")
@JsonPropertyOrder(value={"ValidAddress", "Domain", "IsFreeEmailProvider", "IsDisposable"})
@JsonTypeName(value="AddressVerifySyntaxOnlyResponse")
public class AddressVerifySyntaxOnlyResponse {
    public static final String JSON_PROPERTY_VALID_ADDRESS = "ValidAddress";
    private Boolean validAddress;
    public static final String JSON_PROPERTY_DOMAIN = "Domain";
    private String domain;
    public static final String JSON_PROPERTY_IS_FREE_EMAIL_PROVIDER = "IsFreeEmailProvider";
    private Boolean isFreeEmailProvider;
    public static final String JSON_PROPERTY_IS_DISPOSABLE = "IsDisposable";
    private Boolean isDisposable;

    public AddressVerifySyntaxOnlyResponse validAddress(Boolean validAddress) {
        this.validAddress = validAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the email address is syntactically valid, false if it is not")
    @JsonProperty(value="ValidAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getValidAddress() {
        return this.validAddress;
    }

    public void setValidAddress(Boolean validAddress) {
        this.validAddress = validAddress;
    }

    public AddressVerifySyntaxOnlyResponse domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Domain name of the email address")
    @JsonProperty(value="Domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public AddressVerifySyntaxOnlyResponse isFreeEmailProvider(Boolean isFreeEmailProvider) {
        this.isFreeEmailProvider = isFreeEmailProvider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the email domain name is a free provider (typically a free to sign up web email provider for consumers / personal use), false otherwise.")
    @JsonProperty(value="IsFreeEmailProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsFreeEmailProvider() {
        return this.isFreeEmailProvider;
    }

    public void setIsFreeEmailProvider(Boolean isFreeEmailProvider) {
        this.isFreeEmailProvider = isFreeEmailProvider;
    }

    public AddressVerifySyntaxOnlyResponse isDisposable(Boolean isDisposable) {
        this.isDisposable = isDisposable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the email address is a disposable email address, false otherwise; these disposable providers are not typically used to receive email and so will have a low likelihood of opening mail sent there.")
    @JsonProperty(value="IsDisposable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsDisposable() {
        return this.isDisposable;
    }

    public void setIsDisposable(Boolean isDisposable) {
        this.isDisposable = isDisposable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressVerifySyntaxOnlyResponse addressVerifySyntaxOnlyResponse = (AddressVerifySyntaxOnlyResponse)o;
        return Objects.equals(this.validAddress, addressVerifySyntaxOnlyResponse.validAddress) && Objects.equals(this.domain, addressVerifySyntaxOnlyResponse.domain) && Objects.equals(this.isFreeEmailProvider, addressVerifySyntaxOnlyResponse.isFreeEmailProvider) && Objects.equals(this.isDisposable, addressVerifySyntaxOnlyResponse.isDisposable);
    }

    public int hashCode() {
        return Objects.hash(this.validAddress, this.domain, this.isFreeEmailProvider, this.isDisposable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressVerifySyntaxOnlyResponse {\n");
        sb.append("    validAddress: ").append(this.toIndentedString(this.validAddress)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    isFreeEmailProvider: ").append(this.toIndentedString(this.isFreeEmailProvider)).append("\n");
        sb.append("    isDisposable: ").append(this.toIndentedString(this.isDisposable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

