/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt;

import com.cloudmersive.client.rt.invoker.ApiClient;
import com.cloudmersive.client.rt.model.MediaInformation;
import com.cloudmersive.client.rt.model.NsfwResult;
import com.cloudmersive.client.rt.model.SplitVideoResult;
import com.cloudmersive.client.rt.model.StillFramesResult;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.threeten.bp.OffsetDateTime;

@Component(value="com.cloudmersive.client.rt.VideoApi")
public class VideoApi {
    private ApiClient apiClient;

    public VideoApi() {
        this(new ApiClient());
    }

    @Autowired
    public VideoApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public byte[] videoConvertToGif(String fileUrl, Integer maxWidth, Integer maxHeight, Boolean preserveAspectRatio, Integer frameRate, OffsetDateTime startTime, OffsetDateTime timeSpan, Resource inputFile) throws RestClientException {
        return (byte[])this.videoConvertToGifWithHttpInfo(fileUrl, maxWidth, maxHeight, preserveAspectRatio, frameRate, startTime, timeSpan, inputFile).getBody();
    }

    public ResponseEntity<byte[]> videoConvertToGifWithHttpInfo(String fileUrl, Integer maxWidth, Integer maxHeight, Boolean preserveAspectRatio, Integer frameRate, OffsetDateTime startTime, OffsetDateTime timeSpan, Resource inputFile) throws RestClientException {
        Object postBody = null;
        String path = this.apiClient.expandPath("/video/convert/to/gif", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (fileUrl != null) {
            headerParams.add("fileUrl", this.apiClient.parameterToString(fileUrl));
        }
        if (maxWidth != null) {
            headerParams.add("maxWidth", this.apiClient.parameterToString(maxWidth));
        }
        if (maxHeight != null) {
            headerParams.add("maxHeight", this.apiClient.parameterToString(maxHeight));
        }
        if (preserveAspectRatio != null) {
            headerParams.add("preserveAspectRatio", this.apiClient.parameterToString(preserveAspectRatio));
        }
        if (frameRate != null) {
            headerParams.add("frameRate", this.apiClient.parameterToString(frameRate));
        }
        if (startTime != null) {
            headerParams.add("startTime", this.apiClient.parameterToString(startTime));
        }
        if (timeSpan != null) {
            headerParams.add("timeSpan", this.apiClient.parameterToString(timeSpan));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] videoConvertToMov(String fileUrl, Integer maxWidth, Integer maxHeight, Boolean preserveAspectRatio, Integer frameRate, Integer quality, Resource inputFile) throws RestClientException {
        return (byte[])this.videoConvertToMovWithHttpInfo(fileUrl, maxWidth, maxHeight, preserveAspectRatio, frameRate, quality, inputFile).getBody();
    }

    public ResponseEntity<byte[]> videoConvertToMovWithHttpInfo(String fileUrl, Integer maxWidth, Integer maxHeight, Boolean preserveAspectRatio, Integer frameRate, Integer quality, Resource inputFile) throws RestClientException {
        Object postBody = null;
        String path = this.apiClient.expandPath("/video/convert/to/mov", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (fileUrl != null) {
            headerParams.add("fileUrl", this.apiClient.parameterToString(fileUrl));
        }
        if (maxWidth != null) {
            headerParams.add("maxWidth", this.apiClient.parameterToString(maxWidth));
        }
        if (maxHeight != null) {
            headerParams.add("maxHeight", this.apiClient.parameterToString(maxHeight));
        }
        if (preserveAspectRatio != null) {
            headerParams.add("preserveAspectRatio", this.apiClient.parameterToString(preserveAspectRatio));
        }
        if (frameRate != null) {
            headerParams.add("frameRate", this.apiClient.parameterToString(frameRate));
        }
        if (quality != null) {
            headerParams.add("quality", this.apiClient.parameterToString(quality));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] videoConvertToMp4(String fileUrl, Integer maxWidth, Integer maxHeight, Boolean preserveAspectRatio, Integer frameRate, Integer quality, Resource inputFile) throws RestClientException {
        return (byte[])this.videoConvertToMp4WithHttpInfo(fileUrl, maxWidth, maxHeight, preserveAspectRatio, frameRate, quality, inputFile).getBody();
    }

    public ResponseEntity<byte[]> videoConvertToMp4WithHttpInfo(String fileUrl, Integer maxWidth, Integer maxHeight, Boolean preserveAspectRatio, Integer frameRate, Integer quality, Resource inputFile) throws RestClientException {
        Object postBody = null;
        String path = this.apiClient.expandPath("/video/convert/to/mp4", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (fileUrl != null) {
            headerParams.add("fileUrl", this.apiClient.parameterToString(fileUrl));
        }
        if (maxWidth != null) {
            headerParams.add("maxWidth", this.apiClient.parameterToString(maxWidth));
        }
        if (maxHeight != null) {
            headerParams.add("maxHeight", this.apiClient.parameterToString(maxHeight));
        }
        if (preserveAspectRatio != null) {
            headerParams.add("preserveAspectRatio", this.apiClient.parameterToString(preserveAspectRatio));
        }
        if (frameRate != null) {
            headerParams.add("frameRate", this.apiClient.parameterToString(frameRate));
        }
        if (quality != null) {
            headerParams.add("quality", this.apiClient.parameterToString(quality));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public StillFramesResult videoConvertToStillFrames(String fileUrl, Integer maxWidth, Integer maxHeight, BigDecimal framesPerSecond, Resource inputFile) throws RestClientException {
        return (StillFramesResult)this.videoConvertToStillFramesWithHttpInfo(fileUrl, maxWidth, maxHeight, framesPerSecond, inputFile).getBody();
    }

    public ResponseEntity<StillFramesResult> videoConvertToStillFramesWithHttpInfo(String fileUrl, Integer maxWidth, Integer maxHeight, BigDecimal framesPerSecond, Resource inputFile) throws RestClientException {
        Object postBody = null;
        String path = this.apiClient.expandPath("/video/convert/to/still-frames", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (fileUrl != null) {
            headerParams.add("fileUrl", this.apiClient.parameterToString(fileUrl));
        }
        if (maxWidth != null) {
            headerParams.add("maxWidth", this.apiClient.parameterToString(maxWidth));
        }
        if (maxHeight != null) {
            headerParams.add("maxHeight", this.apiClient.parameterToString(maxHeight));
        }
        if (framesPerSecond != null) {
            headerParams.add("framesPerSecond", this.apiClient.parameterToString(framesPerSecond));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<StillFramesResult> returnType = new ParameterizedTypeReference<StillFramesResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] videoConvertToWebm(String fileUrl, Integer maxWidth, Integer maxHeight, Boolean preserveAspectRatio, Integer frameRate, Integer quality, Resource inputFile) throws RestClientException {
        return (byte[])this.videoConvertToWebmWithHttpInfo(fileUrl, maxWidth, maxHeight, preserveAspectRatio, frameRate, quality, inputFile).getBody();
    }

    public ResponseEntity<byte[]> videoConvertToWebmWithHttpInfo(String fileUrl, Integer maxWidth, Integer maxHeight, Boolean preserveAspectRatio, Integer frameRate, Integer quality, Resource inputFile) throws RestClientException {
        Object postBody = null;
        String path = this.apiClient.expandPath("/video/convert/to/webm", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (fileUrl != null) {
            headerParams.add("fileUrl", this.apiClient.parameterToString(fileUrl));
        }
        if (maxWidth != null) {
            headerParams.add("maxWidth", this.apiClient.parameterToString(maxWidth));
        }
        if (maxHeight != null) {
            headerParams.add("maxHeight", this.apiClient.parameterToString(maxHeight));
        }
        if (preserveAspectRatio != null) {
            headerParams.add("preserveAspectRatio", this.apiClient.parameterToString(preserveAspectRatio));
        }
        if (frameRate != null) {
            headerParams.add("frameRate", this.apiClient.parameterToString(frameRate));
        }
        if (quality != null) {
            headerParams.add("quality", this.apiClient.parameterToString(quality));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] videoCutVideo(String fileUrl, OffsetDateTime startTime, OffsetDateTime timeSpan, Resource inputFile) throws RestClientException {
        return (byte[])this.videoCutVideoWithHttpInfo(fileUrl, startTime, timeSpan, inputFile).getBody();
    }

    public ResponseEntity<byte[]> videoCutVideoWithHttpInfo(String fileUrl, OffsetDateTime startTime, OffsetDateTime timeSpan, Resource inputFile) throws RestClientException {
        Object postBody = null;
        String path = this.apiClient.expandPath("/video/cut", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (fileUrl != null) {
            headerParams.add("fileUrl", this.apiClient.parameterToString(fileUrl));
        }
        if (startTime != null) {
            headerParams.add("startTime", this.apiClient.parameterToString(startTime));
        }
        if (timeSpan != null) {
            headerParams.add("timeSpan", this.apiClient.parameterToString(timeSpan));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public MediaInformation videoGetInfo(String fileUrl, Resource inputFile) throws RestClientException {
        return (MediaInformation)this.videoGetInfoWithHttpInfo(fileUrl, inputFile).getBody();
    }

    public ResponseEntity<MediaInformation> videoGetInfoWithHttpInfo(String fileUrl, Resource inputFile) throws RestClientException {
        Object postBody = null;
        String path = this.apiClient.expandPath("/video/convert/get-info", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (fileUrl != null) {
            headerParams.add("fileUrl", this.apiClient.parameterToString(fileUrl));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<MediaInformation> returnType = new ParameterizedTypeReference<MediaInformation>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] videoResizeVideo(String fileUrl, Integer maxWidth, Integer maxHeight, Integer frameRate, Integer quality, String extension, Resource inputFile) throws RestClientException {
        return (byte[])this.videoResizeVideoWithHttpInfo(fileUrl, maxWidth, maxHeight, frameRate, quality, extension, inputFile).getBody();
    }

    public ResponseEntity<byte[]> videoResizeVideoWithHttpInfo(String fileUrl, Integer maxWidth, Integer maxHeight, Integer frameRate, Integer quality, String extension, Resource inputFile) throws RestClientException {
        Object postBody = null;
        String path = this.apiClient.expandPath("/video/resize/preserveAspectRatio", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (fileUrl != null) {
            headerParams.add("fileUrl", this.apiClient.parameterToString(fileUrl));
        }
        if (maxWidth != null) {
            headerParams.add("maxWidth", this.apiClient.parameterToString(maxWidth));
        }
        if (maxHeight != null) {
            headerParams.add("maxHeight", this.apiClient.parameterToString(maxHeight));
        }
        if (frameRate != null) {
            headerParams.add("frameRate", this.apiClient.parameterToString(frameRate));
        }
        if (quality != null) {
            headerParams.add("quality", this.apiClient.parameterToString(quality));
        }
        if (extension != null) {
            headerParams.add("extension", this.apiClient.parameterToString(extension));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] videoResizeVideoSimple(String fileUrl, Integer maxWidth, Integer maxHeight, Integer frameRate, Integer quality, String extension, Resource inputFile) throws RestClientException {
        return (byte[])this.videoResizeVideoSimpleWithHttpInfo(fileUrl, maxWidth, maxHeight, frameRate, quality, extension, inputFile).getBody();
    }

    public ResponseEntity<byte[]> videoResizeVideoSimpleWithHttpInfo(String fileUrl, Integer maxWidth, Integer maxHeight, Integer frameRate, Integer quality, String extension, Resource inputFile) throws RestClientException {
        Object postBody = null;
        String path = this.apiClient.expandPath("/video/resize/target", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (fileUrl != null) {
            headerParams.add("fileUrl", this.apiClient.parameterToString(fileUrl));
        }
        if (maxWidth != null) {
            headerParams.add("maxWidth", this.apiClient.parameterToString(maxWidth));
        }
        if (maxHeight != null) {
            headerParams.add("maxHeight", this.apiClient.parameterToString(maxHeight));
        }
        if (frameRate != null) {
            headerParams.add("frameRate", this.apiClient.parameterToString(frameRate));
        }
        if (quality != null) {
            headerParams.add("quality", this.apiClient.parameterToString(quality));
        }
        if (extension != null) {
            headerParams.add("extension", this.apiClient.parameterToString(extension));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public NsfwResult videoScanForNsfw(String fileUrl, BigDecimal framesPerSecond, Resource inputFile) throws RestClientException {
        return (NsfwResult)this.videoScanForNsfwWithHttpInfo(fileUrl, framesPerSecond, inputFile).getBody();
    }

    public ResponseEntity<NsfwResult> videoScanForNsfwWithHttpInfo(String fileUrl, BigDecimal framesPerSecond, Resource inputFile) throws RestClientException {
        Object postBody = null;
        String path = this.apiClient.expandPath("/video/scan/nsfw", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (fileUrl != null) {
            headerParams.add("fileUrl", this.apiClient.parameterToString(fileUrl));
        }
        if (framesPerSecond != null) {
            headerParams.add("framesPerSecond", this.apiClient.parameterToString(framesPerSecond));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<NsfwResult> returnType = new ParameterizedTypeReference<NsfwResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public SplitVideoResult videoSplitVideo(OffsetDateTime splitTime, String fileUrl, OffsetDateTime timeSpan, Resource inputFile) throws RestClientException {
        return (SplitVideoResult)this.videoSplitVideoWithHttpInfo(splitTime, fileUrl, timeSpan, inputFile).getBody();
    }

    public ResponseEntity<SplitVideoResult> videoSplitVideoWithHttpInfo(OffsetDateTime splitTime, String fileUrl, OffsetDateTime timeSpan, Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (splitTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'splitTime' when calling videoSplitVideo");
        }
        String path = this.apiClient.expandPath("/video/split", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (fileUrl != null) {
            headerParams.add("fileUrl", this.apiClient.parameterToString(fileUrl));
        }
        if (splitTime != null) {
            headerParams.add("splitTime", this.apiClient.parameterToString(splitTime));
        }
        if (timeSpan != null) {
            headerParams.add("timeSpan", this.apiClient.parameterToString(timeSpan));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<SplitVideoResult> returnType = new ParameterizedTypeReference<SplitVideoResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }
}

