/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt;

import com.cloudmersive.client.rt.invoker.ApiClient;
import com.cloudmersive.client.rt.model.VirusScanAdvancedResult;
import com.cloudmersive.client.rt.model.VirusScanResult;
import com.cloudmersive.client.rt.model.WebsiteScanRequest;
import com.cloudmersive.client.rt.model.WebsiteScanResult;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.cloudmersive.client.rt.ScanApi")
public class ScanApi {
    private ApiClient apiClient;

    public ScanApi() {
        this(new ApiClient());
    }

    @Autowired
    public ScanApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public VirusScanResult scanFile(Resource inputFile) throws RestClientException {
        return (VirusScanResult)this.scanFileWithHttpInfo(inputFile).getBody();
    }

    public ResponseEntity<VirusScanResult> scanFileWithHttpInfo(Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling scanFile");
        }
        String path = this.apiClient.expandPath("/virus/scan/file", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<VirusScanResult> returnType = new ParameterizedTypeReference<VirusScanResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public VirusScanAdvancedResult scanFileAdvanced(Resource inputFile, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, String restrictFileTypes) throws RestClientException {
        return (VirusScanAdvancedResult)this.scanFileAdvancedWithHttpInfo(inputFile, allowExecutables, allowInvalidFiles, allowScripts, allowPasswordProtectedFiles, restrictFileTypes).getBody();
    }

    public ResponseEntity<VirusScanAdvancedResult> scanFileAdvancedWithHttpInfo(Resource inputFile, Boolean allowExecutables, Boolean allowInvalidFiles, Boolean allowScripts, Boolean allowPasswordProtectedFiles, String restrictFileTypes) throws RestClientException {
        Object postBody = null;
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling scanFileAdvanced");
        }
        String path = this.apiClient.expandPath("/virus/scan/file/advanced", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (allowExecutables != null) {
            headerParams.add("allowExecutables", this.apiClient.parameterToString(allowExecutables));
        }
        if (allowInvalidFiles != null) {
            headerParams.add("allowInvalidFiles", this.apiClient.parameterToString(allowInvalidFiles));
        }
        if (allowScripts != null) {
            headerParams.add("allowScripts", this.apiClient.parameterToString(allowScripts));
        }
        if (allowPasswordProtectedFiles != null) {
            headerParams.add("allowPasswordProtectedFiles", this.apiClient.parameterToString(allowPasswordProtectedFiles));
        }
        if (restrictFileTypes != null) {
            headerParams.add("restrictFileTypes", this.apiClient.parameterToString(restrictFileTypes));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<VirusScanAdvancedResult> returnType = new ParameterizedTypeReference<VirusScanAdvancedResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public WebsiteScanResult scanWebsite(WebsiteScanRequest input) throws RestClientException {
        return (WebsiteScanResult)this.scanWebsiteWithHttpInfo(input).getBody();
    }

    public ResponseEntity<WebsiteScanResult> scanWebsiteWithHttpInfo(WebsiteScanRequest input) throws RestClientException {
        WebsiteScanRequest postBody = input;
        if (input == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'input' when calling scanWebsite");
        }
        String path = this.apiClient.expandPath("/virus/scan/website", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<WebsiteScanResult> returnType = new ParameterizedTypeReference<WebsiteScanResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }
}

