/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt;

import com.cloudmersive.client.rt.invoker.ApiClient;
import com.cloudmersive.client.rt.model.BusinessCardRecognitionResult;
import com.cloudmersive.client.rt.model.FormRecognitionResult;
import com.cloudmersive.client.rt.model.ImageToLinesWithLocationResult;
import com.cloudmersive.client.rt.model.ImageToTextResponse;
import com.cloudmersive.client.rt.model.ImageToWordsWithLocationResult;
import com.cloudmersive.client.rt.model.PhotoToWordsWithLocationResult;
import com.cloudmersive.client.rt.model.ReceiptRecognitionResult;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.cloudmersive.client.rt.ImageOcrApi")
public class ImageOcrApi {
    private ApiClient apiClient;

    public ImageOcrApi() {
        this(new ApiClient());
    }

    @Autowired
    public ImageOcrApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ImageToLinesWithLocationResult imageOcrImageLinesWithLocation(Resource imageFile, String language, String preprocessing) throws RestClientException {
        return (ImageToLinesWithLocationResult)this.imageOcrImageLinesWithLocationWithHttpInfo(imageFile, language, preprocessing).getBody();
    }

    public ResponseEntity<ImageToLinesWithLocationResult> imageOcrImageLinesWithLocationWithHttpInfo(Resource imageFile, String language, String preprocessing) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling imageOcrImageLinesWithLocation");
        }
        String path = this.apiClient.expandPath("/ocr/image/to/lines-with-location", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (language != null) {
            headerParams.add("language", this.apiClient.parameterToString(language));
        }
        if (preprocessing != null) {
            headerParams.add("preprocessing", this.apiClient.parameterToString(preprocessing));
        }
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<ImageToLinesWithLocationResult> returnType = new ParameterizedTypeReference<ImageToLinesWithLocationResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public ImageToWordsWithLocationResult imageOcrImageWordsWithLocation(Resource imageFile, String language, String preprocessing) throws RestClientException {
        return (ImageToWordsWithLocationResult)this.imageOcrImageWordsWithLocationWithHttpInfo(imageFile, language, preprocessing).getBody();
    }

    public ResponseEntity<ImageToWordsWithLocationResult> imageOcrImageWordsWithLocationWithHttpInfo(Resource imageFile, String language, String preprocessing) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling imageOcrImageWordsWithLocation");
        }
        String path = this.apiClient.expandPath("/ocr/image/to/words-with-location", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (language != null) {
            headerParams.add("language", this.apiClient.parameterToString(language));
        }
        if (preprocessing != null) {
            headerParams.add("preprocessing", this.apiClient.parameterToString(preprocessing));
        }
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<ImageToWordsWithLocationResult> returnType = new ParameterizedTypeReference<ImageToWordsWithLocationResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public BusinessCardRecognitionResult imageOcrPhotoRecognizeBusinessCard(Resource imageFile) throws RestClientException {
        return (BusinessCardRecognitionResult)this.imageOcrPhotoRecognizeBusinessCardWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<BusinessCardRecognitionResult> imageOcrPhotoRecognizeBusinessCardWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling imageOcrPhotoRecognizeBusinessCard");
        }
        String path = this.apiClient.expandPath("/ocr/photo/recognize/business-card", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<BusinessCardRecognitionResult> returnType = new ParameterizedTypeReference<BusinessCardRecognitionResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public FormRecognitionResult imageOcrPhotoRecognizeForm(Resource imageFile, Object formTemplateDefinition, String recognitionMode, String preprocessing, String diagnostics, String language) throws RestClientException {
        return (FormRecognitionResult)this.imageOcrPhotoRecognizeFormWithHttpInfo(imageFile, formTemplateDefinition, recognitionMode, preprocessing, diagnostics, language).getBody();
    }

    public ResponseEntity<FormRecognitionResult> imageOcrPhotoRecognizeFormWithHttpInfo(Resource imageFile, Object formTemplateDefinition, String recognitionMode, String preprocessing, String diagnostics, String language) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling imageOcrPhotoRecognizeForm");
        }
        String path = this.apiClient.expandPath("/ocr/photo/recognize/form", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (formTemplateDefinition != null) {
            headerParams.add("formTemplateDefinition", this.apiClient.parameterToString(formTemplateDefinition));
        }
        if (recognitionMode != null) {
            headerParams.add("recognitionMode", this.apiClient.parameterToString(recognitionMode));
        }
        if (preprocessing != null) {
            headerParams.add("preprocessing", this.apiClient.parameterToString(preprocessing));
        }
        if (diagnostics != null) {
            headerParams.add("diagnostics", this.apiClient.parameterToString(diagnostics));
        }
        if (language != null) {
            headerParams.add("language", this.apiClient.parameterToString(language));
        }
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<FormRecognitionResult> returnType = new ParameterizedTypeReference<FormRecognitionResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public FormRecognitionResult imageOcrPhotoRecognizeFormAdvanced(Resource imageFile, String bucketID, String bucketSecretKey, String recognitionMode, String preprocessing, String diagnostics) throws RestClientException {
        return (FormRecognitionResult)this.imageOcrPhotoRecognizeFormAdvancedWithHttpInfo(imageFile, bucketID, bucketSecretKey, recognitionMode, preprocessing, diagnostics).getBody();
    }

    public ResponseEntity<FormRecognitionResult> imageOcrPhotoRecognizeFormAdvancedWithHttpInfo(Resource imageFile, String bucketID, String bucketSecretKey, String recognitionMode, String preprocessing, String diagnostics) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling imageOcrPhotoRecognizeFormAdvanced");
        }
        String path = this.apiClient.expandPath("/ocr/photo/recognize/form/advanced", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (bucketID != null) {
            headerParams.add("bucketID", this.apiClient.parameterToString(bucketID));
        }
        if (bucketSecretKey != null) {
            headerParams.add("bucketSecretKey", this.apiClient.parameterToString(bucketSecretKey));
        }
        if (recognitionMode != null) {
            headerParams.add("recognitionMode", this.apiClient.parameterToString(recognitionMode));
        }
        if (preprocessing != null) {
            headerParams.add("preprocessing", this.apiClient.parameterToString(preprocessing));
        }
        if (diagnostics != null) {
            headerParams.add("diagnostics", this.apiClient.parameterToString(diagnostics));
        }
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<FormRecognitionResult> returnType = new ParameterizedTypeReference<FormRecognitionResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public ReceiptRecognitionResult imageOcrPhotoRecognizeReceipt(Resource imageFile, String recognitionMode, String language, String preprocessing) throws RestClientException {
        return (ReceiptRecognitionResult)this.imageOcrPhotoRecognizeReceiptWithHttpInfo(imageFile, recognitionMode, language, preprocessing).getBody();
    }

    public ResponseEntity<ReceiptRecognitionResult> imageOcrPhotoRecognizeReceiptWithHttpInfo(Resource imageFile, String recognitionMode, String language, String preprocessing) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling imageOcrPhotoRecognizeReceipt");
        }
        String path = this.apiClient.expandPath("/ocr/photo/recognize/receipt", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (recognitionMode != null) {
            headerParams.add("recognitionMode", this.apiClient.parameterToString(recognitionMode));
        }
        if (language != null) {
            headerParams.add("language", this.apiClient.parameterToString(language));
        }
        if (preprocessing != null) {
            headerParams.add("preprocessing", this.apiClient.parameterToString(preprocessing));
        }
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<ReceiptRecognitionResult> returnType = new ParameterizedTypeReference<ReceiptRecognitionResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public ImageToTextResponse imageOcrPhotoToText(Resource imageFile, String recognitionMode, String language) throws RestClientException {
        return (ImageToTextResponse)this.imageOcrPhotoToTextWithHttpInfo(imageFile, recognitionMode, language).getBody();
    }

    public ResponseEntity<ImageToTextResponse> imageOcrPhotoToTextWithHttpInfo(Resource imageFile, String recognitionMode, String language) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling imageOcrPhotoToText");
        }
        String path = this.apiClient.expandPath("/ocr/photo/toText", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (recognitionMode != null) {
            headerParams.add("recognitionMode", this.apiClient.parameterToString(recognitionMode));
        }
        if (language != null) {
            headerParams.add("language", this.apiClient.parameterToString(language));
        }
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<ImageToTextResponse> returnType = new ParameterizedTypeReference<ImageToTextResponse>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public PhotoToWordsWithLocationResult imageOcrPhotoWordsWithLocation(Resource imageFile, String recognitionMode, String language, String preprocessing, String diagnostics) throws RestClientException {
        return (PhotoToWordsWithLocationResult)this.imageOcrPhotoWordsWithLocationWithHttpInfo(imageFile, recognitionMode, language, preprocessing, diagnostics).getBody();
    }

    public ResponseEntity<PhotoToWordsWithLocationResult> imageOcrPhotoWordsWithLocationWithHttpInfo(Resource imageFile, String recognitionMode, String language, String preprocessing, String diagnostics) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling imageOcrPhotoWordsWithLocation");
        }
        String path = this.apiClient.expandPath("/ocr/photo/to/words-with-location", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (recognitionMode != null) {
            headerParams.add("recognitionMode", this.apiClient.parameterToString(recognitionMode));
        }
        if (language != null) {
            headerParams.add("language", this.apiClient.parameterToString(language));
        }
        if (preprocessing != null) {
            headerParams.add("preprocessing", this.apiClient.parameterToString(preprocessing));
        }
        if (diagnostics != null) {
            headerParams.add("diagnostics", this.apiClient.parameterToString(diagnostics));
        }
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<PhotoToWordsWithLocationResult> returnType = new ParameterizedTypeReference<PhotoToWordsWithLocationResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public ImageToTextResponse imageOcrPost(Resource imageFile, String recognitionMode, String language, String preprocessing) throws RestClientException {
        return (ImageToTextResponse)this.imageOcrPostWithHttpInfo(imageFile, recognitionMode, language, preprocessing).getBody();
    }

    public ResponseEntity<ImageToTextResponse> imageOcrPostWithHttpInfo(Resource imageFile, String recognitionMode, String language, String preprocessing) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling imageOcrPost");
        }
        String path = this.apiClient.expandPath("/ocr/image/toText", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (recognitionMode != null) {
            headerParams.add("recognitionMode", this.apiClient.parameterToString(recognitionMode));
        }
        if (language != null) {
            headerParams.add("language", this.apiClient.parameterToString(language));
        }
        if (preprocessing != null) {
            headerParams.add("preprocessing", this.apiClient.parameterToString(preprocessing));
        }
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<ImageToTextResponse> returnType = new ParameterizedTypeReference<ImageToTextResponse>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }
}

