/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt;

import com.cloudmersive.client.rt.invoker.ApiClient;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.cloudmersive.client.rt.FilterApi")
public class FilterApi {
    private ApiClient apiClient;

    public FilterApi() {
        this(new ApiClient());
    }

    @Autowired
    public FilterApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public byte[] filterBlackAndWhite(Resource imageFile) throws RestClientException {
        return (byte[])this.filterBlackAndWhiteWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<byte[]> filterBlackAndWhiteWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling filterBlackAndWhite");
        }
        String path = this.apiClient.expandPath("/image/filter/black-and-white", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] filterDespeckle(Resource imageFile) throws RestClientException {
        return (byte[])this.filterDespeckleWithHttpInfo(imageFile).getBody();
    }

    public ResponseEntity<byte[]> filterDespeckleWithHttpInfo(Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling filterDespeckle");
        }
        String path = this.apiClient.expandPath("/image/filter/despeckle", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] filterEdgeDetect(Integer radius, Resource imageFile) throws RestClientException {
        return (byte[])this.filterEdgeDetectWithHttpInfo(radius, imageFile).getBody();
    }

    public ResponseEntity<byte[]> filterEdgeDetectWithHttpInfo(Integer radius, Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (radius == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'radius' when calling filterEdgeDetect");
        }
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling filterEdgeDetect");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("radius", radius);
        String path = this.apiClient.expandPath("/image/filter/edge-detect/{radius}", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] filterEmboss(Integer radius, Integer sigma, Resource imageFile) throws RestClientException {
        return (byte[])this.filterEmbossWithHttpInfo(radius, sigma, imageFile).getBody();
    }

    public ResponseEntity<byte[]> filterEmbossWithHttpInfo(Integer radius, Integer sigma, Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (radius == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'radius' when calling filterEmboss");
        }
        if (sigma == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sigma' when calling filterEmboss");
        }
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling filterEmboss");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("radius", radius);
        uriVariables.put("sigma", sigma);
        String path = this.apiClient.expandPath("/image/filter/emboss/{radius}/{sigma}", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] filterGaussianBlur(Integer radius, Integer sigma, Resource imageFile) throws RestClientException {
        return (byte[])this.filterGaussianBlurWithHttpInfo(radius, sigma, imageFile).getBody();
    }

    public ResponseEntity<byte[]> filterGaussianBlurWithHttpInfo(Integer radius, Integer sigma, Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (radius == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'radius' when calling filterGaussianBlur");
        }
        if (sigma == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sigma' when calling filterGaussianBlur");
        }
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling filterGaussianBlur");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("radius", radius);
        uriVariables.put("sigma", sigma);
        String path = this.apiClient.expandPath("/image/filter/blur/guassian/{radius}/{sigma}", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] filterMotionBlur(Integer radius, Integer sigma, Integer angle, Resource imageFile) throws RestClientException {
        return (byte[])this.filterMotionBlurWithHttpInfo(radius, sigma, angle, imageFile).getBody();
    }

    public ResponseEntity<byte[]> filterMotionBlurWithHttpInfo(Integer radius, Integer sigma, Integer angle, Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (radius == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'radius' when calling filterMotionBlur");
        }
        if (sigma == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sigma' when calling filterMotionBlur");
        }
        if (angle == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'angle' when calling filterMotionBlur");
        }
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling filterMotionBlur");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("radius", radius);
        uriVariables.put("sigma", sigma);
        uriVariables.put("angle", angle);
        String path = this.apiClient.expandPath("/image/filter/blur/motion/{radius}/{sigma}/{angle}", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] filterPosterize(Integer levels, Resource imageFile) throws RestClientException {
        return (byte[])this.filterPosterizeWithHttpInfo(levels, imageFile).getBody();
    }

    public ResponseEntity<byte[]> filterPosterizeWithHttpInfo(Integer levels, Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (levels == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'levels' when calling filterPosterize");
        }
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling filterPosterize");
        }
        String path = this.apiClient.expandPath("/image/filter/posterize", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "levels", levels));
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] filterSwirl(Integer degrees, Resource imageFile) throws RestClientException {
        return (byte[])this.filterSwirlWithHttpInfo(degrees, imageFile).getBody();
    }

    public ResponseEntity<byte[]> filterSwirlWithHttpInfo(Integer degrees, Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (degrees == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'degrees' when calling filterSwirl");
        }
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling filterSwirl");
        }
        String path = this.apiClient.expandPath("/image/filter/swirl", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "degrees", degrees));
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }
}

