/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt;

import com.cloudmersive.client.rt.invoker.ApiClient;
import com.cloudmersive.client.rt.model.AddPdfAnnotationRequest;
import com.cloudmersive.client.rt.model.GetPdfAnnotationsResult;
import com.cloudmersive.client.rt.model.PdfFormFields;
import com.cloudmersive.client.rt.model.PdfMetadata;
import com.cloudmersive.client.rt.model.PdfTextByPageResult;
import com.cloudmersive.client.rt.model.SetPdfFormFieldsRequest;
import com.cloudmersive.client.rt.model.SetPdfMetadataRequest;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.cloudmersive.client.rt.EditPdfApi")
public class EditPdfApi {
    private ApiClient apiClient;

    public EditPdfApi() {
        this(new ApiClient());
    }

    @Autowired
    public EditPdfApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public byte[] editPdfAddAnnotations(AddPdfAnnotationRequest request) throws RestClientException {
        return (byte[])this.editPdfAddAnnotationsWithHttpInfo(request).getBody();
    }

    public ResponseEntity<byte[]> editPdfAddAnnotationsWithHttpInfo(AddPdfAnnotationRequest request) throws RestClientException {
        AddPdfAnnotationRequest postBody = request;
        if (request == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'request' when calling editPdfAddAnnotations");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/annotations/add-item", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfConvertToPdfA(Resource inputFile, String conformanceLevel) throws RestClientException {
        return (byte[])this.editPdfConvertToPdfAWithHttpInfo(inputFile, conformanceLevel).getBody();
    }

    public ResponseEntity<byte[]> editPdfConvertToPdfAWithHttpInfo(Resource inputFile, String conformanceLevel) throws RestClientException {
        Object postBody = null;
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfConvertToPdfA");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/optimize/pdf-a", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (conformanceLevel != null) {
            headerParams.add("conformanceLevel", this.apiClient.parameterToString(conformanceLevel));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfDecrypt(String password, Resource inputFile) throws RestClientException {
        return (byte[])this.editPdfDecryptWithHttpInfo(password, inputFile).getBody();
    }

    public ResponseEntity<byte[]> editPdfDecryptWithHttpInfo(String password, Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (password == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'password' when calling editPdfDecrypt");
        }
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfDecrypt");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/decrypt", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (password != null) {
            headerParams.add("password", this.apiClient.parameterToString(password));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfDeletePages(Integer pageStart, Integer pageEnd, Resource inputFile) throws RestClientException {
        return (byte[])this.editPdfDeletePagesWithHttpInfo(pageStart, pageEnd, inputFile).getBody();
    }

    public ResponseEntity<byte[]> editPdfDeletePagesWithHttpInfo(Integer pageStart, Integer pageEnd, Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (pageStart == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pageStart' when calling editPdfDeletePages");
        }
        if (pageEnd == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pageEnd' when calling editPdfDeletePages");
        }
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfDeletePages");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/pages/delete", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (pageStart != null) {
            headerParams.add("pageStart", this.apiClient.parameterToString(pageStart));
        }
        if (pageEnd != null) {
            headerParams.add("pageEnd", this.apiClient.parameterToString(pageEnd));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfEncrypt(Resource inputFile, String userPassword, String ownerPassword, String encryptionKeyLength) throws RestClientException {
        return (byte[])this.editPdfEncryptWithHttpInfo(inputFile, userPassword, ownerPassword, encryptionKeyLength).getBody();
    }

    public ResponseEntity<byte[]> editPdfEncryptWithHttpInfo(Resource inputFile, String userPassword, String ownerPassword, String encryptionKeyLength) throws RestClientException {
        Object postBody = null;
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfEncrypt");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/encrypt", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (userPassword != null) {
            headerParams.add("userPassword", this.apiClient.parameterToString(userPassword));
        }
        if (ownerPassword != null) {
            headerParams.add("ownerPassword", this.apiClient.parameterToString(ownerPassword));
        }
        if (encryptionKeyLength != null) {
            headerParams.add("encryptionKeyLength", this.apiClient.parameterToString(encryptionKeyLength));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public GetPdfAnnotationsResult editPdfGetAnnotations(Resource inputFile) throws RestClientException {
        return (GetPdfAnnotationsResult)this.editPdfGetAnnotationsWithHttpInfo(inputFile).getBody();
    }

    public ResponseEntity<GetPdfAnnotationsResult> editPdfGetAnnotationsWithHttpInfo(Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfGetAnnotations");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/annotations/list", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<GetPdfAnnotationsResult> returnType = new ParameterizedTypeReference<GetPdfAnnotationsResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public PdfFormFields editPdfGetFormFields(Resource inputFile) throws RestClientException {
        return (PdfFormFields)this.editPdfGetFormFieldsWithHttpInfo(inputFile).getBody();
    }

    public ResponseEntity<PdfFormFields> editPdfGetFormFieldsWithHttpInfo(Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfGetFormFields");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/form/get-fields", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<PdfFormFields> returnType = new ParameterizedTypeReference<PdfFormFields>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public PdfMetadata editPdfGetMetadata(Resource inputFile) throws RestClientException {
        return (PdfMetadata)this.editPdfGetMetadataWithHttpInfo(inputFile).getBody();
    }

    public ResponseEntity<PdfMetadata> editPdfGetMetadataWithHttpInfo(Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfGetMetadata");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/get-metadata", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<PdfMetadata> returnType = new ParameterizedTypeReference<PdfMetadata>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public PdfTextByPageResult editPdfGetPdfTextByPages(Resource inputFile, String textFormattingMode) throws RestClientException {
        return (PdfTextByPageResult)this.editPdfGetPdfTextByPagesWithHttpInfo(inputFile, textFormattingMode).getBody();
    }

    public ResponseEntity<PdfTextByPageResult> editPdfGetPdfTextByPagesWithHttpInfo(Resource inputFile, String textFormattingMode) throws RestClientException {
        Object postBody = null;
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfGetPdfTextByPages");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/pages/get-text", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (textFormattingMode != null) {
            headerParams.add("textFormattingMode", this.apiClient.parameterToString(textFormattingMode));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<PdfTextByPageResult> returnType = new ParameterizedTypeReference<PdfTextByPageResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfInsertPages(Integer pageStartSource, Integer pageEndSource, Integer pageInsertBeforeDesitnation, Resource sourceFile, Resource destinationFile) throws RestClientException {
        return (byte[])this.editPdfInsertPagesWithHttpInfo(pageStartSource, pageEndSource, pageInsertBeforeDesitnation, sourceFile, destinationFile).getBody();
    }

    public ResponseEntity<byte[]> editPdfInsertPagesWithHttpInfo(Integer pageStartSource, Integer pageEndSource, Integer pageInsertBeforeDesitnation, Resource sourceFile, Resource destinationFile) throws RestClientException {
        Object postBody = null;
        if (pageStartSource == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pageStartSource' when calling editPdfInsertPages");
        }
        if (pageEndSource == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pageEndSource' when calling editPdfInsertPages");
        }
        if (pageInsertBeforeDesitnation == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pageInsertBeforeDesitnation' when calling editPdfInsertPages");
        }
        if (sourceFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sourceFile' when calling editPdfInsertPages");
        }
        if (destinationFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'destinationFile' when calling editPdfInsertPages");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/pages/insert", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (pageStartSource != null) {
            headerParams.add("pageStartSource", this.apiClient.parameterToString(pageStartSource));
        }
        if (pageEndSource != null) {
            headerParams.add("pageEndSource", this.apiClient.parameterToString(pageEndSource));
        }
        if (pageInsertBeforeDesitnation != null) {
            headerParams.add("pageInsertBeforeDesitnation", this.apiClient.parameterToString(pageInsertBeforeDesitnation));
        }
        if (sourceFile != null) {
            formParams.add((Object)"sourceFile", (Object)sourceFile);
        }
        if (destinationFile != null) {
            formParams.add((Object)"destinationFile", (Object)destinationFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfLinearize(Resource inputFile) throws RestClientException {
        return (byte[])this.editPdfLinearizeWithHttpInfo(inputFile).getBody();
    }

    public ResponseEntity<byte[]> editPdfLinearizeWithHttpInfo(Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfLinearize");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/optimize/linearize", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfRasterize(Resource inputFile) throws RestClientException {
        return (byte[])this.editPdfRasterizeWithHttpInfo(inputFile).getBody();
    }

    public ResponseEntity<byte[]> editPdfRasterizeWithHttpInfo(Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfRasterize");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/rasterize", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfReduceFileSize(Resource inputFile) throws RestClientException {
        return (byte[])this.editPdfReduceFileSizeWithHttpInfo(inputFile).getBody();
    }

    public ResponseEntity<byte[]> editPdfReduceFileSizeWithHttpInfo(Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfReduceFileSize");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/optimize/reduce-file-size", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfRemoveAllAnnotations(Resource inputFile) throws RestClientException {
        return (byte[])this.editPdfRemoveAllAnnotationsWithHttpInfo(inputFile).getBody();
    }

    public ResponseEntity<byte[]> editPdfRemoveAllAnnotationsWithHttpInfo(Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfRemoveAllAnnotations");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/annotations/remove-all", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfRemoveAnnotationItem(Integer annotationIndex, Resource inputFile) throws RestClientException {
        return (byte[])this.editPdfRemoveAnnotationItemWithHttpInfo(annotationIndex, inputFile).getBody();
    }

    public ResponseEntity<byte[]> editPdfRemoveAnnotationItemWithHttpInfo(Integer annotationIndex, Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (annotationIndex == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'annotationIndex' when calling editPdfRemoveAnnotationItem");
        }
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfRemoveAnnotationItem");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/annotations/remove-item", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (annotationIndex != null) {
            headerParams.add("annotationIndex", this.apiClient.parameterToString(annotationIndex));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfResize(String paperSize, Resource inputFile) throws RestClientException {
        return (byte[])this.editPdfResizeWithHttpInfo(paperSize, inputFile).getBody();
    }

    public ResponseEntity<byte[]> editPdfResizeWithHttpInfo(String paperSize, Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (paperSize == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'paperSize' when calling editPdfResize");
        }
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfResize");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/resize", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (paperSize != null) {
            headerParams.add("paperSize", this.apiClient.parameterToString(paperSize));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfRotateAllPages(Integer rotationAngle, Resource inputFile) throws RestClientException {
        return (byte[])this.editPdfRotateAllPagesWithHttpInfo(rotationAngle, inputFile).getBody();
    }

    public ResponseEntity<byte[]> editPdfRotateAllPagesWithHttpInfo(Integer rotationAngle, Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (rotationAngle == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'rotationAngle' when calling editPdfRotateAllPages");
        }
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfRotateAllPages");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/pages/rotate/all", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (rotationAngle != null) {
            headerParams.add("rotationAngle", this.apiClient.parameterToString(rotationAngle));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfRotatePageRange(Integer rotationAngle, Integer pageStart, Integer pageEnd, Resource inputFile) throws RestClientException {
        return (byte[])this.editPdfRotatePageRangeWithHttpInfo(rotationAngle, pageStart, pageEnd, inputFile).getBody();
    }

    public ResponseEntity<byte[]> editPdfRotatePageRangeWithHttpInfo(Integer rotationAngle, Integer pageStart, Integer pageEnd, Resource inputFile) throws RestClientException {
        Object postBody = null;
        if (rotationAngle == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'rotationAngle' when calling editPdfRotatePageRange");
        }
        if (pageStart == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pageStart' when calling editPdfRotatePageRange");
        }
        if (pageEnd == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pageEnd' when calling editPdfRotatePageRange");
        }
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfRotatePageRange");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/pages/rotate/page-range", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (rotationAngle != null) {
            headerParams.add("rotationAngle", this.apiClient.parameterToString(rotationAngle));
        }
        if (pageStart != null) {
            headerParams.add("pageStart", this.apiClient.parameterToString(pageStart));
        }
        if (pageEnd != null) {
            headerParams.add("pageEnd", this.apiClient.parameterToString(pageEnd));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfSetFormFields(SetPdfFormFieldsRequest fieldValues) throws RestClientException {
        return (byte[])this.editPdfSetFormFieldsWithHttpInfo(fieldValues).getBody();
    }

    public ResponseEntity<byte[]> editPdfSetFormFieldsWithHttpInfo(SetPdfFormFieldsRequest fieldValues) throws RestClientException {
        SetPdfFormFieldsRequest postBody = fieldValues;
        if (fieldValues == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fieldValues' when calling editPdfSetFormFields");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/form/set-fields", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfSetMetadata(SetPdfMetadataRequest request) throws RestClientException {
        return (byte[])this.editPdfSetMetadataWithHttpInfo(request).getBody();
    }

    public ResponseEntity<byte[]> editPdfSetMetadataWithHttpInfo(SetPdfMetadataRequest request) throws RestClientException {
        SetPdfMetadataRequest postBody = request;
        if (request == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'request' when calling editPdfSetMetadata");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/set-metadata", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json", "text/json", "application/xml", "text/xml", "application/x-www-form-urlencoded"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfSetPermissions(String ownerPassword, String userPassword, Resource inputFile, String encryptionKeyLength, Boolean allowPrinting, Boolean allowDocumentAssembly, Boolean allowContentExtraction, Boolean allowFormFilling, Boolean allowEditing, Boolean allowAnnotations, Boolean allowDegradedPrinting) throws RestClientException {
        return (byte[])this.editPdfSetPermissionsWithHttpInfo(ownerPassword, userPassword, inputFile, encryptionKeyLength, allowPrinting, allowDocumentAssembly, allowContentExtraction, allowFormFilling, allowEditing, allowAnnotations, allowDegradedPrinting).getBody();
    }

    public ResponseEntity<byte[]> editPdfSetPermissionsWithHttpInfo(String ownerPassword, String userPassword, Resource inputFile, String encryptionKeyLength, Boolean allowPrinting, Boolean allowDocumentAssembly, Boolean allowContentExtraction, Boolean allowFormFilling, Boolean allowEditing, Boolean allowAnnotations, Boolean allowDegradedPrinting) throws RestClientException {
        Object postBody = null;
        if (ownerPassword == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ownerPassword' when calling editPdfSetPermissions");
        }
        if (userPassword == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userPassword' when calling editPdfSetPermissions");
        }
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfSetPermissions");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/encrypt/set-permissions", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (ownerPassword != null) {
            headerParams.add("ownerPassword", this.apiClient.parameterToString(ownerPassword));
        }
        if (userPassword != null) {
            headerParams.add("userPassword", this.apiClient.parameterToString(userPassword));
        }
        if (encryptionKeyLength != null) {
            headerParams.add("encryptionKeyLength", this.apiClient.parameterToString(encryptionKeyLength));
        }
        if (allowPrinting != null) {
            headerParams.add("allowPrinting", this.apiClient.parameterToString(allowPrinting));
        }
        if (allowDocumentAssembly != null) {
            headerParams.add("allowDocumentAssembly", this.apiClient.parameterToString(allowDocumentAssembly));
        }
        if (allowContentExtraction != null) {
            headerParams.add("allowContentExtraction", this.apiClient.parameterToString(allowContentExtraction));
        }
        if (allowFormFilling != null) {
            headerParams.add("allowFormFilling", this.apiClient.parameterToString(allowFormFilling));
        }
        if (allowEditing != null) {
            headerParams.add("allowEditing", this.apiClient.parameterToString(allowEditing));
        }
        if (allowAnnotations != null) {
            headerParams.add("allowAnnotations", this.apiClient.parameterToString(allowAnnotations));
        }
        if (allowDegradedPrinting != null) {
            headerParams.add("allowDegradedPrinting", this.apiClient.parameterToString(allowDegradedPrinting));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public byte[] editPdfWatermarkText(String watermarkText, Resource inputFile, String fontName, BigDecimal fontSize, String fontColor, BigDecimal fontTransparency) throws RestClientException {
        return (byte[])this.editPdfWatermarkTextWithHttpInfo(watermarkText, inputFile, fontName, fontSize, fontColor, fontTransparency).getBody();
    }

    public ResponseEntity<byte[]> editPdfWatermarkTextWithHttpInfo(String watermarkText, Resource inputFile, String fontName, BigDecimal fontSize, String fontColor, BigDecimal fontTransparency) throws RestClientException {
        Object postBody = null;
        if (watermarkText == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'watermarkText' when calling editPdfWatermarkText");
        }
        if (inputFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'inputFile' when calling editPdfWatermarkText");
        }
        String path = this.apiClient.expandPath("/convert/edit/pdf/watermark/text", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (watermarkText != null) {
            headerParams.add("watermarkText", this.apiClient.parameterToString(watermarkText));
        }
        if (fontName != null) {
            headerParams.add("fontName", this.apiClient.parameterToString(fontName));
        }
        if (fontSize != null) {
            headerParams.add("fontSize", this.apiClient.parameterToString(fontSize));
        }
        if (fontColor != null) {
            headerParams.add("fontColor", this.apiClient.parameterToString(fontColor));
        }
        if (fontTransparency != null) {
            headerParams.add("fontTransparency", this.apiClient.parameterToString(fontTransparency));
        }
        if (inputFile != null) {
            formParams.add((Object)"inputFile", (Object)inputFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }
}

