/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt;

import com.cloudmersive.client.rt.invoker.ApiClient;
import com.cloudmersive.client.rt.model.AvailableCurrencyResponse;
import com.cloudmersive.client.rt.model.ConvertedCurrencyResult;
import com.cloudmersive.client.rt.model.ExchangeRateResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.cloudmersive.client.rt.CurrencyExchangeApi")
public class CurrencyExchangeApi {
    private ApiClient apiClient;

    public CurrencyExchangeApi() {
        this(new ApiClient());
    }

    @Autowired
    public CurrencyExchangeApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ConvertedCurrencyResult currencyExchangeConvertCurrency(String source, String destination, Double sourcePrice) throws RestClientException {
        return (ConvertedCurrencyResult)this.currencyExchangeConvertCurrencyWithHttpInfo(source, destination, sourcePrice).getBody();
    }

    public ResponseEntity<ConvertedCurrencyResult> currencyExchangeConvertCurrencyWithHttpInfo(String source, String destination, Double sourcePrice) throws RestClientException {
        Double postBody = sourcePrice;
        if (source == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'source' when calling currencyExchangeConvertCurrency");
        }
        if (destination == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'destination' when calling currencyExchangeConvertCurrency");
        }
        if (sourcePrice == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sourcePrice' when calling currencyExchangeConvertCurrency");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("source", source);
        uriVariables.put("destination", destination);
        String path = this.apiClient.expandPath("/currency/exchange-rates/convert/{source}/to/{destination}", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json", "text/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<ConvertedCurrencyResult> returnType = new ParameterizedTypeReference<ConvertedCurrencyResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public AvailableCurrencyResponse currencyExchangeGetAvailableCurrencies() throws RestClientException {
        return (AvailableCurrencyResponse)this.currencyExchangeGetAvailableCurrenciesWithHttpInfo().getBody();
    }

    public ResponseEntity<AvailableCurrencyResponse> currencyExchangeGetAvailableCurrenciesWithHttpInfo() throws RestClientException {
        Object postBody = null;
        String path = this.apiClient.expandPath("/currency/exchange-rates/list-available", Collections.emptyMap());
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<AvailableCurrencyResponse> returnType = new ParameterizedTypeReference<AvailableCurrencyResponse>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }

    public ExchangeRateResult currencyExchangeGetExchangeRate(String source, String destination) throws RestClientException {
        return (ExchangeRateResult)this.currencyExchangeGetExchangeRateWithHttpInfo(source, destination).getBody();
    }

    public ResponseEntity<ExchangeRateResult> currencyExchangeGetExchangeRateWithHttpInfo(String source, String destination) throws RestClientException {
        Object postBody = null;
        if (source == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'source' when calling currencyExchangeGetExchangeRate");
        }
        if (destination == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'destination' when calling currencyExchangeGetExchangeRate");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("source", source);
        uriVariables.put("destination", destination);
        String path = this.apiClient.expandPath("/currency/exchange-rates/get/{source}/to/{destination}", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json", "text/json", "application/xml", "text/xml"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<ExchangeRateResult> returnType = new ParameterizedTypeReference<ExchangeRateResult>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }
}

