/*
 * Decompiled with CFR 0.152.
 */
package com.cloudmersive.client.rt;

import com.cloudmersive.client.rt.invoker.ApiClient;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.cloudmersive.client.rt.ArtisticApi")
public class ArtisticApi {
    private ApiClient apiClient;

    public ArtisticApi() {
        this(new ApiClient());
    }

    @Autowired
    public ArtisticApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public byte[] artisticPainting(String style, Resource imageFile) throws RestClientException {
        return (byte[])this.artisticPaintingWithHttpInfo(style, imageFile).getBody();
    }

    public ResponseEntity<byte[]> artisticPaintingWithHttpInfo(String style, Resource imageFile) throws RestClientException {
        Object postBody = null;
        if (style == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'style' when calling artisticPainting");
        }
        if (imageFile == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'imageFile' when calling artisticPainting");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("style", style);
        String path = this.apiClient.expandPath("/image/artistic/painting/{style}", uriVariables);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (imageFile != null) {
            formParams.add((Object)"imageFile", (Object)imageFile);
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Apikey"};
        ParameterizedTypeReference<byte[]> returnType = new ParameterizedTypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, contentType, authNames, returnType);
    }
}

