/*
 * validateapi
 * The validation APIs help you validate data. Check if an E-mail address is real. Check if a domain is real. Check up on an IP address, and even where it is located. All this and much more is available in the validation API.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Result of validating a URL with full validation
 */
@ApiModel(description = "Result of validating a URL with full validation")
@JsonPropertyOrder({
  ValidateUrlResponseFull.JSON_PROPERTY_VALID_U_R_L,
  ValidateUrlResponseFull.JSON_PROPERTY_VALID_SYNTAX,
  ValidateUrlResponseFull.JSON_PROPERTY_VALID_DOMAIN,
  ValidateUrlResponseFull.JSON_PROPERTY_VALID_ENDPOINT,
  ValidateUrlResponseFull.JSON_PROPERTY_WELL_FORMED_U_R_L
})
@JsonTypeName("ValidateUrlResponseFull")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:06.593-08:00[America/Los_Angeles]")
public class ValidateUrlResponseFull {
  public static final String JSON_PROPERTY_VALID_U_R_L = "ValidURL";
  private Boolean validURL;

  public static final String JSON_PROPERTY_VALID_SYNTAX = "Valid_Syntax";
  private Boolean validSyntax;

  public static final String JSON_PROPERTY_VALID_DOMAIN = "Valid_Domain";
  private Boolean validDomain;

  public static final String JSON_PROPERTY_VALID_ENDPOINT = "Valid_Endpoint";
  private Boolean validEndpoint;

  public static final String JSON_PROPERTY_WELL_FORMED_U_R_L = "WellFormedURL";
  private String wellFormedURL;


  public ValidateUrlResponseFull validURL(Boolean validURL) {
    
    this.validURL = validURL;
    return this;
  }

   /**
   * True if the URL has valid syntax, a valid domain, a valid endpoint, and passes virus scan checks; false otherwise
   * @return validURL
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the URL has valid syntax, a valid domain, a valid endpoint, and passes virus scan checks; false otherwise")
  @JsonProperty(JSON_PROPERTY_VALID_U_R_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getValidURL() {
    return validURL;
  }


  public void setValidURL(Boolean validURL) {
    this.validURL = validURL;
  }


  public ValidateUrlResponseFull validSyntax(Boolean validSyntax) {
    
    this.validSyntax = validSyntax;
    return this;
  }

   /**
   * True if the URL has valid syntax, false otherwise
   * @return validSyntax
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the URL has valid syntax, false otherwise")
  @JsonProperty(JSON_PROPERTY_VALID_SYNTAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getValidSyntax() {
    return validSyntax;
  }


  public void setValidSyntax(Boolean validSyntax) {
    this.validSyntax = validSyntax;
  }


  public ValidateUrlResponseFull validDomain(Boolean validDomain) {
    
    this.validDomain = validDomain;
    return this;
  }

   /**
   * True if the domain name is valid and exists, false otherwise
   * @return validDomain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the domain name is valid and exists, false otherwise")
  @JsonProperty(JSON_PROPERTY_VALID_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getValidDomain() {
    return validDomain;
  }


  public void setValidDomain(Boolean validDomain) {
    this.validDomain = validDomain;
  }


  public ValidateUrlResponseFull validEndpoint(Boolean validEndpoint) {
    
    this.validEndpoint = validEndpoint;
    return this;
  }

   /**
   * True if the endpoint is up and responsive and passes a virus scan check, false otherwise
   * @return validEndpoint
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the endpoint is up and responsive and passes a virus scan check, false otherwise")
  @JsonProperty(JSON_PROPERTY_VALID_ENDPOINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getValidEndpoint() {
    return validEndpoint;
  }


  public void setValidEndpoint(Boolean validEndpoint) {
    this.validEndpoint = validEndpoint;
  }


  public ValidateUrlResponseFull wellFormedURL(String wellFormedURL) {
    
    this.wellFormedURL = wellFormedURL;
    return this;
  }

   /**
   * Well-formed version of the URL
   * @return wellFormedURL
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Well-formed version of the URL")
  @JsonProperty(JSON_PROPERTY_WELL_FORMED_U_R_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWellFormedURL() {
    return wellFormedURL;
  }


  public void setWellFormedURL(String wellFormedURL) {
    this.wellFormedURL = wellFormedURL;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ValidateUrlResponseFull validateUrlResponseFull = (ValidateUrlResponseFull) o;
    return Objects.equals(this.validURL, validateUrlResponseFull.validURL) &&
        Objects.equals(this.validSyntax, validateUrlResponseFull.validSyntax) &&
        Objects.equals(this.validDomain, validateUrlResponseFull.validDomain) &&
        Objects.equals(this.validEndpoint, validateUrlResponseFull.validEndpoint) &&
        Objects.equals(this.wellFormedURL, validateUrlResponseFull.wellFormedURL);
  }

  @Override
  public int hashCode() {
    return Objects.hash(validURL, validSyntax, validDomain, validEndpoint, wellFormedURL);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ValidateUrlResponseFull {\n");
    sb.append("    validURL: ").append(toIndentedString(validURL)).append("\n");
    sb.append("    validSyntax: ").append(toIndentedString(validSyntax)).append("\n");
    sb.append("    validDomain: ").append(toIndentedString(validDomain)).append("\n");
    sb.append("    validEndpoint: ").append(toIndentedString(validEndpoint)).append("\n");
    sb.append("    wellFormedURL: ").append(toIndentedString(wellFormedURL)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

