/*
 * validateapi
 * The validation APIs help you validate data. Check if an E-mail address is real. Check if a domain is real. Check up on an IP address, and even where it is located. All this and much more is available in the validation API.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * The result of a User-Agent validation request
 */
@ApiModel(description = "The result of a User-Agent validation request")
@JsonPropertyOrder({
  UserAgentValidateResponse.JSON_PROPERTY_SUCCESSFUL,
  UserAgentValidateResponse.JSON_PROPERTY_IS_BOT,
  UserAgentValidateResponse.JSON_PROPERTY_BOT_NAME,
  UserAgentValidateResponse.JSON_PROPERTY_BOT_U_R_L,
  UserAgentValidateResponse.JSON_PROPERTY_OPERATING_SYSTEM,
  UserAgentValidateResponse.JSON_PROPERTY_OPERATING_SYSTEM_C_P_U_PLATFORM,
  UserAgentValidateResponse.JSON_PROPERTY_OPERATING_SYSTEM_VERSION,
  UserAgentValidateResponse.JSON_PROPERTY_DEVICE_TYPE,
  UserAgentValidateResponse.JSON_PROPERTY_DEVICE_BRAND_NAME,
  UserAgentValidateResponse.JSON_PROPERTY_DEVICE_MODEL,
  UserAgentValidateResponse.JSON_PROPERTY_BROWSER_NAME,
  UserAgentValidateResponse.JSON_PROPERTY_BROWSER_VERSION,
  UserAgentValidateResponse.JSON_PROPERTY_BROWSER_ENGINE_NAME,
  UserAgentValidateResponse.JSON_PROPERTY_BROWSER_ENGINE_VERSION
})
@JsonTypeName("UserAgentValidateResponse")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:06.593-08:00[America/Los_Angeles]")
public class UserAgentValidateResponse {
  public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
  private Boolean successful;

  public static final String JSON_PROPERTY_IS_BOT = "IsBot";
  private Boolean isBot;

  public static final String JSON_PROPERTY_BOT_NAME = "BotName";
  private String botName;

  public static final String JSON_PROPERTY_BOT_U_R_L = "BotURL";
  private String botURL;

  public static final String JSON_PROPERTY_OPERATING_SYSTEM = "OperatingSystem";
  private String operatingSystem;

  public static final String JSON_PROPERTY_OPERATING_SYSTEM_C_P_U_PLATFORM = "OperatingSystemCPUPlatform";
  private String operatingSystemCPUPlatform;

  public static final String JSON_PROPERTY_OPERATING_SYSTEM_VERSION = "OperatingSystemVersion";
  private String operatingSystemVersion;

  public static final String JSON_PROPERTY_DEVICE_TYPE = "DeviceType";
  private String deviceType;

  public static final String JSON_PROPERTY_DEVICE_BRAND_NAME = "DeviceBrandName";
  private String deviceBrandName;

  public static final String JSON_PROPERTY_DEVICE_MODEL = "DeviceModel";
  private String deviceModel;

  public static final String JSON_PROPERTY_BROWSER_NAME = "BrowserName";
  private String browserName;

  public static final String JSON_PROPERTY_BROWSER_VERSION = "BrowserVersion";
  private String browserVersion;

  public static final String JSON_PROPERTY_BROWSER_ENGINE_NAME = "BrowserEngineName";
  private String browserEngineName;

  public static final String JSON_PROPERTY_BROWSER_ENGINE_VERSION = "BrowserEngineVersion";
  private String browserEngineVersion;


  public UserAgentValidateResponse successful(Boolean successful) {
    
    this.successful = successful;
    return this;
  }

   /**
   * True if the operation was successful, false otherwise
   * @return successful
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the operation was successful, false otherwise")
  @JsonProperty(JSON_PROPERTY_SUCCESSFUL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSuccessful() {
    return successful;
  }


  public void setSuccessful(Boolean successful) {
    this.successful = successful;
  }


  public UserAgentValidateResponse isBot(Boolean isBot) {
    
    this.isBot = isBot;
    return this;
  }

   /**
   * True if the request is a known robot, false otherwise
   * @return isBot
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the request is a known robot, false otherwise")
  @JsonProperty(JSON_PROPERTY_IS_BOT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsBot() {
    return isBot;
  }


  public void setIsBot(Boolean isBot) {
    this.isBot = isBot;
  }


  public UserAgentValidateResponse botName(String botName) {
    
    this.botName = botName;
    return this;
  }

   /**
   * Optional; name of the robot if the request was from a known robot, otherwise null
   * @return botName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional; name of the robot if the request was from a known robot, otherwise null")
  @JsonProperty(JSON_PROPERTY_BOT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBotName() {
    return botName;
  }


  public void setBotName(String botName) {
    this.botName = botName;
  }


  public UserAgentValidateResponse botURL(String botURL) {
    
    this.botURL = botURL;
    return this;
  }

   /**
   * Optional; if available, the URL to the robot
   * @return botURL
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional; if available, the URL to the robot")
  @JsonProperty(JSON_PROPERTY_BOT_U_R_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBotURL() {
    return botURL;
  }


  public void setBotURL(String botURL) {
    this.botURL = botURL;
  }


  public UserAgentValidateResponse operatingSystem(String operatingSystem) {
    
    this.operatingSystem = operatingSystem;
    return this;
  }

   /**
   * Operating System of the User-Agent (e.g. Windows)
   * @return operatingSystem
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Operating System of the User-Agent (e.g. Windows)")
  @JsonProperty(JSON_PROPERTY_OPERATING_SYSTEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOperatingSystem() {
    return operatingSystem;
  }


  public void setOperatingSystem(String operatingSystem) {
    this.operatingSystem = operatingSystem;
  }


  public UserAgentValidateResponse operatingSystemCPUPlatform(String operatingSystemCPUPlatform) {
    
    this.operatingSystemCPUPlatform = operatingSystemCPUPlatform;
    return this;
  }

   /**
   * The CPU platform of the User-Agent (e.g. x64)
   * @return operatingSystemCPUPlatform
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The CPU platform of the User-Agent (e.g. x64)")
  @JsonProperty(JSON_PROPERTY_OPERATING_SYSTEM_C_P_U_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOperatingSystemCPUPlatform() {
    return operatingSystemCPUPlatform;
  }


  public void setOperatingSystemCPUPlatform(String operatingSystemCPUPlatform) {
    this.operatingSystemCPUPlatform = operatingSystemCPUPlatform;
  }


  public UserAgentValidateResponse operatingSystemVersion(String operatingSystemVersion) {
    
    this.operatingSystemVersion = operatingSystemVersion;
    return this;
  }

   /**
   * The version of the operating system of the User-Agent (e.g. \&quot;10\&quot; for Windows 10)
   * @return operatingSystemVersion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The version of the operating system of the User-Agent (e.g. \"10\" for Windows 10)")
  @JsonProperty(JSON_PROPERTY_OPERATING_SYSTEM_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOperatingSystemVersion() {
    return operatingSystemVersion;
  }


  public void setOperatingSystemVersion(String operatingSystemVersion) {
    this.operatingSystemVersion = operatingSystemVersion;
  }


  public UserAgentValidateResponse deviceType(String deviceType) {
    
    this.deviceType = deviceType;
    return this;
  }

   /**
   * Device type of the User-Agent; possible values are \&quot;DESKTOP\&quot;, \&quot;SMARTPHONE\&quot;, \&quot;TABLET\&quot;
   * @return deviceType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Device type of the User-Agent; possible values are \"DESKTOP\", \"SMARTPHONE\", \"TABLET\"")
  @JsonProperty(JSON_PROPERTY_DEVICE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDeviceType() {
    return deviceType;
  }


  public void setDeviceType(String deviceType) {
    this.deviceType = deviceType;
  }


  public UserAgentValidateResponse deviceBrandName(String deviceBrandName) {
    
    this.deviceBrandName = deviceBrandName;
    return this;
  }

   /**
   * Brand name of the User-Agent
   * @return deviceBrandName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Brand name of the User-Agent")
  @JsonProperty(JSON_PROPERTY_DEVICE_BRAND_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDeviceBrandName() {
    return deviceBrandName;
  }


  public void setDeviceBrandName(String deviceBrandName) {
    this.deviceBrandName = deviceBrandName;
  }


  public UserAgentValidateResponse deviceModel(String deviceModel) {
    
    this.deviceModel = deviceModel;
    return this;
  }

   /**
   * Model name or number of the User-Agent
   * @return deviceModel
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Model name or number of the User-Agent")
  @JsonProperty(JSON_PROPERTY_DEVICE_MODEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDeviceModel() {
    return deviceModel;
  }


  public void setDeviceModel(String deviceModel) {
    this.deviceModel = deviceModel;
  }


  public UserAgentValidateResponse browserName(String browserName) {
    
    this.browserName = browserName;
    return this;
  }

   /**
   * Name of the Browser
   * @return browserName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Name of the Browser")
  @JsonProperty(JSON_PROPERTY_BROWSER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrowserName() {
    return browserName;
  }


  public void setBrowserName(String browserName) {
    this.browserName = browserName;
  }


  public UserAgentValidateResponse browserVersion(String browserVersion) {
    
    this.browserVersion = browserVersion;
    return this;
  }

   /**
   * Version of the Browser
   * @return browserVersion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Version of the Browser")
  @JsonProperty(JSON_PROPERTY_BROWSER_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrowserVersion() {
    return browserVersion;
  }


  public void setBrowserVersion(String browserVersion) {
    this.browserVersion = browserVersion;
  }


  public UserAgentValidateResponse browserEngineName(String browserEngineName) {
    
    this.browserEngineName = browserEngineName;
    return this;
  }

   /**
   * Name of the Browser Engine
   * @return browserEngineName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Name of the Browser Engine")
  @JsonProperty(JSON_PROPERTY_BROWSER_ENGINE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrowserEngineName() {
    return browserEngineName;
  }


  public void setBrowserEngineName(String browserEngineName) {
    this.browserEngineName = browserEngineName;
  }


  public UserAgentValidateResponse browserEngineVersion(String browserEngineVersion) {
    
    this.browserEngineVersion = browserEngineVersion;
    return this;
  }

   /**
   * Version of the Browser Engine
   * @return browserEngineVersion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Version of the Browser Engine")
  @JsonProperty(JSON_PROPERTY_BROWSER_ENGINE_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrowserEngineVersion() {
    return browserEngineVersion;
  }


  public void setBrowserEngineVersion(String browserEngineVersion) {
    this.browserEngineVersion = browserEngineVersion;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserAgentValidateResponse userAgentValidateResponse = (UserAgentValidateResponse) o;
    return Objects.equals(this.successful, userAgentValidateResponse.successful) &&
        Objects.equals(this.isBot, userAgentValidateResponse.isBot) &&
        Objects.equals(this.botName, userAgentValidateResponse.botName) &&
        Objects.equals(this.botURL, userAgentValidateResponse.botURL) &&
        Objects.equals(this.operatingSystem, userAgentValidateResponse.operatingSystem) &&
        Objects.equals(this.operatingSystemCPUPlatform, userAgentValidateResponse.operatingSystemCPUPlatform) &&
        Objects.equals(this.operatingSystemVersion, userAgentValidateResponse.operatingSystemVersion) &&
        Objects.equals(this.deviceType, userAgentValidateResponse.deviceType) &&
        Objects.equals(this.deviceBrandName, userAgentValidateResponse.deviceBrandName) &&
        Objects.equals(this.deviceModel, userAgentValidateResponse.deviceModel) &&
        Objects.equals(this.browserName, userAgentValidateResponse.browserName) &&
        Objects.equals(this.browserVersion, userAgentValidateResponse.browserVersion) &&
        Objects.equals(this.browserEngineName, userAgentValidateResponse.browserEngineName) &&
        Objects.equals(this.browserEngineVersion, userAgentValidateResponse.browserEngineVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(successful, isBot, botName, botURL, operatingSystem, operatingSystemCPUPlatform, operatingSystemVersion, deviceType, deviceBrandName, deviceModel, browserName, browserVersion, browserEngineName, browserEngineVersion);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserAgentValidateResponse {\n");
    sb.append("    successful: ").append(toIndentedString(successful)).append("\n");
    sb.append("    isBot: ").append(toIndentedString(isBot)).append("\n");
    sb.append("    botName: ").append(toIndentedString(botName)).append("\n");
    sb.append("    botURL: ").append(toIndentedString(botURL)).append("\n");
    sb.append("    operatingSystem: ").append(toIndentedString(operatingSystem)).append("\n");
    sb.append("    operatingSystemCPUPlatform: ").append(toIndentedString(operatingSystemCPUPlatform)).append("\n");
    sb.append("    operatingSystemVersion: ").append(toIndentedString(operatingSystemVersion)).append("\n");
    sb.append("    deviceType: ").append(toIndentedString(deviceType)).append("\n");
    sb.append("    deviceBrandName: ").append(toIndentedString(deviceBrandName)).append("\n");
    sb.append("    deviceModel: ").append(toIndentedString(deviceModel)).append("\n");
    sb.append("    browserName: ").append(toIndentedString(browserName)).append("\n");
    sb.append("    browserVersion: ").append(toIndentedString(browserVersion)).append("\n");
    sb.append("    browserEngineName: ").append(toIndentedString(browserEngineName)).append("\n");
    sb.append("    browserEngineVersion: ").append(toIndentedString(browserEngineVersion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

