/*
 * videoapi
 * The video APIs help you convert, encode, and transcode videos.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.cloudmersive.client.rt.model.StillFrame;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * The result of converting a video into still frames
 */
@ApiModel(description = "The result of converting a video into still frames")
@JsonPropertyOrder({
  StillFramesResult.JSON_PROPERTY_SUCCESSFUL,
  StillFramesResult.JSON_PROPERTY_TOTAL_FRAMES,
  StillFramesResult.JSON_PROPERTY_STILL_FRAMES
})
@JsonTypeName("StillFramesResult")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:28.728-08:00[America/Los_Angeles]")
public class StillFramesResult {
  public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
  private Boolean successful;

  public static final String JSON_PROPERTY_TOTAL_FRAMES = "TotalFrames";
  private Integer totalFrames;

  public static final String JSON_PROPERTY_STILL_FRAMES = "StillFrames";
  private List<StillFrame> stillFrames = null;


  public StillFramesResult successful(Boolean successful) {
    
    this.successful = successful;
    return this;
  }

   /**
   * True if the operation was successful, false otherwise
   * @return successful
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the operation was successful, false otherwise")
  @JsonProperty(JSON_PROPERTY_SUCCESSFUL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSuccessful() {
    return successful;
  }


  public void setSuccessful(Boolean successful) {
    this.successful = successful;
  }


  public StillFramesResult totalFrames(Integer totalFrames) {
    
    this.totalFrames = totalFrames;
    return this;
  }

   /**
   * The total number of frames converted
   * @return totalFrames
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The total number of frames converted")
  @JsonProperty(JSON_PROPERTY_TOTAL_FRAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalFrames() {
    return totalFrames;
  }


  public void setTotalFrames(Integer totalFrames) {
    this.totalFrames = totalFrames;
  }


  public StillFramesResult stillFrames(List<StillFrame> stillFrames) {
    
    this.stillFrames = stillFrames;
    return this;
  }

  public StillFramesResult addStillFramesItem(StillFrame stillFramesItem) {
    if (this.stillFrames == null) {
      this.stillFrames = new ArrayList<StillFrame>();
    }
    this.stillFrames.add(stillFramesItem);
    return this;
  }

   /**
   * Individual still frames from the conversion operation
   * @return stillFrames
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Individual still frames from the conversion operation")
  @JsonProperty(JSON_PROPERTY_STILL_FRAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<StillFrame> getStillFrames() {
    return stillFrames;
  }


  public void setStillFrames(List<StillFrame> stillFrames) {
    this.stillFrames = stillFrames;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StillFramesResult stillFramesResult = (StillFramesResult) o;
    return Objects.equals(this.successful, stillFramesResult.successful) &&
        Objects.equals(this.totalFrames, stillFramesResult.totalFrames) &&
        Objects.equals(this.stillFrames, stillFramesResult.stillFrames);
  }

  @Override
  public int hashCode() {
    return Objects.hash(successful, totalFrames, stillFrames);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StillFramesResult {\n");
    sb.append("    successful: ").append(toIndentedString(successful)).append("\n");
    sb.append("    totalFrames: ").append(toIndentedString(totalFrames)).append("\n");
    sb.append("    stillFrames: ").append(toIndentedString(stillFrames)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

