/*
 * nlpapiv2
 * The powerful Natural Language Processing APIs (v2) let you perform part of speech tagging, entity identification, sentence parsing, and much more to help you understand the meaning of unstructured text.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.cloudmersive.client.rt.model.RephrasedSentence;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Output of a text rephrasing operation
 */
@ApiModel(description = "Output of a text rephrasing operation")
@JsonPropertyOrder({
  RephraseResponse.JSON_PROPERTY_SUCCESSFUL,
  RephraseResponse.JSON_PROPERTY_REPHRASED_RESULTS,
  RephraseResponse.JSON_PROPERTY_SENTENCE_COUNT
})
@JsonTypeName("RephraseResponse")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:09.229-08:00[America/Los_Angeles]")
public class RephraseResponse {
  public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
  private Boolean successful;

  public static final String JSON_PROPERTY_REPHRASED_RESULTS = "RephrasedResults";
  private List<RephrasedSentence> rephrasedResults = null;

  public static final String JSON_PROPERTY_SENTENCE_COUNT = "SentenceCount";
  private Integer sentenceCount;


  public RephraseResponse successful(Boolean successful) {
    
    this.successful = successful;
    return this;
  }

   /**
   * True if the language detection operation was successful, false otherwise
   * @return successful
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the language detection operation was successful, false otherwise")
  @JsonProperty(JSON_PROPERTY_SUCCESSFUL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSuccessful() {
    return successful;
  }


  public void setSuccessful(Boolean successful) {
    this.successful = successful;
  }


  public RephraseResponse rephrasedResults(List<RephrasedSentence> rephrasedResults) {
    
    this.rephrasedResults = rephrasedResults;
    return this;
  }

  public RephraseResponse addRephrasedResultsItem(RephrasedSentence rephrasedResultsItem) {
    if (this.rephrasedResults == null) {
      this.rephrasedResults = new ArrayList<RephrasedSentence>();
    }
    this.rephrasedResults.add(rephrasedResultsItem);
    return this;
  }

   /**
   * Results of the rephrasing, paraphrasing operation, in the order of the input sentences
   * @return rephrasedResults
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Results of the rephrasing, paraphrasing operation, in the order of the input sentences")
  @JsonProperty(JSON_PROPERTY_REPHRASED_RESULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RephrasedSentence> getRephrasedResults() {
    return rephrasedResults;
  }


  public void setRephrasedResults(List<RephrasedSentence> rephrasedResults) {
    this.rephrasedResults = rephrasedResults;
  }


  public RephraseResponse sentenceCount(Integer sentenceCount) {
    
    this.sentenceCount = sentenceCount;
    return this;
  }

   /**
   * Number of sentences in input text
   * @return sentenceCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Number of sentences in input text")
  @JsonProperty(JSON_PROPERTY_SENTENCE_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSentenceCount() {
    return sentenceCount;
  }


  public void setSentenceCount(Integer sentenceCount) {
    this.sentenceCount = sentenceCount;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RephraseResponse rephraseResponse = (RephraseResponse) o;
    return Objects.equals(this.successful, rephraseResponse.successful) &&
        Objects.equals(this.rephrasedResults, rephraseResponse.rephrasedResults) &&
        Objects.equals(this.sentenceCount, rephraseResponse.sentenceCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(successful, rephrasedResults, sentenceCount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RephraseResponse {\n");
    sb.append("    successful: ").append(toIndentedString(successful)).append("\n");
    sb.append("    rephrasedResults: ").append(toIndentedString(rephrasedResults)).append("\n");
    sb.append("    sentenceCount: ").append(toIndentedString(sentenceCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

