/*
 * validateapi
 * The validation APIs help you validate data. Check if an E-mail address is real. Check if a domain is real. Check up on an IP address, and even where it is located. All this and much more is available in the validation API.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Result from validating a phone number
 */
@ApiModel(description = "Result from validating a phone number")
@JsonPropertyOrder({
  PhoneNumberValidationResponse.JSON_PROPERTY_IS_VALID,
  PhoneNumberValidationResponse.JSON_PROPERTY_SUCCESSFUL,
  PhoneNumberValidationResponse.JSON_PROPERTY_PHONE_NUMBER_TYPE,
  PhoneNumberValidationResponse.JSON_PROPERTY_E164_FORMAT,
  PhoneNumberValidationResponse.JSON_PROPERTY_INTERNATIONAL_FORMAT,
  PhoneNumberValidationResponse.JSON_PROPERTY_NATIONAL_FORMAT,
  PhoneNumberValidationResponse.JSON_PROPERTY_COUNTRY_CODE,
  PhoneNumberValidationResponse.JSON_PROPERTY_COUNTRY_NAME
})
@JsonTypeName("PhoneNumberValidationResponse")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:06.593-08:00[America/Los_Angeles]")
public class PhoneNumberValidationResponse {
  public static final String JSON_PROPERTY_IS_VALID = "IsValid";
  private Boolean isValid;

  public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
  private Boolean successful;

  public static final String JSON_PROPERTY_PHONE_NUMBER_TYPE = "PhoneNumberType";
  private String phoneNumberType;

  public static final String JSON_PROPERTY_E164_FORMAT = "E164Format";
  private String e164Format;

  public static final String JSON_PROPERTY_INTERNATIONAL_FORMAT = "InternationalFormat";
  private String internationalFormat;

  public static final String JSON_PROPERTY_NATIONAL_FORMAT = "NationalFormat";
  private String nationalFormat;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "CountryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_COUNTRY_NAME = "CountryName";
  private String countryName;


  public PhoneNumberValidationResponse isValid(Boolean isValid) {
    
    this.isValid = isValid;
    return this;
  }

   /**
   * True if the phone number is valid, false otherwise
   * @return isValid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the phone number is valid, false otherwise")
  @JsonProperty(JSON_PROPERTY_IS_VALID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsValid() {
    return isValid;
  }


  public void setIsValid(Boolean isValid) {
    this.isValid = isValid;
  }


  public PhoneNumberValidationResponse successful(Boolean successful) {
    
    this.successful = successful;
    return this;
  }

   /**
   * True if the operation was successful, false if there was an error during validation.  See IsValid for validation result.
   * @return successful
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the operation was successful, false if there was an error during validation.  See IsValid for validation result.")
  @JsonProperty(JSON_PROPERTY_SUCCESSFUL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSuccessful() {
    return successful;
  }


  public void setSuccessful(Boolean successful) {
    this.successful = successful;
  }


  public PhoneNumberValidationResponse phoneNumberType(String phoneNumberType) {
    
    this.phoneNumberType = phoneNumberType;
    return this;
  }

   /**
   * Type of phone number; possible values are: FixedLine, Mobile, FixedLineOrMobile, TollFree, PremiumRate,   SharedCost, Voip, PersonalNumber, Pager, Uan, Voicemail, Unknown
   * @return phoneNumberType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Type of phone number; possible values are: FixedLine, Mobile, FixedLineOrMobile, TollFree, PremiumRate,   SharedCost, Voip, PersonalNumber, Pager, Uan, Voicemail, Unknown")
  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPhoneNumberType() {
    return phoneNumberType;
  }


  public void setPhoneNumberType(String phoneNumberType) {
    this.phoneNumberType = phoneNumberType;
  }


  public PhoneNumberValidationResponse e164Format(String e164Format) {
    
    this.e164Format = e164Format;
    return this;
  }

   /**
   * E.164 format of the phone number
   * @return e164Format
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "E.164 format of the phone number")
  @JsonProperty(JSON_PROPERTY_E164_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getE164Format() {
    return e164Format;
  }


  public void setE164Format(String e164Format) {
    this.e164Format = e164Format;
  }


  public PhoneNumberValidationResponse internationalFormat(String internationalFormat) {
    
    this.internationalFormat = internationalFormat;
    return this;
  }

   /**
   * Internaltional format of the phone number
   * @return internationalFormat
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Internaltional format of the phone number")
  @JsonProperty(JSON_PROPERTY_INTERNATIONAL_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInternationalFormat() {
    return internationalFormat;
  }


  public void setInternationalFormat(String internationalFormat) {
    this.internationalFormat = internationalFormat;
  }


  public PhoneNumberValidationResponse nationalFormat(String nationalFormat) {
    
    this.nationalFormat = nationalFormat;
    return this;
  }

   /**
   * National format of the phone number
   * @return nationalFormat
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "National format of the phone number")
  @JsonProperty(JSON_PROPERTY_NATIONAL_FORMAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNationalFormat() {
    return nationalFormat;
  }


  public void setNationalFormat(String nationalFormat) {
    this.nationalFormat = nationalFormat;
  }


  public PhoneNumberValidationResponse countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Two digit country code of the phone number
   * @return countryCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Two digit country code of the phone number")
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public PhoneNumberValidationResponse countryName(String countryName) {
    
    this.countryName = countryName;
    return this;
  }

   /**
   * User-friendly long name of the country for the phone number
   * @return countryName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "User-friendly long name of the country for the phone number")
  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryName() {
    return countryName;
  }


  public void setCountryName(String countryName) {
    this.countryName = countryName;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PhoneNumberValidationResponse phoneNumberValidationResponse = (PhoneNumberValidationResponse) o;
    return Objects.equals(this.isValid, phoneNumberValidationResponse.isValid) &&
        Objects.equals(this.successful, phoneNumberValidationResponse.successful) &&
        Objects.equals(this.phoneNumberType, phoneNumberValidationResponse.phoneNumberType) &&
        Objects.equals(this.e164Format, phoneNumberValidationResponse.e164Format) &&
        Objects.equals(this.internationalFormat, phoneNumberValidationResponse.internationalFormat) &&
        Objects.equals(this.nationalFormat, phoneNumberValidationResponse.nationalFormat) &&
        Objects.equals(this.countryCode, phoneNumberValidationResponse.countryCode) &&
        Objects.equals(this.countryName, phoneNumberValidationResponse.countryName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isValid, successful, phoneNumberType, e164Format, internationalFormat, nationalFormat, countryCode, countryName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PhoneNumberValidationResponse {\n");
    sb.append("    isValid: ").append(toIndentedString(isValid)).append("\n");
    sb.append("    successful: ").append(toIndentedString(successful)).append("\n");
    sb.append("    phoneNumberType: ").append(toIndentedString(phoneNumberType)).append("\n");
    sb.append("    e164Format: ").append(toIndentedString(e164Format)).append("\n");
    sb.append("    internationalFormat: ").append(toIndentedString(internationalFormat)).append("\n");
    sb.append("    nationalFormat: ").append(toIndentedString(nationalFormat)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    countryName: ").append(toIndentedString(countryName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

