/*
 * ocrapi
 * The powerful Optical Character Recognition (OCR) APIs let you convert scanned images of pages into recognized text.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * OcrPageResult
 */
@JsonPropertyOrder({
  OcrPageResult.JSON_PROPERTY_PAGE_NUMBER,
  OcrPageResult.JSON_PROPERTY_MEAN_CONFIDENCE_LEVEL,
  OcrPageResult.JSON_PROPERTY_TEXT_RESULT
})
@JsonTypeName("OcrPageResult")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:12.411-08:00[America/Los_Angeles]")
public class OcrPageResult {
  public static final String JSON_PROPERTY_PAGE_NUMBER = "PageNumber";
  private Integer pageNumber;

  public static final String JSON_PROPERTY_MEAN_CONFIDENCE_LEVEL = "MeanConfidenceLevel";
  private Float meanConfidenceLevel;

  public static final String JSON_PROPERTY_TEXT_RESULT = "TextResult";
  private String textResult;


  public OcrPageResult pageNumber(Integer pageNumber) {
    
    this.pageNumber = pageNumber;
    return this;
  }

   /**
   * Page number of the page that was OCR-ed, starting with 1 for the first page in the PDF file
   * @return pageNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Page number of the page that was OCR-ed, starting with 1 for the first page in the PDF file")
  @JsonProperty(JSON_PROPERTY_PAGE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPageNumber() {
    return pageNumber;
  }


  public void setPageNumber(Integer pageNumber) {
    this.pageNumber = pageNumber;
  }


  public OcrPageResult meanConfidenceLevel(Float meanConfidenceLevel) {
    
    this.meanConfidenceLevel = meanConfidenceLevel;
    return this;
  }

   /**
   * Confidence level rating of the OCR operation; ratings above 80% are strong.
   * @return meanConfidenceLevel
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Confidence level rating of the OCR operation; ratings above 80% are strong.")
  @JsonProperty(JSON_PROPERTY_MEAN_CONFIDENCE_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getMeanConfidenceLevel() {
    return meanConfidenceLevel;
  }


  public void setMeanConfidenceLevel(Float meanConfidenceLevel) {
    this.meanConfidenceLevel = meanConfidenceLevel;
  }


  public OcrPageResult textResult(String textResult) {
    
    this.textResult = textResult;
    return this;
  }

   /**
   * Converted text string from the image input.
   * @return textResult
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Converted text string from the image input.")
  @JsonProperty(JSON_PROPERTY_TEXT_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTextResult() {
    return textResult;
  }


  public void setTextResult(String textResult) {
    this.textResult = textResult;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OcrPageResult ocrPageResult = (OcrPageResult) o;
    return Objects.equals(this.pageNumber, ocrPageResult.pageNumber) &&
        Objects.equals(this.meanConfidenceLevel, ocrPageResult.meanConfidenceLevel) &&
        Objects.equals(this.textResult, ocrPageResult.textResult);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageNumber, meanConfidenceLevel, textResult);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OcrPageResult {\n");
    sb.append("    pageNumber: ").append(toIndentedString(pageNumber)).append("\n");
    sb.append("    meanConfidenceLevel: ").append(toIndentedString(meanConfidenceLevel)).append("\n");
    sb.append("    textResult: ").append(toIndentedString(textResult)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

