/*
 * videoapi
 * The video APIs help you convert, encode, and transcode videos.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.cloudmersive.client.rt.model.NsfwScannedFrame;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * The result of scanning a video file for NSFW content
 */
@ApiModel(description = "The result of scanning a video file for NSFW content")
@JsonPropertyOrder({
  NsfwResult.JSON_PROPERTY_SUCCESSFUL,
  NsfwResult.JSON_PROPERTY_HIGHEST_CLASSIFICATION_RESULT,
  NsfwResult.JSON_PROPERTY_HIGHEST_SCORE,
  NsfwResult.JSON_PROPERTY_TOTAL_RACY_FRAMES,
  NsfwResult.JSON_PROPERTY_TOTAL_NSFW_FRAMES,
  NsfwResult.JSON_PROPERTY_TOTAL_FRAMES,
  NsfwResult.JSON_PROPERTY_NSFW_SCANNED_FRAMES
})
@JsonTypeName("NsfwResult")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:28.728-08:00[America/Los_Angeles]")
public class NsfwResult {
  public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
  private Boolean successful;

  public static final String JSON_PROPERTY_HIGHEST_CLASSIFICATION_RESULT = "HighestClassificationResult";
  private String highestClassificationResult;

  public static final String JSON_PROPERTY_HIGHEST_SCORE = "HighestScore";
  private Double highestScore;

  public static final String JSON_PROPERTY_TOTAL_RACY_FRAMES = "TotalRacyFrames";
  private Integer totalRacyFrames;

  public static final String JSON_PROPERTY_TOTAL_NSFW_FRAMES = "TotalNsfwFrames";
  private Integer totalNsfwFrames;

  public static final String JSON_PROPERTY_TOTAL_FRAMES = "TotalFrames";
  private Integer totalFrames;

  public static final String JSON_PROPERTY_NSFW_SCANNED_FRAMES = "NsfwScannedFrames";
  private List<NsfwScannedFrame> nsfwScannedFrames = null;


  public NsfwResult successful(Boolean successful) {
    
    this.successful = successful;
    return this;
  }

   /**
   * True if the operation was successful, false otherwise
   * @return successful
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the operation was successful, false otherwise")
  @JsonProperty(JSON_PROPERTY_SUCCESSFUL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSuccessful() {
    return successful;
  }


  public void setSuccessful(Boolean successful) {
    this.successful = successful;
  }


  public NsfwResult highestClassificationResult(String highestClassificationResult) {
    
    this.highestClassificationResult = highestClassificationResult;
    return this;
  }

   /**
   * The highest NSFW classification of the video
   * @return highestClassificationResult
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The highest NSFW classification of the video")
  @JsonProperty(JSON_PROPERTY_HIGHEST_CLASSIFICATION_RESULT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHighestClassificationResult() {
    return highestClassificationResult;
  }


  public void setHighestClassificationResult(String highestClassificationResult) {
    this.highestClassificationResult = highestClassificationResult;
  }


  public NsfwResult highestScore(Double highestScore) {
    
    this.highestScore = highestScore;
    return this;
  }

   /**
   * The highest NSFW score out of all frames scanned
   * @return highestScore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The highest NSFW score out of all frames scanned")
  @JsonProperty(JSON_PROPERTY_HIGHEST_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getHighestScore() {
    return highestScore;
  }


  public void setHighestScore(Double highestScore) {
    this.highestScore = highestScore;
  }


  public NsfwResult totalRacyFrames(Integer totalRacyFrames) {
    
    this.totalRacyFrames = totalRacyFrames;
    return this;
  }

   /**
   * The total number of potentially \&quot;racy\&quot; frames.
   * @return totalRacyFrames
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The total number of potentially \"racy\" frames.")
  @JsonProperty(JSON_PROPERTY_TOTAL_RACY_FRAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalRacyFrames() {
    return totalRacyFrames;
  }


  public void setTotalRacyFrames(Integer totalRacyFrames) {
    this.totalRacyFrames = totalRacyFrames;
  }


  public NsfwResult totalNsfwFrames(Integer totalNsfwFrames) {
    
    this.totalNsfwFrames = totalNsfwFrames;
    return this;
  }

   /**
   * The total number of frames with high probability of NSFW.
   * @return totalNsfwFrames
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The total number of frames with high probability of NSFW.")
  @JsonProperty(JSON_PROPERTY_TOTAL_NSFW_FRAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalNsfwFrames() {
    return totalNsfwFrames;
  }


  public void setTotalNsfwFrames(Integer totalNsfwFrames) {
    this.totalNsfwFrames = totalNsfwFrames;
  }


  public NsfwResult totalFrames(Integer totalFrames) {
    
    this.totalFrames = totalFrames;
    return this;
  }

   /**
   * The total number of frames scanned
   * @return totalFrames
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The total number of frames scanned")
  @JsonProperty(JSON_PROPERTY_TOTAL_FRAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalFrames() {
    return totalFrames;
  }


  public void setTotalFrames(Integer totalFrames) {
    this.totalFrames = totalFrames;
  }


  public NsfwResult nsfwScannedFrames(List<NsfwScannedFrame> nsfwScannedFrames) {
    
    this.nsfwScannedFrames = nsfwScannedFrames;
    return this;
  }

  public NsfwResult addNsfwScannedFramesItem(NsfwScannedFrame nsfwScannedFramesItem) {
    if (this.nsfwScannedFrames == null) {
      this.nsfwScannedFrames = new ArrayList<NsfwScannedFrame>();
    }
    this.nsfwScannedFrames.add(nsfwScannedFramesItem);
    return this;
  }

   /**
   * The NSFW scanning results for each frame
   * @return nsfwScannedFrames
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The NSFW scanning results for each frame")
  @JsonProperty(JSON_PROPERTY_NSFW_SCANNED_FRAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<NsfwScannedFrame> getNsfwScannedFrames() {
    return nsfwScannedFrames;
  }


  public void setNsfwScannedFrames(List<NsfwScannedFrame> nsfwScannedFrames) {
    this.nsfwScannedFrames = nsfwScannedFrames;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NsfwResult nsfwResult = (NsfwResult) o;
    return Objects.equals(this.successful, nsfwResult.successful) &&
        Objects.equals(this.highestClassificationResult, nsfwResult.highestClassificationResult) &&
        Objects.equals(this.highestScore, nsfwResult.highestScore) &&
        Objects.equals(this.totalRacyFrames, nsfwResult.totalRacyFrames) &&
        Objects.equals(this.totalNsfwFrames, nsfwResult.totalNsfwFrames) &&
        Objects.equals(this.totalFrames, nsfwResult.totalFrames) &&
        Objects.equals(this.nsfwScannedFrames, nsfwResult.nsfwScannedFrames);
  }

  @Override
  public int hashCode() {
    return Objects.hash(successful, highestClassificationResult, highestScore, totalRacyFrames, totalNsfwFrames, totalFrames, nsfwScannedFrames);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NsfwResult {\n");
    sb.append("    successful: ").append(toIndentedString(successful)).append("\n");
    sb.append("    highestClassificationResult: ").append(toIndentedString(highestClassificationResult)).append("\n");
    sb.append("    highestScore: ").append(toIndentedString(highestScore)).append("\n");
    sb.append("    totalRacyFrames: ").append(toIndentedString(totalRacyFrames)).append("\n");
    sb.append("    totalNsfwFrames: ").append(toIndentedString(totalNsfwFrames)).append("\n");
    sb.append("    totalFrames: ").append(toIndentedString(totalFrames)).append("\n");
    sb.append("    nsfwScannedFrames: ").append(toIndentedString(nsfwScannedFrames)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

