/*
 * validateapi
 * The validation APIs help you validate data. Check if an E-mail address is real. Check if a domain is real. Check up on an IP address, and even where it is located. All this and much more is available in the validation API.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Result of a full name validation operation
 */
@ApiModel(description = "Result of a full name validation operation")
@JsonPropertyOrder({
  FullNameValidationResponse.JSON_PROPERTY_SUCCESSFUL,
  FullNameValidationResponse.JSON_PROPERTY_VALIDATION_RESULT_FIRST_NAME,
  FullNameValidationResponse.JSON_PROPERTY_VALIDATION_RESULT_LAST_NAME,
  FullNameValidationResponse.JSON_PROPERTY_TITLE,
  FullNameValidationResponse.JSON_PROPERTY_FIRST_NAME,
  FullNameValidationResponse.JSON_PROPERTY_MIDDLE_NAME,
  FullNameValidationResponse.JSON_PROPERTY_LAST_NAME,
  FullNameValidationResponse.JSON_PROPERTY_NICK_NAME,
  FullNameValidationResponse.JSON_PROPERTY_SUFFIX,
  FullNameValidationResponse.JSON_PROPERTY_DISPLAY_NAME
})
@JsonTypeName("FullNameValidationResponse")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:06.593-08:00[America/Los_Angeles]")
public class FullNameValidationResponse {
  public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
  private Boolean successful;

  public static final String JSON_PROPERTY_VALIDATION_RESULT_FIRST_NAME = "ValidationResult_FirstName";
  private String validationResultFirstName;

  public static final String JSON_PROPERTY_VALIDATION_RESULT_LAST_NAME = "ValidationResult_LastName";
  private String validationResultLastName;

  public static final String JSON_PROPERTY_TITLE = "Title";
  private String title;

  public static final String JSON_PROPERTY_FIRST_NAME = "FirstName";
  private String firstName;

  public static final String JSON_PROPERTY_MIDDLE_NAME = "MiddleName";
  private String middleName;

  public static final String JSON_PROPERTY_LAST_NAME = "LastName";
  private String lastName;

  public static final String JSON_PROPERTY_NICK_NAME = "NickName";
  private String nickName;

  public static final String JSON_PROPERTY_SUFFIX = "Suffix";
  private String suffix;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "DisplayName";
  private String displayName;


  public FullNameValidationResponse successful(Boolean successful) {
    
    this.successful = successful;
    return this;
  }

   /**
   * True if the validation operation was successful, false otherwise
   * @return successful
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the validation operation was successful, false otherwise")
  @JsonProperty(JSON_PROPERTY_SUCCESSFUL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSuccessful() {
    return successful;
  }


  public void setSuccessful(Boolean successful) {
    this.successful = successful;
  }


  public FullNameValidationResponse validationResultFirstName(String validationResultFirstName) {
    
    this.validationResultFirstName = validationResultFirstName;
    return this;
  }

   /**
   * Possible values are: ValidFirstName, ValidUnknownFirstName, InvalidSpamInput, InvalidCharacters, InvalidEmpty
   * @return validationResultFirstName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Possible values are: ValidFirstName, ValidUnknownFirstName, InvalidSpamInput, InvalidCharacters, InvalidEmpty")
  @JsonProperty(JSON_PROPERTY_VALIDATION_RESULT_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getValidationResultFirstName() {
    return validationResultFirstName;
  }


  public void setValidationResultFirstName(String validationResultFirstName) {
    this.validationResultFirstName = validationResultFirstName;
  }


  public FullNameValidationResponse validationResultLastName(String validationResultLastName) {
    
    this.validationResultLastName = validationResultLastName;
    return this;
  }

   /**
   * Possible values are: ValidLastName, ValidUnknownLastName, InvalidSpamInput, InvalidCharacters, InvalidEmpty
   * @return validationResultLastName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Possible values are: ValidLastName, ValidUnknownLastName, InvalidSpamInput, InvalidCharacters, InvalidEmpty")
  @JsonProperty(JSON_PROPERTY_VALIDATION_RESULT_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getValidationResultLastName() {
    return validationResultLastName;
  }


  public void setValidationResultLastName(String validationResultLastName) {
    this.validationResultLastName = validationResultLastName;
  }


  public FullNameValidationResponse title(String title) {
    
    this.title = title;
    return this;
  }

   /**
   * The person&#39;s title (if supplied), e.g. \&quot;Mr.\&quot; or \&quot;Ms.\&quot;
   * @return title
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The person's title (if supplied), e.g. \"Mr.\" or \"Ms.\"")
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTitle() {
    return title;
  }


  public void setTitle(String title) {
    this.title = title;
  }


  public FullNameValidationResponse firstName(String firstName) {
    
    this.firstName = firstName;
    return this;
  }

   /**
   * The first name (given name)
   * @return firstName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The first name (given name)")
  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFirstName() {
    return firstName;
  }


  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }


  public FullNameValidationResponse middleName(String middleName) {
    
    this.middleName = middleName;
    return this;
  }

   /**
   * The middle name(s); if there are multiple names they will be separated by spaces
   * @return middleName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The middle name(s); if there are multiple names they will be separated by spaces")
  @JsonProperty(JSON_PROPERTY_MIDDLE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMiddleName() {
    return middleName;
  }


  public void setMiddleName(String middleName) {
    this.middleName = middleName;
  }


  public FullNameValidationResponse lastName(String lastName) {
    
    this.lastName = lastName;
    return this;
  }

   /**
   * The last name (surname)
   * @return lastName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The last name (surname)")
  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLastName() {
    return lastName;
  }


  public void setLastName(String lastName) {
    this.lastName = lastName;
  }


  public FullNameValidationResponse nickName(String nickName) {
    
    this.nickName = nickName;
    return this;
  }

   /**
   * Nickname (if supplied)
   * @return nickName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Nickname (if supplied)")
  @JsonProperty(JSON_PROPERTY_NICK_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNickName() {
    return nickName;
  }


  public void setNickName(String nickName) {
    this.nickName = nickName;
  }


  public FullNameValidationResponse suffix(String suffix) {
    
    this.suffix = suffix;
    return this;
  }

   /**
   * Suffix to the name, e.g. \&quot;Jr.\&quot; or \&quot;Sr.\&quot;
   * @return suffix
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Suffix to the name, e.g. \"Jr.\" or \"Sr.\"")
  @JsonProperty(JSON_PROPERTY_SUFFIX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSuffix() {
    return suffix;
  }


  public void setSuffix(String suffix) {
    this.suffix = suffix;
  }


  public FullNameValidationResponse displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * The full display name of the name
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The full display name of the name")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FullNameValidationResponse fullNameValidationResponse = (FullNameValidationResponse) o;
    return Objects.equals(this.successful, fullNameValidationResponse.successful) &&
        Objects.equals(this.validationResultFirstName, fullNameValidationResponse.validationResultFirstName) &&
        Objects.equals(this.validationResultLastName, fullNameValidationResponse.validationResultLastName) &&
        Objects.equals(this.title, fullNameValidationResponse.title) &&
        Objects.equals(this.firstName, fullNameValidationResponse.firstName) &&
        Objects.equals(this.middleName, fullNameValidationResponse.middleName) &&
        Objects.equals(this.lastName, fullNameValidationResponse.lastName) &&
        Objects.equals(this.nickName, fullNameValidationResponse.nickName) &&
        Objects.equals(this.suffix, fullNameValidationResponse.suffix) &&
        Objects.equals(this.displayName, fullNameValidationResponse.displayName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(successful, validationResultFirstName, validationResultLastName, title, firstName, middleName, lastName, nickName, suffix, displayName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FullNameValidationResponse {\n");
    sb.append("    successful: ").append(toIndentedString(successful)).append("\n");
    sb.append("    validationResultFirstName: ").append(toIndentedString(validationResultFirstName)).append("\n");
    sb.append("    validationResultLastName: ").append(toIndentedString(validationResultLastName)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    middleName: ").append(toIndentedString(middleName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    nickName: ").append(toIndentedString(nickName)).append("\n");
    sb.append("    suffix: ").append(toIndentedString(suffix)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

