/*
 * ocrapi
 * The powerful Optical Character Recognition (OCR) APIs let you convert scanned images of pages into recognized text.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.cloudmersive.client.rt.model.FormTableColumnDefinition;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Definition of a form table for OCR data extraction from images
 */
@ApiModel(description = "Definition of a form table for OCR data extraction from images")
@JsonPropertyOrder({
  FormTableDefinition.JSON_PROPERTY_TABLE_I_D,
  FormTableDefinition.JSON_PROPERTY_COLUMN_DEFINITIONS,
  FormTableDefinition.JSON_PROPERTY_TARGET_TABLE_HEIGHT_RELATIVE,
  FormTableDefinition.JSON_PROPERTY_TARGET_ROW_HEIGHT_RELATIVE
})
@JsonTypeName("FormTableDefinition")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:12.411-08:00[America/Los_Angeles]")
public class FormTableDefinition {
  public static final String JSON_PROPERTY_TABLE_I_D = "TableID";
  private String tableID;

  public static final String JSON_PROPERTY_COLUMN_DEFINITIONS = "ColumnDefinitions";
  private List<FormTableColumnDefinition> columnDefinitions = null;

  public static final String JSON_PROPERTY_TARGET_TABLE_HEIGHT_RELATIVE = "TargetTableHeight_Relative";
  private Double targetTableHeightRelative;

  public static final String JSON_PROPERTY_TARGET_ROW_HEIGHT_RELATIVE = "TargetRowHeight_Relative";
  private Double targetRowHeightRelative;


  public FormTableDefinition tableID(String tableID) {
    
    this.tableID = tableID;
    return this;
  }

   /**
   * Optional; the ID of the table
   * @return tableID
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional; the ID of the table")
  @JsonProperty(JSON_PROPERTY_TABLE_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTableID() {
    return tableID;
  }


  public void setTableID(String tableID) {
    this.tableID = tableID;
  }


  public FormTableDefinition columnDefinitions(List<FormTableColumnDefinition> columnDefinitions) {
    
    this.columnDefinitions = columnDefinitions;
    return this;
  }

  public FormTableDefinition addColumnDefinitionsItem(FormTableColumnDefinition columnDefinitionsItem) {
    if (this.columnDefinitions == null) {
      this.columnDefinitions = new ArrayList<FormTableColumnDefinition>();
    }
    this.columnDefinitions.add(columnDefinitionsItem);
    return this;
  }

   /**
   * Definition of the columns in the table
   * @return columnDefinitions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Definition of the columns in the table")
  @JsonProperty(JSON_PROPERTY_COLUMN_DEFINITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<FormTableColumnDefinition> getColumnDefinitions() {
    return columnDefinitions;
  }


  public void setColumnDefinitions(List<FormTableColumnDefinition> columnDefinitions) {
    this.columnDefinitions = columnDefinitions;
  }


  public FormTableDefinition targetTableHeightRelative(Double targetTableHeightRelative) {
    
    this.targetTableHeightRelative = targetTableHeightRelative;
    return this;
  }

   /**
   * Optional - scale factor for target table height - relative to maximum height of headers of columns
   * @return targetTableHeightRelative
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional - scale factor for target table height - relative to maximum height of headers of columns")
  @JsonProperty(JSON_PROPERTY_TARGET_TABLE_HEIGHT_RELATIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getTargetTableHeightRelative() {
    return targetTableHeightRelative;
  }


  public void setTargetTableHeightRelative(Double targetTableHeightRelative) {
    this.targetTableHeightRelative = targetTableHeightRelative;
  }


  public FormTableDefinition targetRowHeightRelative(Double targetRowHeightRelative) {
    
    this.targetRowHeightRelative = targetRowHeightRelative;
    return this;
  }

   /**
   * Optional - scale factor for target row height - relative to height of column header
   * @return targetRowHeightRelative
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional - scale factor for target row height - relative to height of column header")
  @JsonProperty(JSON_PROPERTY_TARGET_ROW_HEIGHT_RELATIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getTargetRowHeightRelative() {
    return targetRowHeightRelative;
  }


  public void setTargetRowHeightRelative(Double targetRowHeightRelative) {
    this.targetRowHeightRelative = targetRowHeightRelative;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FormTableDefinition formTableDefinition = (FormTableDefinition) o;
    return Objects.equals(this.tableID, formTableDefinition.tableID) &&
        Objects.equals(this.columnDefinitions, formTableDefinition.columnDefinitions) &&
        Objects.equals(this.targetTableHeightRelative, formTableDefinition.targetTableHeightRelative) &&
        Objects.equals(this.targetRowHeightRelative, formTableDefinition.targetRowHeightRelative);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tableID, columnDefinitions, targetTableHeightRelative, targetRowHeightRelative);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FormTableDefinition {\n");
    sb.append("    tableID: ").append(toIndentedString(tableID)).append("\n");
    sb.append("    columnDefinitions: ").append(toIndentedString(columnDefinitions)).append("\n");
    sb.append("    targetTableHeightRelative: ").append(toIndentedString(targetTableHeightRelative)).append("\n");
    sb.append("    targetRowHeightRelative: ").append(toIndentedString(targetRowHeightRelative)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

