/*
 * imageapi
 * Image Recognition and Processing APIs let you use Machine Learning to recognize and process images, and also perform useful image modification operations.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.cloudmersive.client.rt.model.FineTextItem;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Result of an operation to detect text in a photo
 */
@ApiModel(description = "Result of an operation to detect text in a photo")
@JsonPropertyOrder({
  FineTextDetectionResult.JSON_PROPERTY_SUCCESSFUL,
  FineTextDetectionResult.JSON_PROPERTY_TEXT_ITEMS,
  FineTextDetectionResult.JSON_PROPERTY_TEXT_ITEMS_COUNT
})
@JsonTypeName("FineTextDetectionResult")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:16.765-08:00[America/Los_Angeles]")
public class FineTextDetectionResult {
  public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
  private Boolean successful;

  public static final String JSON_PROPERTY_TEXT_ITEMS = "TextItems";
  private List<FineTextItem> textItems = null;

  public static final String JSON_PROPERTY_TEXT_ITEMS_COUNT = "TextItemsCount";
  private Integer textItemsCount;


  public FineTextDetectionResult successful(Boolean successful) {
    
    this.successful = successful;
    return this;
  }

   /**
   * True if the operation was successful, false otherwise
   * @return successful
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the operation was successful, false otherwise")
  @JsonProperty(JSON_PROPERTY_SUCCESSFUL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSuccessful() {
    return successful;
  }


  public void setSuccessful(Boolean successful) {
    this.successful = successful;
  }


  public FineTextDetectionResult textItems(List<FineTextItem> textItems) {
    
    this.textItems = textItems;
    return this;
  }

  public FineTextDetectionResult addTextItemsItem(FineTextItem textItemsItem) {
    if (this.textItems == null) {
      this.textItems = new ArrayList<FineTextItem>();
    }
    this.textItems.add(textItemsItem);
    return this;
  }

   /**
   * Text items found in the input image
   * @return textItems
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Text items found in the input image")
  @JsonProperty(JSON_PROPERTY_TEXT_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<FineTextItem> getTextItems() {
    return textItems;
  }


  public void setTextItems(List<FineTextItem> textItems) {
    this.textItems = textItems;
  }


  public FineTextDetectionResult textItemsCount(Integer textItemsCount) {
    
    this.textItemsCount = textItemsCount;
    return this;
  }

   /**
   * Count of text items found in the input image
   * @return textItemsCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Count of text items found in the input image")
  @JsonProperty(JSON_PROPERTY_TEXT_ITEMS_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTextItemsCount() {
    return textItemsCount;
  }


  public void setTextItemsCount(Integer textItemsCount) {
    this.textItemsCount = textItemsCount;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FineTextDetectionResult fineTextDetectionResult = (FineTextDetectionResult) o;
    return Objects.equals(this.successful, fineTextDetectionResult.successful) &&
        Objects.equals(this.textItems, fineTextDetectionResult.textItems) &&
        Objects.equals(this.textItemsCount, fineTextDetectionResult.textItemsCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(successful, textItems, textItemsCount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FineTextDetectionResult {\n");
    sb.append("    successful: ").append(toIndentedString(successful)).append("\n");
    sb.append("    textItems: ").append(toIndentedString(textItems)).append("\n");
    sb.append("    textItemsCount: ").append(toIndentedString(textItemsCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

