/*
 * imageapi
 * Image Recognition and Processing APIs let you use Machine Learning to recognize and process images, and also perform useful image modification operations.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.cloudmersive.client.rt.model.ColorResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Result of performing a get dominant color operation
 */
@ApiModel(description = "Result of performing a get dominant color operation")
@JsonPropertyOrder({
  DominantColorResult.JSON_PROPERTY_SUCCESSFUL,
  DominantColorResult.JSON_PROPERTY_DOMINANT_COLORS
})
@JsonTypeName("DominantColorResult")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:16.765-08:00[America/Los_Angeles]")
public class DominantColorResult {
  public static final String JSON_PROPERTY_SUCCESSFUL = "Successful";
  private Boolean successful;

  public static final String JSON_PROPERTY_DOMINANT_COLORS = "DominantColors";
  private List<ColorResult> dominantColors = null;


  public DominantColorResult successful(Boolean successful) {
    
    this.successful = successful;
    return this;
  }

   /**
   * True if the operation was successful, false otherwise
   * @return successful
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the operation was successful, false otherwise")
  @JsonProperty(JSON_PROPERTY_SUCCESSFUL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSuccessful() {
    return successful;
  }


  public void setSuccessful(Boolean successful) {
    this.successful = successful;
  }


  public DominantColorResult dominantColors(List<ColorResult> dominantColors) {
    
    this.dominantColors = dominantColors;
    return this;
  }

  public DominantColorResult addDominantColorsItem(ColorResult dominantColorsItem) {
    if (this.dominantColors == null) {
      this.dominantColors = new ArrayList<ColorResult>();
    }
    this.dominantColors.add(dominantColorsItem);
    return this;
  }

   /**
   * Dominant colors in the image, in order where most dominant color is in the first index position (0), the second most-dominant color is in index position 1 and so on
   * @return dominantColors
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Dominant colors in the image, in order where most dominant color is in the first index position (0), the second most-dominant color is in index position 1 and so on")
  @JsonProperty(JSON_PROPERTY_DOMINANT_COLORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ColorResult> getDominantColors() {
    return dominantColors;
  }


  public void setDominantColors(List<ColorResult> dominantColors) {
    this.dominantColors = dominantColors;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DominantColorResult dominantColorResult = (DominantColorResult) o;
    return Objects.equals(this.successful, dominantColorResult.successful) &&
        Objects.equals(this.dominantColors, dominantColorResult.dominantColors);
  }

  @Override
  public int hashCode() {
    return Objects.hash(successful, dominantColors);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DominantColorResult {\n");
    sb.append("    successful: ").append(toIndentedString(successful)).append("\n");
    sb.append("    dominantColors: ").append(toIndentedString(dominantColors)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

