/*
 * convertapi
 * Convert API lets you effortlessly convert file formats and types.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.cloudmersive.client.rt.model.DocxTableCell;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * A row in a Word Document (DOCX) file
 */
@ApiModel(description = "A row in a Word Document (DOCX) file")
@JsonPropertyOrder({
  DocxTableRow.JSON_PROPERTY_ROW_INDEX,
  DocxTableRow.JSON_PROPERTY_PATH,
  DocxTableRow.JSON_PROPERTY_ROW_CELLS
})
@JsonTypeName("DocxTableRow")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:19.979-08:00[America/Los_Angeles]")
public class DocxTableRow {
  public static final String JSON_PROPERTY_ROW_INDEX = "RowIndex";
  private Integer rowIndex;

  public static final String JSON_PROPERTY_PATH = "Path";
  private String path;

  public static final String JSON_PROPERTY_ROW_CELLS = "RowCells";
  private List<DocxTableCell> rowCells = null;


  public DocxTableRow rowIndex(Integer rowIndex) {
    
    this.rowIndex = rowIndex;
    return this;
  }

   /**
   * Index of the row, 0-based
   * @return rowIndex
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Index of the row, 0-based")
  @JsonProperty(JSON_PROPERTY_ROW_INDEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRowIndex() {
    return rowIndex;
  }


  public void setRowIndex(Integer rowIndex) {
    this.rowIndex = rowIndex;
  }


  public DocxTableRow path(String path) {
    
    this.path = path;
    return this;
  }

   /**
   * The Path of the location of this table row object; leave blank for new tables
   * @return path
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The Path of the location of this table row object; leave blank for new tables")
  @JsonProperty(JSON_PROPERTY_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPath() {
    return path;
  }


  public void setPath(String path) {
    this.path = path;
  }


  public DocxTableRow rowCells(List<DocxTableCell> rowCells) {
    
    this.rowCells = rowCells;
    return this;
  }

  public DocxTableRow addRowCellsItem(DocxTableCell rowCellsItem) {
    if (this.rowCells == null) {
      this.rowCells = new ArrayList<DocxTableCell>();
    }
    this.rowCells.add(rowCellsItem);
    return this;
  }

   /**
   * Cells in the row; this is where the contents of the row is stored
   * @return rowCells
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Cells in the row; this is where the contents of the row is stored")
  @JsonProperty(JSON_PROPERTY_ROW_CELLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DocxTableCell> getRowCells() {
    return rowCells;
  }


  public void setRowCells(List<DocxTableCell> rowCells) {
    this.rowCells = rowCells;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DocxTableRow docxTableRow = (DocxTableRow) o;
    return Objects.equals(this.rowIndex, docxTableRow.rowIndex) &&
        Objects.equals(this.path, docxTableRow.path) &&
        Objects.equals(this.rowCells, docxTableRow.rowCells);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rowIndex, path, rowCells);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DocxTableRow {\n");
    sb.append("    rowIndex: ").append(toIndentedString(rowIndex)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    rowCells: ").append(toIndentedString(rowCells)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

