/*
 * convertapi
 * Convert API lets you effortlessly convert file formats and types.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.cloudmersive.client.rt.model.DocxParagraph;
import com.cloudmersive.client.rt.model.DocxSection;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Header of a Word Document (DOCX)
 */
@ApiModel(description = "Header of a Word Document (DOCX)")
@JsonPropertyOrder({
  DocxHeader.JSON_PROPERTY_PATH,
  DocxHeader.JSON_PROPERTY_PARAGRAPHS,
  DocxHeader.JSON_PROPERTY_SECTIONS_WITH_HEADER
})
@JsonTypeName("DocxHeader")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:19.979-08:00[America/Los_Angeles]")
public class DocxHeader {
  public static final String JSON_PROPERTY_PATH = "Path";
  private String path;

  public static final String JSON_PROPERTY_PARAGRAPHS = "Paragraphs";
  private List<DocxParagraph> paragraphs = null;

  public static final String JSON_PROPERTY_SECTIONS_WITH_HEADER = "SectionsWithHeader";
  private List<DocxSection> sectionsWithHeader = null;


  public DocxHeader path(String path) {
    
    this.path = path;
    return this;
  }

   /**
   * The Path of the location of this object; leave blank for new tables
   * @return path
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The Path of the location of this object; leave blank for new tables")
  @JsonProperty(JSON_PROPERTY_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPath() {
    return path;
  }


  public void setPath(String path) {
    this.path = path;
  }


  public DocxHeader paragraphs(List<DocxParagraph> paragraphs) {
    
    this.paragraphs = paragraphs;
    return this;
  }

  public DocxHeader addParagraphsItem(DocxParagraph paragraphsItem) {
    if (this.paragraphs == null) {
      this.paragraphs = new ArrayList<DocxParagraph>();
    }
    this.paragraphs.add(paragraphsItem);
    return this;
  }

   /**
   * Paragraphs in this header
   * @return paragraphs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Paragraphs in this header")
  @JsonProperty(JSON_PROPERTY_PARAGRAPHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DocxParagraph> getParagraphs() {
    return paragraphs;
  }


  public void setParagraphs(List<DocxParagraph> paragraphs) {
    this.paragraphs = paragraphs;
  }


  public DocxHeader sectionsWithHeader(List<DocxSection> sectionsWithHeader) {
    
    this.sectionsWithHeader = sectionsWithHeader;
    return this;
  }

  public DocxHeader addSectionsWithHeaderItem(DocxSection sectionsWithHeaderItem) {
    if (this.sectionsWithHeader == null) {
      this.sectionsWithHeader = new ArrayList<DocxSection>();
    }
    this.sectionsWithHeader.add(sectionsWithHeaderItem);
    return this;
  }

   /**
   * Sections that the header is applied to
   * @return sectionsWithHeader
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Sections that the header is applied to")
  @JsonProperty(JSON_PROPERTY_SECTIONS_WITH_HEADER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DocxSection> getSectionsWithHeader() {
    return sectionsWithHeader;
  }


  public void setSectionsWithHeader(List<DocxSection> sectionsWithHeader) {
    this.sectionsWithHeader = sectionsWithHeader;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DocxHeader docxHeader = (DocxHeader) o;
    return Objects.equals(this.path, docxHeader.path) &&
        Objects.equals(this.paragraphs, docxHeader.paragraphs) &&
        Objects.equals(this.sectionsWithHeader, docxHeader.sectionsWithHeader);
  }

  @Override
  public int hashCode() {
    return Objects.hash(path, paragraphs, sectionsWithHeader);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DocxHeader {\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    paragraphs: ").append(toIndentedString(paragraphs)).append("\n");
    sb.append("    sectionsWithHeader: ").append(toIndentedString(sectionsWithHeader)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

