/*
 * imageapi
 * Image Recognition and Processing APIs let you use Machine Learning to recognize and process images, and also perform useful image modification operations.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cloudmersive.client.rt.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Individual color
 */
@ApiModel(description = "Individual color")
@JsonPropertyOrder({
  ColorResult.JSON_PROPERTY_R,
  ColorResult.JSON_PROPERTY_G,
  ColorResult.JSON_PROPERTY_B
})
@JsonTypeName("ColorResult")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-14T13:47:16.765-08:00[America/Los_Angeles]")
public class ColorResult {
  public static final String JSON_PROPERTY_R = "R";
  private Integer R;

  public static final String JSON_PROPERTY_G = "G";
  private Integer G;

  public static final String JSON_PROPERTY_B = "B";
  private Integer B;


  public ColorResult R(Integer R) {
    
    this.R = R;
    return this;
  }

   /**
   * Red (R) channel pixel value of this color
   * @return R
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Red (R) channel pixel value of this color")
  @JsonProperty(JSON_PROPERTY_R)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getR() {
    return R;
  }


  public void setR(Integer R) {
    this.R = R;
  }


  public ColorResult G(Integer G) {
    
    this.G = G;
    return this;
  }

   /**
   * Green (G) channel pixel value of this color
   * @return G
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Green (G) channel pixel value of this color")
  @JsonProperty(JSON_PROPERTY_G)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getG() {
    return G;
  }


  public void setG(Integer G) {
    this.G = G;
  }


  public ColorResult B(Integer B) {
    
    this.B = B;
    return this;
  }

   /**
   * Blue (B) channel pixel value of this color
   * @return B
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Blue (B) channel pixel value of this color")
  @JsonProperty(JSON_PROPERTY_B)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getB() {
    return B;
  }


  public void setB(Integer B) {
    this.B = B;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ColorResult colorResult = (ColorResult) o;
    return Objects.equals(this.R, colorResult.R) &&
        Objects.equals(this.G, colorResult.G) &&
        Objects.equals(this.B, colorResult.B);
  }

  @Override
  public int hashCode() {
    return Objects.hash(R, G, B);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ColorResult {\n");
    sb.append("    R: ").append(toIndentedString(R)).append("\n");
    sb.append("    G: ").append(toIndentedString(G)).append("\n");
    sb.append("    B: ").append(toIndentedString(B)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

