/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v475.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.data.HeightMapDataType;
import com.nukkitx.protocol.bedrock.data.SubChunkData;
import com.nukkitx.protocol.bedrock.data.SubChunkRequestResult;
import com.nukkitx.protocol.bedrock.packet.SubChunkPacket;
import com.nukkitx.protocol.bedrock.v471.serializer.SubChunkSerializer_v471;
import io.netty.buffer.ByteBuf;

public class SubChunkSerializer_v475
extends SubChunkSerializer_v471 {
    public static final SubChunkSerializer_v475 INSTANCE = new SubChunkSerializer_v475();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, SubChunkPacket packet) {
        super.serialize(buffer, helper, packet);
        if (packet.isCacheEnabled()) {
            buffer.writeLongLE(((SubChunkData)packet.getSubChunks().get(0)).getBlobId());
        }
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, SubChunkPacket packet) {
        super.deserialize(buffer, helper, packet);
        if (packet.isCacheEnabled()) {
            ((SubChunkData)packet.getSubChunks().get(0)).setBlobId(buffer.readLongLE());
        }
    }

    protected void serializeSubChunk(ByteBuf buffer, BedrockPacketHelper helper, SubChunkPacket packet, SubChunkData subChunk) {
        helper.writeVector3i(buffer, subChunk.getPosition());
        helper.writeByteArray(buffer, subChunk.getData());
        VarInts.writeInt((ByteBuf)buffer, (int)subChunk.getResult().ordinal());
        buffer.writeByte(subChunk.getHeightMapType().ordinal());
        if (subChunk.getHeightMapType() == HeightMapDataType.HAS_DATA) {
            byte[] heightMapBuf = subChunk.getHeightMapData();
            buffer.writeBytes(heightMapBuf, 0, 256);
        }
    }

    protected SubChunkData deserializeSubChunk(ByteBuf buffer, BedrockPacketHelper helper, SubChunkPacket packet) {
        SubChunkData subChunk = new SubChunkData();
        subChunk.setPosition(helper.readVector3i(buffer));
        subChunk.setData(helper.readByteArray(buffer));
        subChunk.setResult(SubChunkRequestResult.values()[VarInts.readInt((ByteBuf)buffer)]);
        subChunk.setHeightMapType(HeightMapDataType.values()[buffer.readByte()]);
        if (subChunk.getHeightMapType() == HeightMapDataType.HAS_DATA) {
            byte[] heightMap = new byte[256];
            buffer.readBytes(heightMap);
            subChunk.setHeightMapData(heightMap);
        }
        return subChunk;
    }
}

