/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v407.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.data.inventory.CraftingData;
import com.nukkitx.protocol.bedrock.data.inventory.CraftingDataType;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.packet.CraftingDataPacket;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class CraftingDataSerializer_v407
implements BedrockPacketSerializer<CraftingDataPacket> {
    public static final CraftingDataSerializer_v407 INSTANCE = new CraftingDataSerializer_v407();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataPacket packet, BedrockSession session) {
        helper.writeArray(buffer, (Collection)packet.getCraftingData(), (buf, craftingData) -> {
            VarInts.writeInt((ByteBuf)buf, (int)craftingData.getType().ordinal());
            switch (craftingData.getType()) {
                case SHAPELESS: 
                case SHAPELESS_CHEMISTRY: 
                case SHULKER_BOX: {
                    this.writeShapelessRecipe((ByteBuf)buf, helper, (CraftingData)craftingData, session);
                    break;
                }
                case SHAPED: 
                case SHAPED_CHEMISTRY: {
                    this.writeShapedRecipe((ByteBuf)buf, helper, (CraftingData)craftingData, session);
                    break;
                }
                case FURNACE: {
                    this.writeFurnaceRecipe((ByteBuf)buf, helper, (CraftingData)craftingData, session);
                    break;
                }
                case FURNACE_DATA: {
                    this.writeFurnaceDataRecipe((ByteBuf)buf, helper, (CraftingData)craftingData, session);
                    break;
                }
                case MULTI: {
                    this.writeMultiRecipe((ByteBuf)buf, helper, (CraftingData)craftingData);
                }
            }
        });
        helper.writeArray(buffer, (Collection)packet.getPotionMixData(), (buf, data) -> helper.writePotionRecipe(buf, data));
        helper.writeArray(buffer, (Collection)packet.getContainerMixData(), (buf, data) -> helper.writeContainerChangeRecipe(buf, data));
        buffer.writeBoolean(packet.isCleanRecipes());
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataPacket packet, BedrockSession session) {
        helper.readArray(buffer, (Collection)packet.getCraftingData(), buf -> {
            int typeInt = VarInts.readInt((ByteBuf)buf);
            CraftingDataType type = CraftingDataType.byId((int)typeInt);
            switch (type) {
                case SHAPELESS: 
                case SHAPELESS_CHEMISTRY: 
                case SHULKER_BOX: {
                    return this.readShapelessRecipe((ByteBuf)buf, helper, type, session);
                }
                case SHAPED: 
                case SHAPED_CHEMISTRY: {
                    return this.readShapedRecipe((ByteBuf)buf, helper, type, session);
                }
                case FURNACE: {
                    return this.readFurnaceRecipe((ByteBuf)buf, helper, type, session);
                }
                case FURNACE_DATA: {
                    return this.readFurnaceDataRecipe((ByteBuf)buf, helper, type, session);
                }
                case MULTI: {
                    return this.readMultiRecipe((ByteBuf)buf, helper, type);
                }
            }
            throw new IllegalArgumentException("Unhandled crafting data type: " + type);
        });
        helper.readArray(buffer, (Collection)packet.getPotionMixData(), arg_0 -> ((BedrockPacketHelper)helper).readPotionRecipe(arg_0));
        helper.readArray(buffer, (Collection)packet.getContainerMixData(), arg_0 -> ((BedrockPacketHelper)helper).readContainerChangeRecipe(arg_0));
        packet.setCleanRecipes(buffer.readBoolean());
    }

    protected CraftingData readShapelessRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataType type, BedrockSession session) {
        String recipeId = helper.readString(buffer);
        ObjectArrayList inputs = new ObjectArrayList();
        helper.readArray(buffer, (Collection)inputs, arg_0 -> ((BedrockPacketHelper)helper).readRecipeIngredient(arg_0));
        ObjectArrayList outputs = new ObjectArrayList();
        helper.readArray(buffer, (Collection)outputs, buf -> helper.readItemInstance(buf, session));
        UUID uuid = helper.readUuid(buffer);
        String craftingTag = helper.readString(buffer);
        int priority = VarInts.readInt((ByteBuf)buffer);
        int networkId = VarInts.readUnsignedInt((ByteBuf)buffer);
        return new CraftingData(type, recipeId, -1, -1, -1, -1, (List)inputs, (List)outputs, uuid, craftingTag, priority, networkId);
    }

    protected void writeShapelessRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingData data, BedrockSession session) {
        helper.writeString(buffer, data.getRecipeId());
        helper.writeArray(buffer, (Collection)data.getInputs(), (arg_0, arg_1) -> ((BedrockPacketHelper)helper).writeRecipeIngredient(arg_0, arg_1));
        helper.writeArray(buffer, (Collection)data.getOutputs(), (buf, item) -> helper.writeItemInstance(buf, item, session));
        helper.writeUuid(buffer, data.getUuid());
        helper.writeString(buffer, data.getCraftingTag());
        VarInts.writeInt((ByteBuf)buffer, (int)data.getPriority());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)data.getNetworkId());
    }

    protected CraftingData readShapedRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataType type, BedrockSession session) {
        String recipeId = helper.readString(buffer);
        int width = VarInts.readInt((ByteBuf)buffer);
        int height = VarInts.readInt((ByteBuf)buffer);
        int inputCount = width * height;
        ObjectArrayList inputs = new ObjectArrayList(inputCount);
        for (int i = 0; i < inputCount; ++i) {
            inputs.add(helper.readRecipeIngredient(buffer));
        }
        ObjectArrayList outputs = new ObjectArrayList();
        helper.readArray(buffer, (Collection)outputs, buf -> helper.readItemInstance(buf, session));
        UUID uuid = helper.readUuid(buffer);
        String craftingTag = helper.readString(buffer);
        int priority = VarInts.readInt((ByteBuf)buffer);
        int networkId = VarInts.readUnsignedInt((ByteBuf)buffer);
        return new CraftingData(type, recipeId, width, height, -1, -1, (List)inputs, (List)outputs, uuid, craftingTag, priority, networkId);
    }

    protected void writeShapedRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingData data, BedrockSession session) {
        helper.writeString(buffer, data.getRecipeId());
        VarInts.writeInt((ByteBuf)buffer, (int)data.getWidth());
        VarInts.writeInt((ByteBuf)buffer, (int)data.getHeight());
        int count = data.getWidth() * data.getHeight();
        List inputs = data.getInputs();
        for (int i = 0; i < count; ++i) {
            helper.writeRecipeIngredient(buffer, (ItemData)inputs.get(i));
        }
        helper.writeArray(buffer, (Collection)data.getOutputs(), (buf, item) -> helper.writeItemInstance(buf, item, session));
        helper.writeUuid(buffer, data.getUuid());
        helper.writeString(buffer, data.getCraftingTag());
        VarInts.writeInt((ByteBuf)buffer, (int)data.getPriority());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)data.getNetworkId());
    }

    protected CraftingData readFurnaceRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataType type, BedrockSession session) {
        int inputId = VarInts.readInt((ByteBuf)buffer);
        ObjectArrayList output = new ObjectArrayList(Collections.singleton(helper.readItemInstance(buffer, session)));
        String craftingTag = helper.readString(buffer);
        return new CraftingData(type, -1, -1, inputId, -1, null, (List)output, null, craftingTag);
    }

    protected void writeFurnaceRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingData data, BedrockSession session) {
        VarInts.writeInt((ByteBuf)buffer, (int)data.getInputId());
        helper.writeItemInstance(buffer, (ItemData)data.getOutputs().get(0), session);
        helper.writeString(buffer, data.getCraftingTag());
    }

    protected CraftingData readFurnaceDataRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataType type, BedrockSession session) {
        int inputId = VarInts.readInt((ByteBuf)buffer);
        int inputDamage = VarInts.readInt((ByteBuf)buffer);
        ObjectArrayList output = new ObjectArrayList(Collections.singleton(helper.readItemInstance(buffer, session)));
        String craftingTag = helper.readString(buffer);
        return new CraftingData(type, -1, -1, inputId, inputDamage, null, (List)output, null, craftingTag);
    }

    protected void writeFurnaceDataRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingData data, BedrockSession session) {
        VarInts.writeInt((ByteBuf)buffer, (int)data.getInputId());
        VarInts.writeInt((ByteBuf)buffer, (int)data.getInputDamage());
        helper.writeItemInstance(buffer, (ItemData)data.getOutputs().get(0), session);
        helper.writeString(buffer, data.getCraftingTag());
    }

    protected CraftingData readMultiRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataType type) {
        UUID uuid = helper.readUuid(buffer);
        int networkId = VarInts.readUnsignedInt((ByteBuf)buffer);
        return CraftingData.fromMulti((UUID)uuid, (int)networkId);
    }

    protected void writeMultiRecipe(ByteBuf buffer, BedrockPacketHelper helper, CraftingData data) {
        helper.writeUuid(buffer, data.getUuid());
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)data.getNetworkId());
    }

    protected CraftingDataSerializer_v407() {
    }
}

