/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v390;

import com.nukkitx.protocol.bedrock.data.skin.AnimationData;
import com.nukkitx.protocol.bedrock.data.skin.ImageData;
import com.nukkitx.protocol.bedrock.data.skin.PersonaPieceData;
import com.nukkitx.protocol.bedrock.data.skin.PersonaPieceTintData;
import com.nukkitx.protocol.bedrock.data.skin.SerializedSkin;
import com.nukkitx.protocol.bedrock.v389.BedrockPacketHelper_v389;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;

public class BedrockPacketHelper_v390
extends BedrockPacketHelper_v389 {
    public static final BedrockPacketHelper_v390 INSTANCE = new BedrockPacketHelper_v390();

    public SerializedSkin readSkin(ByteBuf buffer) {
        String skinId = this.readString(buffer);
        String skinResourcePatch = this.readString(buffer);
        ImageData skinData = this.readImage(buffer);
        int animationCount = buffer.readIntLE();
        ObjectArrayList animations = new ObjectArrayList();
        for (int i = 0; i < animationCount; ++i) {
            animations.add(this.readAnimationData(buffer));
        }
        ImageData capeData = this.readImage(buffer);
        String geometryData = this.readString(buffer);
        String animationData = this.readString(buffer);
        boolean premium = buffer.readBoolean();
        boolean persona = buffer.readBoolean();
        boolean capeOnClassic = buffer.readBoolean();
        String capeId = this.readString(buffer);
        String fullSkinId = this.readString(buffer);
        String armSize = this.readString(buffer);
        String skinColor = this.readString(buffer);
        ObjectArrayList personaPieces = new ObjectArrayList();
        int piecesLength = buffer.readIntLE();
        for (int i = 0; i < piecesLength; ++i) {
            String pieceId = this.readString(buffer);
            String pieceType = this.readString(buffer);
            String packId = this.readString(buffer);
            boolean isDefault = buffer.readBoolean();
            String productId = this.readString(buffer);
            personaPieces.add(new PersonaPieceData(pieceId, pieceType, packId, isDefault, productId));
        }
        ObjectArrayList tintColors = new ObjectArrayList();
        int tintsLength = buffer.readIntLE();
        for (int i = 0; i < tintsLength; ++i) {
            String pieceType = this.readString(buffer);
            ObjectArrayList colors = new ObjectArrayList();
            int colorsLength = buffer.readIntLE();
            for (int i2 = 0; i2 < colorsLength; ++i2) {
                colors.add(this.readString(buffer));
            }
            tintColors.add(new PersonaPieceTintData(pieceType, (List)colors));
        }
        return SerializedSkin.of((String)skinId, (String)"", (String)skinResourcePatch, (ImageData)skinData, (List)animations, (ImageData)capeData, (String)geometryData, (String)animationData, (boolean)premium, (boolean)persona, (boolean)capeOnClassic, (String)capeId, (String)fullSkinId, (String)armSize, (String)skinColor, (List)personaPieces, (List)tintColors);
    }

    public void writeSkin(ByteBuf buffer, SerializedSkin skin) {
        Objects.requireNonNull(skin, "Skin is null");
        this.writeString(buffer, skin.getSkinId());
        this.writeString(buffer, skin.getSkinResourcePatch());
        this.writeImage(buffer, skin.getSkinData());
        List animations = skin.getAnimations();
        buffer.writeIntLE(animations.size());
        for (Object animation : animations) {
            this.writeAnimationData(buffer, (AnimationData)animation);
        }
        this.writeImage(buffer, skin.getCapeData());
        this.writeString(buffer, skin.getGeometryData());
        this.writeString(buffer, skin.getAnimationData());
        buffer.writeBoolean(skin.isPremium());
        buffer.writeBoolean(skin.isPersona());
        buffer.writeBoolean(skin.isCapeOnClassic());
        this.writeString(buffer, skin.getCapeId());
        this.writeString(buffer, skin.getFullSkinId());
        this.writeString(buffer, skin.getArmSize());
        this.writeString(buffer, skin.getSkinColor());
        List pieces = skin.getPersonaPieces();
        buffer.writeIntLE(pieces.size());
        for (PersonaPieceData piece : pieces) {
            this.writeString(buffer, piece.getId());
            this.writeString(buffer, piece.getType());
            this.writeString(buffer, piece.getPackId());
            buffer.writeBoolean(piece.isDefault());
            this.writeString(buffer, piece.getProductId());
        }
        List tints = skin.getTintColors();
        buffer.writeIntLE(tints.size());
        for (PersonaPieceTintData tint : tints) {
            this.writeString(buffer, tint.getType());
            List colors = tint.getColors();
            buffer.writeIntLE(colors.size());
            for (String color : colors) {
                this.writeString(buffer, color);
            }
        }
    }

    protected BedrockPacketHelper_v390() {
    }
}

