/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v361;

import com.nukkitx.math.vector.Vector3f;
import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.nbt.NbtMap;
import com.nukkitx.network.VarInts;
import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.data.LevelEventType;
import com.nukkitx.protocol.bedrock.data.ResourcePackType;
import com.nukkitx.protocol.bedrock.data.entity.EntityData;
import com.nukkitx.protocol.bedrock.data.entity.EntityDataMap;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlag;
import com.nukkitx.protocol.bedrock.data.entity.EntityFlags;
import com.nukkitx.protocol.bedrock.data.inventory.ItemData;
import com.nukkitx.protocol.bedrock.data.structure.StructureAnimationMode;
import com.nukkitx.protocol.bedrock.data.structure.StructureMirror;
import com.nukkitx.protocol.bedrock.data.structure.StructureRotation;
import com.nukkitx.protocol.bedrock.data.structure.StructureSettings;
import com.nukkitx.protocol.bedrock.v354.BedrockPacketHelper_v354;
import io.netty.buffer.ByteBuf;
import java.util.Map;

public class BedrockPacketHelper_v361
extends BedrockPacketHelper_v354 {
    public static final BedrockPacketHelper INSTANCE = new BedrockPacketHelper_v361();

    protected void registerEntityData() {
        super.registerEntityData();
        this.addEntityData(40, EntityData.NPC_DATA);
        this.addEntityData(103, EntityData.SKIN_ID);
        this.addEntityData(104, EntityData.SPAWNING_FRAMES);
        this.addEntityData(105, EntityData.COMMAND_BLOCK_TICK_DELAY);
        this.addEntityData(106, EntityData.COMMAND_BLOCK_EXECUTE_ON_FIRST_TICK);
    }

    protected void registerEntityFlags() {
        super.registerEntityFlags();
        this.addEntityFlag(87, EntityFlag.HIDDEN_WHEN_INVISIBLE);
    }

    protected void registerLevelEvents() {
        super.registerLevelEvents();
        this.addLevelEvent(2023, LevelEventType.PARTICLE_TELEPORT_TRAIL);
        int legacy = 16384;
        this.addLevelEvent(1 + legacy, LevelEventType.PARTICLE_BUBBLE);
        this.addLevelEvent(2 + legacy, LevelEventType.PARTICLE_BUBBLE_MANUAL);
        this.addLevelEvent(3 + legacy, LevelEventType.PARTICLE_CRITICAL);
        this.addLevelEvent(4 + legacy, LevelEventType.PARTICLE_BLOCK_FORCE_FIELD);
        this.addLevelEvent(5 + legacy, LevelEventType.PARTICLE_SMOKE);
        this.addLevelEvent(6 + legacy, LevelEventType.PARTICLE_EXPLODE);
        this.addLevelEvent(7 + legacy, LevelEventType.PARTICLE_EVAPORATION);
        this.addLevelEvent(8 + legacy, LevelEventType.PARTICLE_FLAME);
        this.addLevelEvent(9 + legacy, LevelEventType.PARTICLE_LAVA);
        this.addLevelEvent(10 + legacy, LevelEventType.PARTICLE_LARGE_SMOKE);
        this.addLevelEvent(11 + legacy, LevelEventType.PARTICLE_REDSTONE);
        this.addLevelEvent(12 + legacy, LevelEventType.PARTICLE_RISING_RED_DUST);
        this.addLevelEvent(13 + legacy, LevelEventType.PARTICLE_ITEM_BREAK);
        this.addLevelEvent(14 + legacy, LevelEventType.PARTICLE_SNOWBALL_POOF);
        this.addLevelEvent(15 + legacy, LevelEventType.PARTICLE_HUGE_EXPLODE);
        this.addLevelEvent(16 + legacy, LevelEventType.PARTICLE_HUGE_EXPLODE_SEED);
        this.addLevelEvent(17 + legacy, LevelEventType.PARTICLE_MOB_FLAME);
        this.addLevelEvent(18 + legacy, LevelEventType.PARTICLE_HEART);
        this.addLevelEvent(19 + legacy, LevelEventType.PARTICLE_TERRAIN);
        this.addLevelEvent(20 + legacy, LevelEventType.PARTICLE_TOWN_AURA);
        this.addLevelEvent(21 + legacy, LevelEventType.PARTICLE_PORTAL);
        this.addLevelEvent(22 + legacy, LevelEventType.PARTICLE_MOB_PORTAL);
        this.addLevelEvent(23 + legacy, LevelEventType.PARTICLE_SPLASH);
        this.addLevelEvent(24 + legacy, LevelEventType.PARTICLE_SPLASH_MANUAL);
        this.addLevelEvent(25 + legacy, LevelEventType.PARTICLE_WATER_WAKE);
        this.addLevelEvent(26 + legacy, LevelEventType.PARTICLE_DRIP_WATER);
        this.addLevelEvent(27 + legacy, LevelEventType.PARTICLE_DRIP_LAVA);
        this.addLevelEvent(28 + legacy, LevelEventType.PARTICLE_FALLING_DUST);
        this.addLevelEvent(29 + legacy, LevelEventType.PARTICLE_MOB_SPELL);
        this.addLevelEvent(30 + legacy, LevelEventType.PARTICLE_MOB_SPELL_AMBIENT);
        this.addLevelEvent(31 + legacy, LevelEventType.PARTICLE_MOB_SPELL_INSTANTANEOUS);
        this.addLevelEvent(32 + legacy, LevelEventType.PARTICLE_INK);
        this.addLevelEvent(33 + legacy, LevelEventType.PARTICLE_SLIME);
        this.addLevelEvent(34 + legacy, LevelEventType.PARTICLE_RAIN_SPLASH);
        this.addLevelEvent(35 + legacy, LevelEventType.PARTICLE_VILLAGER_ANGRY);
        this.addLevelEvent(36 + legacy, LevelEventType.PARTICLE_VILLAGER_HAPPY);
        this.addLevelEvent(37 + legacy, LevelEventType.PARTICLE_ENCHANTMENT_TABLE);
        this.addLevelEvent(38 + legacy, LevelEventType.PARTICLE_TRACKING_EMITTER);
        this.addLevelEvent(39 + legacy, LevelEventType.PARTICLE_NOTE);
        this.addLevelEvent(40 + legacy, LevelEventType.PARTICLE_WITCH_SPELL);
        this.addLevelEvent(41 + legacy, LevelEventType.PARTICLE_CARROT);
        this.addLevelEvent(42 + legacy, LevelEventType.PARTICLE_MOB_APPEARANCE);
        this.addLevelEvent(43 + legacy, LevelEventType.PARTICLE_END_ROD);
        this.addLevelEvent(44 + legacy, LevelEventType.PARTICLE_DRAGONS_BREATH);
        this.addLevelEvent(45 + legacy, LevelEventType.PARTICLE_SPIT);
        this.addLevelEvent(46 + legacy, LevelEventType.PARTICLE_TOTEM);
        this.addLevelEvent(47 + legacy, LevelEventType.PARTICLE_FOOD);
        this.addLevelEvent(48 + legacy, LevelEventType.PARTICLE_FIREWORKS_STARTER);
        this.addLevelEvent(49 + legacy, LevelEventType.PARTICLE_FIREWORKS_SPARK);
        this.addLevelEvent(50 + legacy, LevelEventType.PARTICLE_FIREWORKS_OVERLAY);
        this.addLevelEvent(51 + legacy, LevelEventType.PARTICLE_BALLOON_GAS);
        this.addLevelEvent(52 + legacy, LevelEventType.PARTICLE_COLORED_FLAME);
        this.addLevelEvent(53 + legacy, LevelEventType.PARTICLE_SPARKLER);
        this.addLevelEvent(54 + legacy, LevelEventType.PARTICLE_CONDUIT);
        this.addLevelEvent(55 + legacy, LevelEventType.PARTICLE_BUBBLE_COLUMN_UP);
        this.addLevelEvent(56 + legacy, LevelEventType.PARTICLE_BUBBLE_COLUMN_DOWN);
        this.addLevelEvent(57 + legacy, LevelEventType.PARTICLE_SNEEZE);
    }

    protected void registerResourcePackTypes() {
        this.addResourcePackType(0, ResourcePackType.INVALID);
        this.addResourcePackType(1, ResourcePackType.RESOURCE);
        this.addResourcePackType(2, ResourcePackType.BEHAVIOR);
        this.addResourcePackType(3, ResourcePackType.WORLD_TEMPLATE);
        this.addResourcePackType(4, ResourcePackType.ADDON);
        this.addResourcePackType(5, ResourcePackType.SKINS);
        this.addResourcePackType(6, ResourcePackType.CACHED);
        this.addResourcePackType(7, ResourcePackType.COPY_PROTECTED);
    }

    public void readEntityData(ByteBuf buffer, EntityDataMap entityDataMap) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)entityDataMap, (Object)"entityDataDictionary");
        int length = VarInts.readUnsignedInt((ByteBuf)buffer);
        block12: for (int i = 0; i < length; ++i) {
            Object object;
            int metadataInt = VarInts.readUnsignedInt((ByteBuf)buffer);
            EntityData entityData = (EntityData)this.entityData.get(metadataInt);
            int typeId = VarInts.readUnsignedInt((ByteBuf)buffer);
            EntityData.Type type = (EntityData.Type)this.entityDataTypes.get(typeId);
            if (entityData != null && entityData.isFlags()) {
                if (type != EntityData.Type.LONG) {
                    throw new IllegalArgumentException("Expected long value for flags, got " + type.name());
                }
                type = EntityData.Type.FLAGS;
            }
            if (type == null) {
                throw new IllegalArgumentException("Unknown EntityDataType: " + typeId);
            }
            switch (type) {
                case BYTE: {
                    object = buffer.readByte();
                    break;
                }
                case SHORT: {
                    object = buffer.readShortLE();
                    break;
                }
                case INT: {
                    object = VarInts.readInt((ByteBuf)buffer);
                    break;
                }
                case FLOAT: {
                    object = Float.valueOf(buffer.readFloatLE());
                    break;
                }
                case STRING: {
                    object = this.readString(buffer);
                    break;
                }
                case NBT: {
                    object = this.readTag(buffer);
                    break;
                }
                case VECTOR3I: {
                    object = this.readVector3i(buffer);
                    break;
                }
                case FLAGS: {
                    int index = entityData == EntityData.FLAGS_2 ? 1 : 0;
                    entityDataMap.getOrCreateFlags().set(VarInts.readLong((ByteBuf)buffer), index, this.entityFlags);
                    continue block12;
                }
                case LONG: {
                    object = VarInts.readLong((ByteBuf)buffer);
                    break;
                }
                case VECTOR3F: {
                    object = this.readVector3f(buffer);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown entity data type received");
                }
            }
            if (entityData != null) {
                entityDataMap.put(entityData, object);
                continue;
            }
            log.debug("Unknown entity data: {} type {} value {}", new Object[]{metadataInt, type, object});
        }
    }

    public void writeEntityData(ByteBuf buffer, EntityDataMap entityDataMap) {
        Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
        Preconditions.checkNotNull((Object)entityDataMap, (Object)"entityDataDictionary");
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)entityDataMap.size());
        block12: for (Map.Entry entry : entityDataMap.entrySet()) {
            int index = buffer.writerIndex();
            VarInts.writeUnsignedInt((ByteBuf)buffer, (int)this.entityData.get(entry.getKey()));
            Object object = entry.getValue();
            EntityData.Type type = EntityData.Type.from(object);
            VarInts.writeUnsignedInt((ByteBuf)buffer, (int)this.entityDataTypes.get((Object)type));
            switch (type) {
                case BYTE: {
                    buffer.writeByte((int)((Byte)object).byteValue());
                    continue block12;
                }
                case SHORT: {
                    buffer.writeShortLE((int)((Short)object).shortValue());
                    continue block12;
                }
                case INT: {
                    VarInts.writeInt((ByteBuf)buffer, (int)((Integer)object));
                    continue block12;
                }
                case FLOAT: {
                    buffer.writeFloatLE(((Float)object).floatValue());
                    continue block12;
                }
                case STRING: {
                    this.writeString(buffer, (String)object);
                    continue block12;
                }
                case NBT: {
                    NbtMap tag;
                    if (object instanceof NbtMap) {
                        tag = (NbtMap)object;
                    } else {
                        ItemData item = (ItemData)object;
                        tag = item.getTag();
                        if (tag == null) {
                            tag = NbtMap.EMPTY;
                        }
                    }
                    this.writeTag(buffer, tag);
                    continue block12;
                }
                case VECTOR3I: {
                    this.writeVector3i(buffer, (Vector3i)object);
                    continue block12;
                }
                case FLAGS: {
                    int flagsIndex = entry.getKey() == EntityData.FLAGS_2 ? 1 : 0;
                    object = ((EntityFlags)object).get(flagsIndex, this.entityFlags);
                }
                case LONG: {
                    VarInts.writeLong((ByteBuf)buffer, (long)((Long)object));
                    continue block12;
                }
                case VECTOR3F: {
                    this.writeVector3f(buffer, (Vector3f)object);
                    continue block12;
                }
            }
            buffer.writerIndex(index);
        }
    }

    public StructureSettings readStructureSettings(ByteBuf buffer) {
        String paletteName = this.readString(buffer);
        boolean ignoringEntities = buffer.readBoolean();
        boolean ignoringBlocks = buffer.readBoolean();
        Vector3i size = this.readBlockPosition(buffer);
        Vector3i offset = this.readBlockPosition(buffer);
        long lastEditedByEntityId = VarInts.readLong((ByteBuf)buffer);
        StructureRotation rotation = StructureRotation.from((int)buffer.readByte());
        StructureMirror mirror = StructureMirror.from((int)buffer.readByte());
        float integrityValue = buffer.readFloatLE();
        int integritySeed = buffer.readIntLE();
        return new StructureSettings(paletteName, ignoringEntities, ignoringBlocks, true, size, offset, lastEditedByEntityId, rotation, mirror, StructureAnimationMode.NONE, 0.0f, integrityValue, integritySeed, Vector3f.ZERO);
    }

    public void writeStructureSettings(ByteBuf buffer, StructureSettings settings) {
        this.writeString(buffer, settings.getPaletteName());
        buffer.writeBoolean(settings.isIgnoringBlocks());
        buffer.writeBoolean(settings.isIgnoringBlocks());
        this.writeBlockPosition(buffer, settings.getSize());
        this.writeBlockPosition(buffer, settings.getOffset());
        VarInts.writeLong((ByteBuf)buffer, (long)settings.getLastEditedByEntityId());
        buffer.writeByte(settings.getRotation().ordinal());
        buffer.writeByte(settings.getMirror().ordinal());
        buffer.writeFloatLE(settings.getIntegrityValue());
        buffer.writeIntLE(settings.getIntegritySeed());
    }

    protected BedrockPacketHelper_v361() {
    }
}

