/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.packet;

import com.nukkitx.math.vector.Vector3i;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketType;
import com.nukkitx.protocol.bedrock.data.HeightMapDataType;
import com.nukkitx.protocol.bedrock.data.SubChunkRequestResult;
import com.nukkitx.protocol.bedrock.handler.BedrockPacketHandler;
import java.util.Arrays;

public class SubChunkPacket
extends BedrockPacket {
    private int dimension;
    private Vector3i subChunkPosition;
    private byte[] data;
    private SubChunkRequestResult result;
    private HeightMapDataType heightMapType;
    private byte[] heightMapData;
    private boolean cacheEnabled;
    private long blobId;

    @Override
    public boolean handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.SUB_CHUNK;
    }

    public int getDimension() {
        return this.dimension;
    }

    public Vector3i getSubChunkPosition() {
        return this.subChunkPosition;
    }

    public byte[] getData() {
        return this.data;
    }

    public SubChunkRequestResult getResult() {
        return this.result;
    }

    public HeightMapDataType getHeightMapType() {
        return this.heightMapType;
    }

    public byte[] getHeightMapData() {
        return this.heightMapData;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public long getBlobId() {
        return this.blobId;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setSubChunkPosition(Vector3i subChunkPosition) {
        this.subChunkPosition = subChunkPosition;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setResult(SubChunkRequestResult result) {
        this.result = result;
    }

    public void setHeightMapType(HeightMapDataType heightMapType) {
        this.heightMapType = heightMapType;
    }

    public void setHeightMapData(byte[] heightMapData) {
        this.heightMapData = heightMapData;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public void setBlobId(long blobId) {
        this.blobId = blobId;
    }

    @Override
    public String toString() {
        return "SubChunkPacket(dimension=" + this.getDimension() + ", subChunkPosition=" + this.getSubChunkPosition() + ", data=" + Arrays.toString(this.getData()) + ", result=" + (Object)((Object)this.getResult()) + ", heightMapType=" + (Object)((Object)this.getHeightMapType()) + ", heightMapData=" + Arrays.toString(this.getHeightMapData()) + ", cacheEnabled=" + this.isCacheEnabled() + ", blobId=" + this.getBlobId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubChunkPacket)) {
            return false;
        }
        SubChunkPacket other = (SubChunkPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.dimension != other.dimension) {
            return false;
        }
        Vector3i this$subChunkPosition = this.subChunkPosition;
        Vector3i other$subChunkPosition = other.subChunkPosition;
        if (this$subChunkPosition == null ? other$subChunkPosition != null : !this$subChunkPosition.equals(other$subChunkPosition)) {
            return false;
        }
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        SubChunkRequestResult this$result = this.result;
        SubChunkRequestResult other$result = other.result;
        if (this$result == null ? other$result != null : !((Object)((Object)this$result)).equals((Object)other$result)) {
            return false;
        }
        HeightMapDataType this$heightMapType = this.heightMapType;
        HeightMapDataType other$heightMapType = other.heightMapType;
        if (this$heightMapType == null ? other$heightMapType != null : !((Object)((Object)this$heightMapType)).equals((Object)other$heightMapType)) {
            return false;
        }
        if (!Arrays.equals(this.heightMapData, other.heightMapData)) {
            return false;
        }
        if (this.cacheEnabled != other.cacheEnabled) {
            return false;
        }
        return this.blobId == other.blobId;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SubChunkPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.dimension;
        Vector3i $subChunkPosition = this.subChunkPosition;
        result = result * 59 + ($subChunkPosition == null ? 43 : $subChunkPosition.hashCode());
        result = result * 59 + Arrays.hashCode(this.data);
        SubChunkRequestResult $result = this.result;
        result = result * 59 + ($result == null ? 43 : ((Object)((Object)$result)).hashCode());
        HeightMapDataType $heightMapType = this.heightMapType;
        result = result * 59 + ($heightMapType == null ? 43 : ((Object)((Object)$heightMapType)).hashCode());
        result = result * 59 + Arrays.hashCode(this.heightMapData);
        result = result * 59 + (this.cacheEnabled ? 79 : 97);
        long $blobId = this.blobId;
        result = result * 59 + (int)($blobId >>> 32 ^ $blobId);
        return result;
    }
}

