/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock;

import com.nukkitx.network.util.Preconditions;
import com.nukkitx.protocol.bedrock.BedrockPacket;
import com.nukkitx.protocol.bedrock.BedrockPacketDefinition;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockPacketSerializer;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.exception.PacketSerializeException;
import com.nukkitx.protocol.bedrock.packet.UnknownPacket;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.lanternpowered.lmbda.LambdaFactory;
import org.lanternpowered.lmbda.MethodHandlesExtensions;

@Immutable
public final class BedrockPacketCodec {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(BedrockPacketCodec.class);
    private final int protocolVersion;
    private final String minecraftVersion;
    private final BedrockPacketDefinition<? extends BedrockPacket>[] packetsById;
    private final Map<Class<? extends BedrockPacket>, BedrockPacketDefinition<? extends BedrockPacket>> packetsByClass;
    private final BedrockPacketHelper helper;
    private final int raknetProtocolVersion;

    public static Builder builder() {
        return new Builder();
    }

    public BedrockPacket tryDecode(ByteBuf buf, int id, BedrockSession session) throws PacketSerializeException {
        UnknownPacket serializer;
        BedrockPacket packet;
        BedrockPacketDefinition<? extends BedrockPacket> definition = this.getPacketDefinition(id);
        if (definition == null) {
            UnknownPacket unknownPacket = new UnknownPacket();
            unknownPacket.setPacketId(id);
            packet = unknownPacket;
            serializer = unknownPacket;
        } else {
            packet = definition.getFactory().get();
            serializer = definition.getSerializer();
        }
        try {
            serializer.deserialize(buf, this.helper, packet, session);
        }
        catch (Exception e) {
            throw new PacketSerializeException("Error whilst deserializing " + packet, e);
        }
        if (log.isDebugEnabled() && buf.isReadable()) {
            log.debug(packet.getClass().getSimpleName() + " still has " + buf.readableBytes() + " bytes to read!");
        }
        return packet;
    }

    public void tryEncode(ByteBuf buf, BedrockPacket packet, BedrockSession session) throws PacketSerializeException {
        try {
            BedrockPacketSerializer<?> serializer;
            if (packet instanceof UnknownPacket) {
                serializer = (BedrockPacketSerializer<?>)((Object)packet);
            } else {
                BedrockPacketDefinition<?> definition = this.getPacketDefinition(packet.getClass());
                serializer = definition.getSerializer();
            }
            serializer.serialize(buf, this.helper, packet, session);
        }
        catch (Exception e) {
            throw new PacketSerializeException("Error whilst serializing " + packet, e);
        }
        finally {
            ReferenceCountUtil.release((Object)packet);
        }
    }

    public <T extends BedrockPacket> BedrockPacketDefinition<T> getPacketDefinition(Class<T> packet) {
        Preconditions.checkNotNull(packet, (Object)"packet");
        return this.packetsByClass.get(packet);
    }

    public BedrockPacketDefinition<? extends BedrockPacket> getPacketDefinition(int id) {
        if (id < this.packetsById.length) {
            return this.packetsById[id];
        }
        return null;
    }

    public int getId(BedrockPacket packet) {
        if (packet instanceof UnknownPacket) {
            return packet.getPacketId();
        }
        return this.getId(packet.getClass());
    }

    public int getId(Class<? extends BedrockPacket> clazz) {
        BedrockPacketDefinition<? extends BedrockPacket> definition = this.getPacketDefinition(clazz);
        if (definition == null) {
            throw new IllegalArgumentException("Packet ID for " + clazz.getName() + " does not exist.");
        }
        return definition.getId();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.packets.putAll(this.packetsByClass);
        builder.protocolVersion = this.protocolVersion;
        builder.raknetProtocolVersion = this.raknetProtocolVersion;
        builder.minecraftVersion = this.minecraftVersion;
        builder.helper = this.helper;
        return builder;
    }

    private BedrockPacketCodec(int protocolVersion, String minecraftVersion, BedrockPacketDefinition<? extends BedrockPacket>[] packetsById, Map<Class<? extends BedrockPacket>, BedrockPacketDefinition<? extends BedrockPacket>> packetsByClass, BedrockPacketHelper helper, int raknetProtocolVersion) {
        this.protocolVersion = protocolVersion;
        this.minecraftVersion = minecraftVersion;
        this.packetsById = packetsById;
        this.packetsByClass = packetsByClass;
        this.helper = helper;
        this.raknetProtocolVersion = raknetProtocolVersion;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public BedrockPacketHelper getHelper() {
        return this.helper;
    }

    public int getRaknetProtocolVersion() {
        return this.raknetProtocolVersion;
    }

    public static class Builder {
        private final Map<Class<? extends BedrockPacket>, BedrockPacketDefinition<? extends BedrockPacket>> packets = new IdentityHashMap<Class<? extends BedrockPacket>, BedrockPacketDefinition<? extends BedrockPacket>>();
        private int protocolVersion = -1;
        private int raknetProtocolVersion = 10;
        private String minecraftVersion = null;
        private BedrockPacketHelper helper = null;

        public <T extends BedrockPacket> Builder registerPacket(Class<T> packetClass, BedrockPacketSerializer<T> serializer, @Nonnegative int id) {
            Supplier factory;
            Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"id cannot be negative");
            Preconditions.checkArgument((!this.packets.containsKey(packetClass) ? 1 : 0) != 0, (Object)"Packet class already registered");
            try {
                MethodHandles.Lookup lookup = MethodHandlesExtensions.privateLookupIn(packetClass, (MethodHandles.Lookup)MethodHandles.lookup());
                MethodHandle handle = lookup.findConstructor(packetClass, MethodType.methodType(Void.TYPE));
                factory = LambdaFactory.createSupplier((MethodHandle)handle);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalArgumentException("Unable to find suitable constructor for packet factory", e);
            }
            BedrockPacketDefinition<T> info = new BedrockPacketDefinition<T>(id, factory, serializer);
            this.packets.put(packetClass, info);
            return this;
        }

        public void deregisterPacket(Class<? extends BedrockPacket> packetClass) {
            Preconditions.checkNotNull(packetClass, (Object)"packetClass");
            BedrockPacketDefinition<? extends BedrockPacket> info = this.packets.remove(packetClass);
        }

        public Builder protocolVersion(@Nonnegative int protocolVersion) {
            Preconditions.checkArgument((protocolVersion >= 0 ? 1 : 0) != 0, (Object)"protocolVersion cannot be negative");
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder raknetProtocolVersion(@Nonnegative int version) {
            Preconditions.checkArgument((version >= 0 ? 1 : 0) != 0, (Object)"raknetProtocolVersion cannot be negative");
            this.raknetProtocolVersion = version;
            return this;
        }

        public Builder minecraftVersion(@Nonnull String minecraftVersion) {
            Preconditions.checkNotNull((Object)minecraftVersion, (Object)"minecraftVersion");
            Preconditions.checkArgument((!minecraftVersion.isEmpty() && minecraftVersion.split("\\.").length > 2 ? 1 : 0) != 0, (Object)"Invalid minecraftVersion");
            this.minecraftVersion = minecraftVersion;
            return this;
        }

        public Builder helper(@Nonnull BedrockPacketHelper helper) {
            Preconditions.checkNotNull((Object)helper, (Object)"helper");
            this.helper = helper;
            return this;
        }

        public BedrockPacketCodec build() {
            Preconditions.checkArgument((this.protocolVersion >= 0 ? 1 : 0) != 0, (Object)"No protocol version defined");
            Preconditions.checkNotNull((Object)this.minecraftVersion, (Object)"No Minecraft version defined");
            Preconditions.checkNotNull((Object)this.helper, (Object)"helper cannot be null");
            int largestId = -1;
            for (BedrockPacketDefinition<? extends BedrockPacket> info : this.packets.values()) {
                if (info.getId() <= largestId) continue;
                largestId = info.getId();
            }
            Preconditions.checkArgument((largestId > -1 ? 1 : 0) != 0, (Object)"Must have at least one packet registered");
            BedrockPacketDefinition[] packetsById = new BedrockPacketDefinition[largestId + 1];
            Iterator<BedrockPacketDefinition<? extends BedrockPacket>> iterator = this.packets.values().iterator();
            while (iterator.hasNext()) {
                BedrockPacketDefinition<? extends BedrockPacket> info;
                packetsById[info.getId()] = info = iterator.next();
            }
            return new BedrockPacketCodec(this.protocolVersion, this.minecraftVersion, packetsById, this.packets, this.helper, this.raknetProtocolVersion);
        }

        private Builder() {
        }
    }
}

