/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import com.chuckerteam.chucker.internal.data.entity.HttpHeader;
import com.chuckerteam.chucker.internal.support.JsonConverter;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/chuckerteam/chucker/internal/support/FormatUtils;", "", "<init>", "()V", "SI_MULTIPLE", "", "BASE_TWO_MULTIPLE", "formatHeaders", "", "httpHeaders", "", "Lcom/chuckerteam/chucker/internal/data/entity/HttpHeader;", "withMarkup", "", "formatByteCount", "bytes", "", "si", "formatJson", "json", "formatXml", "xml", "formatUrlEncodedForm", "form", "com.github.ChuckerTeam.Chucker.library"})
public final class FormatUtils {
    @NotNull
    public static final FormatUtils INSTANCE = new FormatUtils();
    private static final int SI_MULTIPLE = 1000;
    private static final int BASE_TWO_MULTIPLE = 1024;

    private FormatUtils() {
    }

    @NotNull
    public final String formatHeaders(@Nullable List<HttpHeader> httpHeaders, boolean withMarkup) {
        List<HttpHeader> list = httpHeaders;
        if (list == null || (list = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, arg_0 -> FormatUtils.formatHeaders$lambda$0(withMarkup, arg_0), (int)30, null)) == null) {
            list = "";
        }
        return list;
    }

    @NotNull
    public final String formatByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char c = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1);
        Object object = si ? "" : "i";
        String pre = c + (String)object;
        object = Locale.US;
        String string2 = "%.1f %sB";
        Object[] objectArray = new Object[]{(double)bytes / Math.pow(unit, exp), pre};
        String string3 = String.format((Locale)object, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    @NotNull
    public final String formatJson(@NotNull String json) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            JsonElement je = JsonParser.parseString((String)json);
            string2 = JsonConverter.INSTANCE.getInstance().toJson(je);
            Intrinsics.checkNotNull((Object)string2);
        }
        catch (JsonParseException e) {
            string2 = json;
        }
        return string2;
    }

    @NotNull
    public final String formatXml(@NotNull String xml) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Intrinsics.checkNotNullExpressionValue((Object)documentBuilderFactory, (String)"newInstance(...)");
            DocumentBuilderFactory documentFactory = documentBuilderFactory;
            documentFactory.setExpandEntityReferences(false);
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)documentBuilder, (String)"newDocumentBuilder(...)");
            DocumentBuilder documentBuilder2 = documentBuilder;
            String string3 = xml;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            InputSource inputSource = new InputSource(new ByteArrayInputStream(byArray));
            Document document = documentBuilder2.parse(inputSource);
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
            Document document2 = document;
            DOMSource domSource = new DOMSource(document2);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Object object = TransformerFactory.newInstance();
            TransformerFactory $this$formatXml_u24lambda_u241 = object;
            boolean bl = false;
            $this$formatXml_u24lambda_u241.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Object $this$formatXml_u24lambda_u242 = object = ((TransformerFactory)object).newTransformer();
            boolean bl2 = false;
            ((Transformer)$this$formatXml_u24lambda_u242).setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            ((Transformer)$this$formatXml_u24lambda_u242).setOutputProperty("indent", "yes");
            ((Transformer)$this$formatXml_u24lambda_u242).transform(domSource, result);
            string2 = writer.toString();
            Intrinsics.checkNotNull((Object)string2);
        }
        catch (SAXParseException ignore) {
            string2 = xml;
        }
        catch (IOException ignore) {
            string2 = xml;
        }
        catch (TransformerException ignore) {
            string2 = xml;
        }
        return string2;
    }

    @NotNull
    public final String formatUrlEncodedForm(@NotNull String form) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        try {
            if (StringsKt.isBlank((CharSequence)((CharSequence)form))) {
                return form;
            }
            object = new String[]{"&"};
            object = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)((CharSequence)form), (String[])object, (boolean)false, (int)0, (int)6, null), (CharSequence)"\n", null, null, (int)0, null, FormatUtils::formatUrlEncodedForm$lambda$3, (int)30, null);
        }
        catch (IllegalArgumentException ignore) {
            object = form;
        }
        catch (UnsupportedEncodingException ignore) {
            object = form;
        }
        return object;
    }

    private static final CharSequence formatHeaders$lambda$0(boolean $withMarkup, HttpHeader header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        return $withMarkup ? (CharSequence)("<b> " + header.getName() + ": </b>" + header.getValue() + " <br />") : (CharSequence)(header.getName() + ": " + header.getValue() + "\n");
    }

    private static final CharSequence formatUrlEncodedForm$lambda$3(String entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        String[] stringArray = new String[]{"="};
        List keyValue = StringsKt.split$default((CharSequence)entry, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String key = (String)keyValue.get(0);
        String value = keyValue.size() > 1 ? URLDecoder.decode((String)keyValue.get(1), "UTF-8") : "";
        return key + ": " + value;
    }
}

