/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import com.chuckerteam.chucker.internal.support.Logger;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/chuckerteam/chucker/internal/support/DepletingSource;", "Lokio/ForwardingSource;", "delegate", "Lokio/Source;", "<init>", "(Lokio/Source;)V", "shouldDeplete", "", "read", "", "sink", "Lokio/Buffer;", "byteCount", "close", "", "com.github.ChuckerTeam.Chucker.library"})
public final class DepletingSource
extends ForwardingSource {
    private boolean shouldDeplete;

    public DepletingSource(@NotNull Source delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        super(delegate);
        this.shouldDeplete = true;
    }

    public long read(@NotNull Buffer sink, long byteCount) {
        long l;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        try {
            long bytesRead = super.read(sink, byteCount);
            if (bytesRead == -1L) {
                this.shouldDeplete = false;
            }
            l = bytesRead;
        }
        catch (IOException e) {
            this.shouldDeplete = false;
            throw e;
        }
        return l;
    }

    public void close() {
        if (this.shouldDeplete) {
            try {
                Okio.buffer((Source)this.delegate()).readAll(Okio.blackhole());
            }
            catch (IOException e) {
                Logger.Companion.error("An error occurred while depleting the source", e);
            }
        }
        this.shouldDeplete = false;
        super.close();
    }
}

