package com.chuckerteam.chucker.internal.data.room;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.entity.HttpTransactionTuple;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class HttpTransactionDao_Impl implements HttpTransactionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<HttpTransaction> __insertionAdapterOfHttpTransaction;

  private final EntityDeletionOrUpdateAdapter<HttpTransaction> __updateAdapterOfHttpTransaction;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  private final SharedSQLiteStatement __preparedStmtOfDeleteBefore;

  public HttpTransactionDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfHttpTransaction = new EntityInsertionAdapter<HttpTransaction>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `transactions` (`id`,`requestDate`,`responseDate`,`tookMs`,`protocol`,`method`,`url`,`host`,`path`,`scheme`,`responseTlsVersion`,`responseCipherSuite`,`requestPayloadSize`,`requestContentType`,`requestHeaders`,`requestHeadersSize`,`requestBody`,`isRequestBodyEncoded`,`responseCode`,`responseMessage`,`error`,`responsePayloadSize`,`responseContentType`,`responseHeaders`,`responseHeadersSize`,`responseBody`,`isResponseBodyEncoded`,`responseImageData`,`graphQlDetected`,`graphQlOperationName`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final HttpTransaction entity) {
        statement.bindLong(1, entity.getId());
        if (entity.getRequestDate() == null) {
          statement.bindNull(2);
        } else {
          statement.bindLong(2, entity.getRequestDate());
        }
        if (entity.getResponseDate() == null) {
          statement.bindNull(3);
        } else {
          statement.bindLong(3, entity.getResponseDate());
        }
        if (entity.getTookMs() == null) {
          statement.bindNull(4);
        } else {
          statement.bindLong(4, entity.getTookMs());
        }
        if (entity.getProtocol() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getProtocol());
        }
        if (entity.getMethod() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getMethod());
        }
        if (entity.getUrl() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getUrl());
        }
        if (entity.getHost() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getHost());
        }
        if (entity.getPath() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getPath());
        }
        if (entity.getScheme() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getScheme());
        }
        if (entity.getResponseTlsVersion() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getResponseTlsVersion());
        }
        if (entity.getResponseCipherSuite() == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, entity.getResponseCipherSuite());
        }
        if (entity.getRequestPayloadSize() == null) {
          statement.bindNull(13);
        } else {
          statement.bindLong(13, entity.getRequestPayloadSize());
        }
        if (entity.getRequestContentType() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getRequestContentType());
        }
        if (entity.getRequestHeaders() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getRequestHeaders());
        }
        if (entity.getRequestHeadersSize() == null) {
          statement.bindNull(16);
        } else {
          statement.bindLong(16, entity.getRequestHeadersSize());
        }
        if (entity.getRequestBody() == null) {
          statement.bindNull(17);
        } else {
          statement.bindString(17, entity.getRequestBody());
        }
        final int _tmp = entity.isRequestBodyEncoded() ? 1 : 0;
        statement.bindLong(18, _tmp);
        if (entity.getResponseCode() == null) {
          statement.bindNull(19);
        } else {
          statement.bindLong(19, entity.getResponseCode());
        }
        if (entity.getResponseMessage() == null) {
          statement.bindNull(20);
        } else {
          statement.bindString(20, entity.getResponseMessage());
        }
        if (entity.getError() == null) {
          statement.bindNull(21);
        } else {
          statement.bindString(21, entity.getError());
        }
        if (entity.getResponsePayloadSize() == null) {
          statement.bindNull(22);
        } else {
          statement.bindLong(22, entity.getResponsePayloadSize());
        }
        if (entity.getResponseContentType() == null) {
          statement.bindNull(23);
        } else {
          statement.bindString(23, entity.getResponseContentType());
        }
        if (entity.getResponseHeaders() == null) {
          statement.bindNull(24);
        } else {
          statement.bindString(24, entity.getResponseHeaders());
        }
        if (entity.getResponseHeadersSize() == null) {
          statement.bindNull(25);
        } else {
          statement.bindLong(25, entity.getResponseHeadersSize());
        }
        if (entity.getResponseBody() == null) {
          statement.bindNull(26);
        } else {
          statement.bindString(26, entity.getResponseBody());
        }
        final int _tmp_1 = entity.isResponseBodyEncoded() ? 1 : 0;
        statement.bindLong(27, _tmp_1);
        if (entity.getResponseImageData() == null) {
          statement.bindNull(28);
        } else {
          statement.bindBlob(28, entity.getResponseImageData());
        }
        final int _tmp_2 = entity.getGraphQlDetected() ? 1 : 0;
        statement.bindLong(29, _tmp_2);
        if (entity.getGraphQlOperationName() == null) {
          statement.bindNull(30);
        } else {
          statement.bindString(30, entity.getGraphQlOperationName());
        }
      }
    };
    this.__updateAdapterOfHttpTransaction = new EntityDeletionOrUpdateAdapter<HttpTransaction>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR REPLACE `transactions` SET `id` = ?,`requestDate` = ?,`responseDate` = ?,`tookMs` = ?,`protocol` = ?,`method` = ?,`url` = ?,`host` = ?,`path` = ?,`scheme` = ?,`responseTlsVersion` = ?,`responseCipherSuite` = ?,`requestPayloadSize` = ?,`requestContentType` = ?,`requestHeaders` = ?,`requestHeadersSize` = ?,`requestBody` = ?,`isRequestBodyEncoded` = ?,`responseCode` = ?,`responseMessage` = ?,`error` = ?,`responsePayloadSize` = ?,`responseContentType` = ?,`responseHeaders` = ?,`responseHeadersSize` = ?,`responseBody` = ?,`isResponseBodyEncoded` = ?,`responseImageData` = ?,`graphQlDetected` = ?,`graphQlOperationName` = ? WHERE `id` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final HttpTransaction entity) {
        statement.bindLong(1, entity.getId());
        if (entity.getRequestDate() == null) {
          statement.bindNull(2);
        } else {
          statement.bindLong(2, entity.getRequestDate());
        }
        if (entity.getResponseDate() == null) {
          statement.bindNull(3);
        } else {
          statement.bindLong(3, entity.getResponseDate());
        }
        if (entity.getTookMs() == null) {
          statement.bindNull(4);
        } else {
          statement.bindLong(4, entity.getTookMs());
        }
        if (entity.getProtocol() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getProtocol());
        }
        if (entity.getMethod() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getMethod());
        }
        if (entity.getUrl() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getUrl());
        }
        if (entity.getHost() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getHost());
        }
        if (entity.getPath() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getPath());
        }
        if (entity.getScheme() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getScheme());
        }
        if (entity.getResponseTlsVersion() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getResponseTlsVersion());
        }
        if (entity.getResponseCipherSuite() == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, entity.getResponseCipherSuite());
        }
        if (entity.getRequestPayloadSize() == null) {
          statement.bindNull(13);
        } else {
          statement.bindLong(13, entity.getRequestPayloadSize());
        }
        if (entity.getRequestContentType() == null) {
          statement.bindNull(14);
        } else {
          statement.bindString(14, entity.getRequestContentType());
        }
        if (entity.getRequestHeaders() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getRequestHeaders());
        }
        if (entity.getRequestHeadersSize() == null) {
          statement.bindNull(16);
        } else {
          statement.bindLong(16, entity.getRequestHeadersSize());
        }
        if (entity.getRequestBody() == null) {
          statement.bindNull(17);
        } else {
          statement.bindString(17, entity.getRequestBody());
        }
        final int _tmp = entity.isRequestBodyEncoded() ? 1 : 0;
        statement.bindLong(18, _tmp);
        if (entity.getResponseCode() == null) {
          statement.bindNull(19);
        } else {
          statement.bindLong(19, entity.getResponseCode());
        }
        if (entity.getResponseMessage() == null) {
          statement.bindNull(20);
        } else {
          statement.bindString(20, entity.getResponseMessage());
        }
        if (entity.getError() == null) {
          statement.bindNull(21);
        } else {
          statement.bindString(21, entity.getError());
        }
        if (entity.getResponsePayloadSize() == null) {
          statement.bindNull(22);
        } else {
          statement.bindLong(22, entity.getResponsePayloadSize());
        }
        if (entity.getResponseContentType() == null) {
          statement.bindNull(23);
        } else {
          statement.bindString(23, entity.getResponseContentType());
        }
        if (entity.getResponseHeaders() == null) {
          statement.bindNull(24);
        } else {
          statement.bindString(24, entity.getResponseHeaders());
        }
        if (entity.getResponseHeadersSize() == null) {
          statement.bindNull(25);
        } else {
          statement.bindLong(25, entity.getResponseHeadersSize());
        }
        if (entity.getResponseBody() == null) {
          statement.bindNull(26);
        } else {
          statement.bindString(26, entity.getResponseBody());
        }
        final int _tmp_1 = entity.isResponseBodyEncoded() ? 1 : 0;
        statement.bindLong(27, _tmp_1);
        if (entity.getResponseImageData() == null) {
          statement.bindNull(28);
        } else {
          statement.bindBlob(28, entity.getResponseImageData());
        }
        final int _tmp_2 = entity.getGraphQlDetected() ? 1 : 0;
        statement.bindLong(29, _tmp_2);
        if (entity.getGraphQlOperationName() == null) {
          statement.bindNull(30);
        } else {
          statement.bindString(30, entity.getGraphQlOperationName());
        }
        statement.bindLong(31, entity.getId());
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM transactions";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteBefore = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM transactions WHERE requestDate <= ?";
        return _query;
      }
    };
  }

  @Override
  public Object insert(final HttpTransaction transaction,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @Nullable
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfHttpTransaction.insertAndReturnId(transaction);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object update(final HttpTransaction transaction,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfHttpTransaction.handle(transaction);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object deleteAll(final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        try {
          __db.beginTransaction();
          try {
            final Integer _result = _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object deleteBefore(final long threshold,
      final Continuation<? super Integer> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteBefore.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, threshold);
        try {
          __db.beginTransaction();
          try {
            final Integer _result = _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteBefore.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public LiveData<List<HttpTransactionTuple>> getSortedTuples() {
    final String _sql = "SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestPayloadSize, responsePayloadSize, error, graphQLDetected, graphQlOperationName FROM transactions ORDER BY requestDate DESC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[] {"transactions"}, false, new Callable<List<HttpTransactionTuple>>() {
      @Override
      @Nullable
      public List<HttpTransactionTuple> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = 0;
          final int _cursorIndexOfRequestDate = 1;
          final int _cursorIndexOfTookMs = 2;
          final int _cursorIndexOfProtocol = 3;
          final int _cursorIndexOfMethod = 4;
          final int _cursorIndexOfHost = 5;
          final int _cursorIndexOfPath = 6;
          final int _cursorIndexOfScheme = 7;
          final int _cursorIndexOfResponseCode = 8;
          final int _cursorIndexOfRequestPayloadSize = 9;
          final int _cursorIndexOfResponsePayloadSize = 10;
          final int _cursorIndexOfError = 11;
          final int _cursorIndexOfGraphQlDetected = 12;
          final int _cursorIndexOfGraphQlOperationName = 13;
          final List<HttpTransactionTuple> _result = new ArrayList<HttpTransactionTuple>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final HttpTransactionTuple _item;
            final long _tmpId;
            _tmpId = _cursor.getLong(_cursorIndexOfId);
            final Long _tmpRequestDate;
            if (_cursor.isNull(_cursorIndexOfRequestDate)) {
              _tmpRequestDate = null;
            } else {
              _tmpRequestDate = _cursor.getLong(_cursorIndexOfRequestDate);
            }
            final Long _tmpTookMs;
            if (_cursor.isNull(_cursorIndexOfTookMs)) {
              _tmpTookMs = null;
            } else {
              _tmpTookMs = _cursor.getLong(_cursorIndexOfTookMs);
            }
            final String _tmpProtocol;
            if (_cursor.isNull(_cursorIndexOfProtocol)) {
              _tmpProtocol = null;
            } else {
              _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
            }
            final String _tmpMethod;
            if (_cursor.isNull(_cursorIndexOfMethod)) {
              _tmpMethod = null;
            } else {
              _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
            }
            final String _tmpHost;
            if (_cursor.isNull(_cursorIndexOfHost)) {
              _tmpHost = null;
            } else {
              _tmpHost = _cursor.getString(_cursorIndexOfHost);
            }
            final String _tmpPath;
            if (_cursor.isNull(_cursorIndexOfPath)) {
              _tmpPath = null;
            } else {
              _tmpPath = _cursor.getString(_cursorIndexOfPath);
            }
            final String _tmpScheme;
            if (_cursor.isNull(_cursorIndexOfScheme)) {
              _tmpScheme = null;
            } else {
              _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
            }
            final Integer _tmpResponseCode;
            if (_cursor.isNull(_cursorIndexOfResponseCode)) {
              _tmpResponseCode = null;
            } else {
              _tmpResponseCode = _cursor.getInt(_cursorIndexOfResponseCode);
            }
            final Long _tmpRequestPayloadSize;
            if (_cursor.isNull(_cursorIndexOfRequestPayloadSize)) {
              _tmpRequestPayloadSize = null;
            } else {
              _tmpRequestPayloadSize = _cursor.getLong(_cursorIndexOfRequestPayloadSize);
            }
            final Long _tmpResponsePayloadSize;
            if (_cursor.isNull(_cursorIndexOfResponsePayloadSize)) {
              _tmpResponsePayloadSize = null;
            } else {
              _tmpResponsePayloadSize = _cursor.getLong(_cursorIndexOfResponsePayloadSize);
            }
            final String _tmpError;
            if (_cursor.isNull(_cursorIndexOfError)) {
              _tmpError = null;
            } else {
              _tmpError = _cursor.getString(_cursorIndexOfError);
            }
            final boolean _tmpGraphQlDetected;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfGraphQlDetected);
            _tmpGraphQlDetected = _tmp != 0;
            final String _tmpGraphQlOperationName;
            if (_cursor.isNull(_cursorIndexOfGraphQlOperationName)) {
              _tmpGraphQlOperationName = null;
            } else {
              _tmpGraphQlOperationName = _cursor.getString(_cursorIndexOfGraphQlOperationName);
            }
            _item = new HttpTransactionTuple(_tmpId,_tmpRequestDate,_tmpTookMs,_tmpProtocol,_tmpMethod,_tmpHost,_tmpPath,_tmpScheme,_tmpResponseCode,_tmpRequestPayloadSize,_tmpResponsePayloadSize,_tmpError,_tmpGraphQlDetected,_tmpGraphQlOperationName);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public LiveData<List<HttpTransactionTuple>> getFilteredTuples(final String codeQuery,
      final String pathQuery, final String graphQlQuery) {
    final String _sql = "SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestPayloadSize, responsePayloadSize, error, graphQLDetected, graphQlOperationName FROM transactions WHERE responseCode LIKE ? AND (path LIKE ? OR graphQlOperationName LIKE ?) ORDER BY requestDate DESC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindString(_argIndex, codeQuery);
    _argIndex = 2;
    _statement.bindString(_argIndex, pathQuery);
    _argIndex = 3;
    _statement.bindString(_argIndex, graphQlQuery);
    return __db.getInvalidationTracker().createLiveData(new String[] {"transactions"}, false, new Callable<List<HttpTransactionTuple>>() {
      @Override
      @Nullable
      public List<HttpTransactionTuple> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = 0;
          final int _cursorIndexOfRequestDate = 1;
          final int _cursorIndexOfTookMs = 2;
          final int _cursorIndexOfProtocol = 3;
          final int _cursorIndexOfMethod = 4;
          final int _cursorIndexOfHost = 5;
          final int _cursorIndexOfPath = 6;
          final int _cursorIndexOfScheme = 7;
          final int _cursorIndexOfResponseCode = 8;
          final int _cursorIndexOfRequestPayloadSize = 9;
          final int _cursorIndexOfResponsePayloadSize = 10;
          final int _cursorIndexOfError = 11;
          final int _cursorIndexOfGraphQlDetected = 12;
          final int _cursorIndexOfGraphQlOperationName = 13;
          final List<HttpTransactionTuple> _result = new ArrayList<HttpTransactionTuple>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final HttpTransactionTuple _item;
            final long _tmpId;
            _tmpId = _cursor.getLong(_cursorIndexOfId);
            final Long _tmpRequestDate;
            if (_cursor.isNull(_cursorIndexOfRequestDate)) {
              _tmpRequestDate = null;
            } else {
              _tmpRequestDate = _cursor.getLong(_cursorIndexOfRequestDate);
            }
            final Long _tmpTookMs;
            if (_cursor.isNull(_cursorIndexOfTookMs)) {
              _tmpTookMs = null;
            } else {
              _tmpTookMs = _cursor.getLong(_cursorIndexOfTookMs);
            }
            final String _tmpProtocol;
            if (_cursor.isNull(_cursorIndexOfProtocol)) {
              _tmpProtocol = null;
            } else {
              _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
            }
            final String _tmpMethod;
            if (_cursor.isNull(_cursorIndexOfMethod)) {
              _tmpMethod = null;
            } else {
              _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
            }
            final String _tmpHost;
            if (_cursor.isNull(_cursorIndexOfHost)) {
              _tmpHost = null;
            } else {
              _tmpHost = _cursor.getString(_cursorIndexOfHost);
            }
            final String _tmpPath;
            if (_cursor.isNull(_cursorIndexOfPath)) {
              _tmpPath = null;
            } else {
              _tmpPath = _cursor.getString(_cursorIndexOfPath);
            }
            final String _tmpScheme;
            if (_cursor.isNull(_cursorIndexOfScheme)) {
              _tmpScheme = null;
            } else {
              _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
            }
            final Integer _tmpResponseCode;
            if (_cursor.isNull(_cursorIndexOfResponseCode)) {
              _tmpResponseCode = null;
            } else {
              _tmpResponseCode = _cursor.getInt(_cursorIndexOfResponseCode);
            }
            final Long _tmpRequestPayloadSize;
            if (_cursor.isNull(_cursorIndexOfRequestPayloadSize)) {
              _tmpRequestPayloadSize = null;
            } else {
              _tmpRequestPayloadSize = _cursor.getLong(_cursorIndexOfRequestPayloadSize);
            }
            final Long _tmpResponsePayloadSize;
            if (_cursor.isNull(_cursorIndexOfResponsePayloadSize)) {
              _tmpResponsePayloadSize = null;
            } else {
              _tmpResponsePayloadSize = _cursor.getLong(_cursorIndexOfResponsePayloadSize);
            }
            final String _tmpError;
            if (_cursor.isNull(_cursorIndexOfError)) {
              _tmpError = null;
            } else {
              _tmpError = _cursor.getString(_cursorIndexOfError);
            }
            final boolean _tmpGraphQlDetected;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfGraphQlDetected);
            _tmpGraphQlDetected = _tmp != 0;
            final String _tmpGraphQlOperationName;
            if (_cursor.isNull(_cursorIndexOfGraphQlOperationName)) {
              _tmpGraphQlOperationName = null;
            } else {
              _tmpGraphQlOperationName = _cursor.getString(_cursorIndexOfGraphQlOperationName);
            }
            _item = new HttpTransactionTuple(_tmpId,_tmpRequestDate,_tmpTookMs,_tmpProtocol,_tmpMethod,_tmpHost,_tmpPath,_tmpScheme,_tmpResponseCode,_tmpRequestPayloadSize,_tmpResponsePayloadSize,_tmpError,_tmpGraphQlDetected,_tmpGraphQlOperationName);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public LiveData<HttpTransaction> getById(final long id) {
    final String _sql = "SELECT * FROM transactions WHERE id = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, id);
    return __db.getInvalidationTracker().createLiveData(new String[] {"transactions"}, false, new Callable<HttpTransaction>() {
      @Override
      @Nullable
      public HttpTransaction call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfRequestDate = CursorUtil.getColumnIndexOrThrow(_cursor, "requestDate");
          final int _cursorIndexOfResponseDate = CursorUtil.getColumnIndexOrThrow(_cursor, "responseDate");
          final int _cursorIndexOfTookMs = CursorUtil.getColumnIndexOrThrow(_cursor, "tookMs");
          final int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow(_cursor, "protocol");
          final int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow(_cursor, "method");
          final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "url");
          final int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow(_cursor, "host");
          final int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow(_cursor, "path");
          final int _cursorIndexOfScheme = CursorUtil.getColumnIndexOrThrow(_cursor, "scheme");
          final int _cursorIndexOfResponseTlsVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "responseTlsVersion");
          final int _cursorIndexOfResponseCipherSuite = CursorUtil.getColumnIndexOrThrow(_cursor, "responseCipherSuite");
          final int _cursorIndexOfRequestPayloadSize = CursorUtil.getColumnIndexOrThrow(_cursor, "requestPayloadSize");
          final int _cursorIndexOfRequestContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "requestContentType");
          final int _cursorIndexOfRequestHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "requestHeaders");
          final int _cursorIndexOfRequestHeadersSize = CursorUtil.getColumnIndexOrThrow(_cursor, "requestHeadersSize");
          final int _cursorIndexOfRequestBody = CursorUtil.getColumnIndexOrThrow(_cursor, "requestBody");
          final int _cursorIndexOfIsRequestBodyEncoded = CursorUtil.getColumnIndexOrThrow(_cursor, "isRequestBodyEncoded");
          final int _cursorIndexOfResponseCode = CursorUtil.getColumnIndexOrThrow(_cursor, "responseCode");
          final int _cursorIndexOfResponseMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "responseMessage");
          final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "error");
          final int _cursorIndexOfResponsePayloadSize = CursorUtil.getColumnIndexOrThrow(_cursor, "responsePayloadSize");
          final int _cursorIndexOfResponseContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "responseContentType");
          final int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "responseHeaders");
          final int _cursorIndexOfResponseHeadersSize = CursorUtil.getColumnIndexOrThrow(_cursor, "responseHeadersSize");
          final int _cursorIndexOfResponseBody = CursorUtil.getColumnIndexOrThrow(_cursor, "responseBody");
          final int _cursorIndexOfIsResponseBodyEncoded = CursorUtil.getColumnIndexOrThrow(_cursor, "isResponseBodyEncoded");
          final int _cursorIndexOfResponseImageData = CursorUtil.getColumnIndexOrThrow(_cursor, "responseImageData");
          final int _cursorIndexOfGraphQlDetected = CursorUtil.getColumnIndexOrThrow(_cursor, "graphQlDetected");
          final int _cursorIndexOfGraphQlOperationName = CursorUtil.getColumnIndexOrThrow(_cursor, "graphQlOperationName");
          final HttpTransaction _result;
          if (_cursor.moveToFirst()) {
            final long _tmpId;
            _tmpId = _cursor.getLong(_cursorIndexOfId);
            final Long _tmpRequestDate;
            if (_cursor.isNull(_cursorIndexOfRequestDate)) {
              _tmpRequestDate = null;
            } else {
              _tmpRequestDate = _cursor.getLong(_cursorIndexOfRequestDate);
            }
            final Long _tmpResponseDate;
            if (_cursor.isNull(_cursorIndexOfResponseDate)) {
              _tmpResponseDate = null;
            } else {
              _tmpResponseDate = _cursor.getLong(_cursorIndexOfResponseDate);
            }
            final Long _tmpTookMs;
            if (_cursor.isNull(_cursorIndexOfTookMs)) {
              _tmpTookMs = null;
            } else {
              _tmpTookMs = _cursor.getLong(_cursorIndexOfTookMs);
            }
            final String _tmpProtocol;
            if (_cursor.isNull(_cursorIndexOfProtocol)) {
              _tmpProtocol = null;
            } else {
              _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
            }
            final String _tmpMethod;
            if (_cursor.isNull(_cursorIndexOfMethod)) {
              _tmpMethod = null;
            } else {
              _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
            }
            final String _tmpUrl;
            if (_cursor.isNull(_cursorIndexOfUrl)) {
              _tmpUrl = null;
            } else {
              _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
            }
            final String _tmpHost;
            if (_cursor.isNull(_cursorIndexOfHost)) {
              _tmpHost = null;
            } else {
              _tmpHost = _cursor.getString(_cursorIndexOfHost);
            }
            final String _tmpPath;
            if (_cursor.isNull(_cursorIndexOfPath)) {
              _tmpPath = null;
            } else {
              _tmpPath = _cursor.getString(_cursorIndexOfPath);
            }
            final String _tmpScheme;
            if (_cursor.isNull(_cursorIndexOfScheme)) {
              _tmpScheme = null;
            } else {
              _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
            }
            final String _tmpResponseTlsVersion;
            if (_cursor.isNull(_cursorIndexOfResponseTlsVersion)) {
              _tmpResponseTlsVersion = null;
            } else {
              _tmpResponseTlsVersion = _cursor.getString(_cursorIndexOfResponseTlsVersion);
            }
            final String _tmpResponseCipherSuite;
            if (_cursor.isNull(_cursorIndexOfResponseCipherSuite)) {
              _tmpResponseCipherSuite = null;
            } else {
              _tmpResponseCipherSuite = _cursor.getString(_cursorIndexOfResponseCipherSuite);
            }
            final Long _tmpRequestPayloadSize;
            if (_cursor.isNull(_cursorIndexOfRequestPayloadSize)) {
              _tmpRequestPayloadSize = null;
            } else {
              _tmpRequestPayloadSize = _cursor.getLong(_cursorIndexOfRequestPayloadSize);
            }
            final String _tmpRequestContentType;
            if (_cursor.isNull(_cursorIndexOfRequestContentType)) {
              _tmpRequestContentType = null;
            } else {
              _tmpRequestContentType = _cursor.getString(_cursorIndexOfRequestContentType);
            }
            final String _tmpRequestHeaders;
            if (_cursor.isNull(_cursorIndexOfRequestHeaders)) {
              _tmpRequestHeaders = null;
            } else {
              _tmpRequestHeaders = _cursor.getString(_cursorIndexOfRequestHeaders);
            }
            final Long _tmpRequestHeadersSize;
            if (_cursor.isNull(_cursorIndexOfRequestHeadersSize)) {
              _tmpRequestHeadersSize = null;
            } else {
              _tmpRequestHeadersSize = _cursor.getLong(_cursorIndexOfRequestHeadersSize);
            }
            final String _tmpRequestBody;
            if (_cursor.isNull(_cursorIndexOfRequestBody)) {
              _tmpRequestBody = null;
            } else {
              _tmpRequestBody = _cursor.getString(_cursorIndexOfRequestBody);
            }
            final boolean _tmpIsRequestBodyEncoded;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsRequestBodyEncoded);
            _tmpIsRequestBodyEncoded = _tmp != 0;
            final Integer _tmpResponseCode;
            if (_cursor.isNull(_cursorIndexOfResponseCode)) {
              _tmpResponseCode = null;
            } else {
              _tmpResponseCode = _cursor.getInt(_cursorIndexOfResponseCode);
            }
            final String _tmpResponseMessage;
            if (_cursor.isNull(_cursorIndexOfResponseMessage)) {
              _tmpResponseMessage = null;
            } else {
              _tmpResponseMessage = _cursor.getString(_cursorIndexOfResponseMessage);
            }
            final String _tmpError;
            if (_cursor.isNull(_cursorIndexOfError)) {
              _tmpError = null;
            } else {
              _tmpError = _cursor.getString(_cursorIndexOfError);
            }
            final Long _tmpResponsePayloadSize;
            if (_cursor.isNull(_cursorIndexOfResponsePayloadSize)) {
              _tmpResponsePayloadSize = null;
            } else {
              _tmpResponsePayloadSize = _cursor.getLong(_cursorIndexOfResponsePayloadSize);
            }
            final String _tmpResponseContentType;
            if (_cursor.isNull(_cursorIndexOfResponseContentType)) {
              _tmpResponseContentType = null;
            } else {
              _tmpResponseContentType = _cursor.getString(_cursorIndexOfResponseContentType);
            }
            final String _tmpResponseHeaders;
            if (_cursor.isNull(_cursorIndexOfResponseHeaders)) {
              _tmpResponseHeaders = null;
            } else {
              _tmpResponseHeaders = _cursor.getString(_cursorIndexOfResponseHeaders);
            }
            final Long _tmpResponseHeadersSize;
            if (_cursor.isNull(_cursorIndexOfResponseHeadersSize)) {
              _tmpResponseHeadersSize = null;
            } else {
              _tmpResponseHeadersSize = _cursor.getLong(_cursorIndexOfResponseHeadersSize);
            }
            final String _tmpResponseBody;
            if (_cursor.isNull(_cursorIndexOfResponseBody)) {
              _tmpResponseBody = null;
            } else {
              _tmpResponseBody = _cursor.getString(_cursorIndexOfResponseBody);
            }
            final boolean _tmpIsResponseBodyEncoded;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfIsResponseBodyEncoded);
            _tmpIsResponseBodyEncoded = _tmp_1 != 0;
            final byte[] _tmpResponseImageData;
            if (_cursor.isNull(_cursorIndexOfResponseImageData)) {
              _tmpResponseImageData = null;
            } else {
              _tmpResponseImageData = _cursor.getBlob(_cursorIndexOfResponseImageData);
            }
            final boolean _tmpGraphQlDetected;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfGraphQlDetected);
            _tmpGraphQlDetected = _tmp_2 != 0;
            final String _tmpGraphQlOperationName;
            if (_cursor.isNull(_cursorIndexOfGraphQlOperationName)) {
              _tmpGraphQlOperationName = null;
            } else {
              _tmpGraphQlOperationName = _cursor.getString(_cursorIndexOfGraphQlOperationName);
            }
            _result = new HttpTransaction(_tmpId,_tmpRequestDate,_tmpResponseDate,_tmpTookMs,_tmpProtocol,_tmpMethod,_tmpUrl,_tmpHost,_tmpPath,_tmpScheme,_tmpResponseTlsVersion,_tmpResponseCipherSuite,_tmpRequestPayloadSize,_tmpRequestContentType,_tmpRequestHeaders,_tmpRequestHeadersSize,_tmpRequestBody,_tmpIsRequestBodyEncoded,_tmpResponseCode,_tmpResponseMessage,_tmpError,_tmpResponsePayloadSize,_tmpResponseContentType,_tmpResponseHeaders,_tmpResponseHeadersSize,_tmpResponseBody,_tmpIsResponseBodyEncoded,_tmpResponseImageData,_tmpGraphQlDetected,_tmpGraphQlOperationName);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getAll(final Continuation<? super List<HttpTransaction>> $completion) {
    final String _sql = "SELECT * FROM transactions";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<HttpTransaction>>() {
      @Override
      @NonNull
      public List<HttpTransaction> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfRequestDate = CursorUtil.getColumnIndexOrThrow(_cursor, "requestDate");
          final int _cursorIndexOfResponseDate = CursorUtil.getColumnIndexOrThrow(_cursor, "responseDate");
          final int _cursorIndexOfTookMs = CursorUtil.getColumnIndexOrThrow(_cursor, "tookMs");
          final int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow(_cursor, "protocol");
          final int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow(_cursor, "method");
          final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "url");
          final int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow(_cursor, "host");
          final int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow(_cursor, "path");
          final int _cursorIndexOfScheme = CursorUtil.getColumnIndexOrThrow(_cursor, "scheme");
          final int _cursorIndexOfResponseTlsVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "responseTlsVersion");
          final int _cursorIndexOfResponseCipherSuite = CursorUtil.getColumnIndexOrThrow(_cursor, "responseCipherSuite");
          final int _cursorIndexOfRequestPayloadSize = CursorUtil.getColumnIndexOrThrow(_cursor, "requestPayloadSize");
          final int _cursorIndexOfRequestContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "requestContentType");
          final int _cursorIndexOfRequestHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "requestHeaders");
          final int _cursorIndexOfRequestHeadersSize = CursorUtil.getColumnIndexOrThrow(_cursor, "requestHeadersSize");
          final int _cursorIndexOfRequestBody = CursorUtil.getColumnIndexOrThrow(_cursor, "requestBody");
          final int _cursorIndexOfIsRequestBodyEncoded = CursorUtil.getColumnIndexOrThrow(_cursor, "isRequestBodyEncoded");
          final int _cursorIndexOfResponseCode = CursorUtil.getColumnIndexOrThrow(_cursor, "responseCode");
          final int _cursorIndexOfResponseMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "responseMessage");
          final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "error");
          final int _cursorIndexOfResponsePayloadSize = CursorUtil.getColumnIndexOrThrow(_cursor, "responsePayloadSize");
          final int _cursorIndexOfResponseContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "responseContentType");
          final int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "responseHeaders");
          final int _cursorIndexOfResponseHeadersSize = CursorUtil.getColumnIndexOrThrow(_cursor, "responseHeadersSize");
          final int _cursorIndexOfResponseBody = CursorUtil.getColumnIndexOrThrow(_cursor, "responseBody");
          final int _cursorIndexOfIsResponseBodyEncoded = CursorUtil.getColumnIndexOrThrow(_cursor, "isResponseBodyEncoded");
          final int _cursorIndexOfResponseImageData = CursorUtil.getColumnIndexOrThrow(_cursor, "responseImageData");
          final int _cursorIndexOfGraphQlDetected = CursorUtil.getColumnIndexOrThrow(_cursor, "graphQlDetected");
          final int _cursorIndexOfGraphQlOperationName = CursorUtil.getColumnIndexOrThrow(_cursor, "graphQlOperationName");
          final List<HttpTransaction> _result = new ArrayList<HttpTransaction>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final HttpTransaction _item;
            final long _tmpId;
            _tmpId = _cursor.getLong(_cursorIndexOfId);
            final Long _tmpRequestDate;
            if (_cursor.isNull(_cursorIndexOfRequestDate)) {
              _tmpRequestDate = null;
            } else {
              _tmpRequestDate = _cursor.getLong(_cursorIndexOfRequestDate);
            }
            final Long _tmpResponseDate;
            if (_cursor.isNull(_cursorIndexOfResponseDate)) {
              _tmpResponseDate = null;
            } else {
              _tmpResponseDate = _cursor.getLong(_cursorIndexOfResponseDate);
            }
            final Long _tmpTookMs;
            if (_cursor.isNull(_cursorIndexOfTookMs)) {
              _tmpTookMs = null;
            } else {
              _tmpTookMs = _cursor.getLong(_cursorIndexOfTookMs);
            }
            final String _tmpProtocol;
            if (_cursor.isNull(_cursorIndexOfProtocol)) {
              _tmpProtocol = null;
            } else {
              _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
            }
            final String _tmpMethod;
            if (_cursor.isNull(_cursorIndexOfMethod)) {
              _tmpMethod = null;
            } else {
              _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
            }
            final String _tmpUrl;
            if (_cursor.isNull(_cursorIndexOfUrl)) {
              _tmpUrl = null;
            } else {
              _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
            }
            final String _tmpHost;
            if (_cursor.isNull(_cursorIndexOfHost)) {
              _tmpHost = null;
            } else {
              _tmpHost = _cursor.getString(_cursorIndexOfHost);
            }
            final String _tmpPath;
            if (_cursor.isNull(_cursorIndexOfPath)) {
              _tmpPath = null;
            } else {
              _tmpPath = _cursor.getString(_cursorIndexOfPath);
            }
            final String _tmpScheme;
            if (_cursor.isNull(_cursorIndexOfScheme)) {
              _tmpScheme = null;
            } else {
              _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
            }
            final String _tmpResponseTlsVersion;
            if (_cursor.isNull(_cursorIndexOfResponseTlsVersion)) {
              _tmpResponseTlsVersion = null;
            } else {
              _tmpResponseTlsVersion = _cursor.getString(_cursorIndexOfResponseTlsVersion);
            }
            final String _tmpResponseCipherSuite;
            if (_cursor.isNull(_cursorIndexOfResponseCipherSuite)) {
              _tmpResponseCipherSuite = null;
            } else {
              _tmpResponseCipherSuite = _cursor.getString(_cursorIndexOfResponseCipherSuite);
            }
            final Long _tmpRequestPayloadSize;
            if (_cursor.isNull(_cursorIndexOfRequestPayloadSize)) {
              _tmpRequestPayloadSize = null;
            } else {
              _tmpRequestPayloadSize = _cursor.getLong(_cursorIndexOfRequestPayloadSize);
            }
            final String _tmpRequestContentType;
            if (_cursor.isNull(_cursorIndexOfRequestContentType)) {
              _tmpRequestContentType = null;
            } else {
              _tmpRequestContentType = _cursor.getString(_cursorIndexOfRequestContentType);
            }
            final String _tmpRequestHeaders;
            if (_cursor.isNull(_cursorIndexOfRequestHeaders)) {
              _tmpRequestHeaders = null;
            } else {
              _tmpRequestHeaders = _cursor.getString(_cursorIndexOfRequestHeaders);
            }
            final Long _tmpRequestHeadersSize;
            if (_cursor.isNull(_cursorIndexOfRequestHeadersSize)) {
              _tmpRequestHeadersSize = null;
            } else {
              _tmpRequestHeadersSize = _cursor.getLong(_cursorIndexOfRequestHeadersSize);
            }
            final String _tmpRequestBody;
            if (_cursor.isNull(_cursorIndexOfRequestBody)) {
              _tmpRequestBody = null;
            } else {
              _tmpRequestBody = _cursor.getString(_cursorIndexOfRequestBody);
            }
            final boolean _tmpIsRequestBodyEncoded;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsRequestBodyEncoded);
            _tmpIsRequestBodyEncoded = _tmp != 0;
            final Integer _tmpResponseCode;
            if (_cursor.isNull(_cursorIndexOfResponseCode)) {
              _tmpResponseCode = null;
            } else {
              _tmpResponseCode = _cursor.getInt(_cursorIndexOfResponseCode);
            }
            final String _tmpResponseMessage;
            if (_cursor.isNull(_cursorIndexOfResponseMessage)) {
              _tmpResponseMessage = null;
            } else {
              _tmpResponseMessage = _cursor.getString(_cursorIndexOfResponseMessage);
            }
            final String _tmpError;
            if (_cursor.isNull(_cursorIndexOfError)) {
              _tmpError = null;
            } else {
              _tmpError = _cursor.getString(_cursorIndexOfError);
            }
            final Long _tmpResponsePayloadSize;
            if (_cursor.isNull(_cursorIndexOfResponsePayloadSize)) {
              _tmpResponsePayloadSize = null;
            } else {
              _tmpResponsePayloadSize = _cursor.getLong(_cursorIndexOfResponsePayloadSize);
            }
            final String _tmpResponseContentType;
            if (_cursor.isNull(_cursorIndexOfResponseContentType)) {
              _tmpResponseContentType = null;
            } else {
              _tmpResponseContentType = _cursor.getString(_cursorIndexOfResponseContentType);
            }
            final String _tmpResponseHeaders;
            if (_cursor.isNull(_cursorIndexOfResponseHeaders)) {
              _tmpResponseHeaders = null;
            } else {
              _tmpResponseHeaders = _cursor.getString(_cursorIndexOfResponseHeaders);
            }
            final Long _tmpResponseHeadersSize;
            if (_cursor.isNull(_cursorIndexOfResponseHeadersSize)) {
              _tmpResponseHeadersSize = null;
            } else {
              _tmpResponseHeadersSize = _cursor.getLong(_cursorIndexOfResponseHeadersSize);
            }
            final String _tmpResponseBody;
            if (_cursor.isNull(_cursorIndexOfResponseBody)) {
              _tmpResponseBody = null;
            } else {
              _tmpResponseBody = _cursor.getString(_cursorIndexOfResponseBody);
            }
            final boolean _tmpIsResponseBodyEncoded;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfIsResponseBodyEncoded);
            _tmpIsResponseBodyEncoded = _tmp_1 != 0;
            final byte[] _tmpResponseImageData;
            if (_cursor.isNull(_cursorIndexOfResponseImageData)) {
              _tmpResponseImageData = null;
            } else {
              _tmpResponseImageData = _cursor.getBlob(_cursorIndexOfResponseImageData);
            }
            final boolean _tmpGraphQlDetected;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfGraphQlDetected);
            _tmpGraphQlDetected = _tmp_2 != 0;
            final String _tmpGraphQlOperationName;
            if (_cursor.isNull(_cursorIndexOfGraphQlOperationName)) {
              _tmpGraphQlOperationName = null;
            } else {
              _tmpGraphQlOperationName = _cursor.getString(_cursorIndexOfGraphQlOperationName);
            }
            _item = new HttpTransaction(_tmpId,_tmpRequestDate,_tmpResponseDate,_tmpTookMs,_tmpProtocol,_tmpMethod,_tmpUrl,_tmpHost,_tmpPath,_tmpScheme,_tmpResponseTlsVersion,_tmpResponseCipherSuite,_tmpRequestPayloadSize,_tmpRequestContentType,_tmpRequestHeaders,_tmpRequestHeadersSize,_tmpRequestBody,_tmpIsRequestBodyEncoded,_tmpResponseCode,_tmpResponseMessage,_tmpError,_tmpResponsePayloadSize,_tmpResponseContentType,_tmpResponseHeaders,_tmpResponseHeadersSize,_tmpResponseBody,_tmpIsResponseBodyEncoded,_tmpResponseImageData,_tmpGraphQlDetected,_tmpGraphQlOperationName);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public List<HttpTransaction> getTransactionsInTimeRange(final long timestamp) {
    final String _sql = "SELECT * FROM transactions WHERE requestDate >= ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, timestamp);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
      final int _cursorIndexOfRequestDate = CursorUtil.getColumnIndexOrThrow(_cursor, "requestDate");
      final int _cursorIndexOfResponseDate = CursorUtil.getColumnIndexOrThrow(_cursor, "responseDate");
      final int _cursorIndexOfTookMs = CursorUtil.getColumnIndexOrThrow(_cursor, "tookMs");
      final int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow(_cursor, "protocol");
      final int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow(_cursor, "method");
      final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "url");
      final int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow(_cursor, "host");
      final int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow(_cursor, "path");
      final int _cursorIndexOfScheme = CursorUtil.getColumnIndexOrThrow(_cursor, "scheme");
      final int _cursorIndexOfResponseTlsVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "responseTlsVersion");
      final int _cursorIndexOfResponseCipherSuite = CursorUtil.getColumnIndexOrThrow(_cursor, "responseCipherSuite");
      final int _cursorIndexOfRequestPayloadSize = CursorUtil.getColumnIndexOrThrow(_cursor, "requestPayloadSize");
      final int _cursorIndexOfRequestContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "requestContentType");
      final int _cursorIndexOfRequestHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "requestHeaders");
      final int _cursorIndexOfRequestHeadersSize = CursorUtil.getColumnIndexOrThrow(_cursor, "requestHeadersSize");
      final int _cursorIndexOfRequestBody = CursorUtil.getColumnIndexOrThrow(_cursor, "requestBody");
      final int _cursorIndexOfIsRequestBodyEncoded = CursorUtil.getColumnIndexOrThrow(_cursor, "isRequestBodyEncoded");
      final int _cursorIndexOfResponseCode = CursorUtil.getColumnIndexOrThrow(_cursor, "responseCode");
      final int _cursorIndexOfResponseMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "responseMessage");
      final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "error");
      final int _cursorIndexOfResponsePayloadSize = CursorUtil.getColumnIndexOrThrow(_cursor, "responsePayloadSize");
      final int _cursorIndexOfResponseContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "responseContentType");
      final int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "responseHeaders");
      final int _cursorIndexOfResponseHeadersSize = CursorUtil.getColumnIndexOrThrow(_cursor, "responseHeadersSize");
      final int _cursorIndexOfResponseBody = CursorUtil.getColumnIndexOrThrow(_cursor, "responseBody");
      final int _cursorIndexOfIsResponseBodyEncoded = CursorUtil.getColumnIndexOrThrow(_cursor, "isResponseBodyEncoded");
      final int _cursorIndexOfResponseImageData = CursorUtil.getColumnIndexOrThrow(_cursor, "responseImageData");
      final int _cursorIndexOfGraphQlDetected = CursorUtil.getColumnIndexOrThrow(_cursor, "graphQlDetected");
      final int _cursorIndexOfGraphQlOperationName = CursorUtil.getColumnIndexOrThrow(_cursor, "graphQlOperationName");
      final List<HttpTransaction> _result = new ArrayList<HttpTransaction>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final HttpTransaction _item;
        final long _tmpId;
        _tmpId = _cursor.getLong(_cursorIndexOfId);
        final Long _tmpRequestDate;
        if (_cursor.isNull(_cursorIndexOfRequestDate)) {
          _tmpRequestDate = null;
        } else {
          _tmpRequestDate = _cursor.getLong(_cursorIndexOfRequestDate);
        }
        final Long _tmpResponseDate;
        if (_cursor.isNull(_cursorIndexOfResponseDate)) {
          _tmpResponseDate = null;
        } else {
          _tmpResponseDate = _cursor.getLong(_cursorIndexOfResponseDate);
        }
        final Long _tmpTookMs;
        if (_cursor.isNull(_cursorIndexOfTookMs)) {
          _tmpTookMs = null;
        } else {
          _tmpTookMs = _cursor.getLong(_cursorIndexOfTookMs);
        }
        final String _tmpProtocol;
        if (_cursor.isNull(_cursorIndexOfProtocol)) {
          _tmpProtocol = null;
        } else {
          _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
        }
        final String _tmpMethod;
        if (_cursor.isNull(_cursorIndexOfMethod)) {
          _tmpMethod = null;
        } else {
          _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
        }
        final String _tmpUrl;
        if (_cursor.isNull(_cursorIndexOfUrl)) {
          _tmpUrl = null;
        } else {
          _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
        }
        final String _tmpHost;
        if (_cursor.isNull(_cursorIndexOfHost)) {
          _tmpHost = null;
        } else {
          _tmpHost = _cursor.getString(_cursorIndexOfHost);
        }
        final String _tmpPath;
        if (_cursor.isNull(_cursorIndexOfPath)) {
          _tmpPath = null;
        } else {
          _tmpPath = _cursor.getString(_cursorIndexOfPath);
        }
        final String _tmpScheme;
        if (_cursor.isNull(_cursorIndexOfScheme)) {
          _tmpScheme = null;
        } else {
          _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
        }
        final String _tmpResponseTlsVersion;
        if (_cursor.isNull(_cursorIndexOfResponseTlsVersion)) {
          _tmpResponseTlsVersion = null;
        } else {
          _tmpResponseTlsVersion = _cursor.getString(_cursorIndexOfResponseTlsVersion);
        }
        final String _tmpResponseCipherSuite;
        if (_cursor.isNull(_cursorIndexOfResponseCipherSuite)) {
          _tmpResponseCipherSuite = null;
        } else {
          _tmpResponseCipherSuite = _cursor.getString(_cursorIndexOfResponseCipherSuite);
        }
        final Long _tmpRequestPayloadSize;
        if (_cursor.isNull(_cursorIndexOfRequestPayloadSize)) {
          _tmpRequestPayloadSize = null;
        } else {
          _tmpRequestPayloadSize = _cursor.getLong(_cursorIndexOfRequestPayloadSize);
        }
        final String _tmpRequestContentType;
        if (_cursor.isNull(_cursorIndexOfRequestContentType)) {
          _tmpRequestContentType = null;
        } else {
          _tmpRequestContentType = _cursor.getString(_cursorIndexOfRequestContentType);
        }
        final String _tmpRequestHeaders;
        if (_cursor.isNull(_cursorIndexOfRequestHeaders)) {
          _tmpRequestHeaders = null;
        } else {
          _tmpRequestHeaders = _cursor.getString(_cursorIndexOfRequestHeaders);
        }
        final Long _tmpRequestHeadersSize;
        if (_cursor.isNull(_cursorIndexOfRequestHeadersSize)) {
          _tmpRequestHeadersSize = null;
        } else {
          _tmpRequestHeadersSize = _cursor.getLong(_cursorIndexOfRequestHeadersSize);
        }
        final String _tmpRequestBody;
        if (_cursor.isNull(_cursorIndexOfRequestBody)) {
          _tmpRequestBody = null;
        } else {
          _tmpRequestBody = _cursor.getString(_cursorIndexOfRequestBody);
        }
        final boolean _tmpIsRequestBodyEncoded;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfIsRequestBodyEncoded);
        _tmpIsRequestBodyEncoded = _tmp != 0;
        final Integer _tmpResponseCode;
        if (_cursor.isNull(_cursorIndexOfResponseCode)) {
          _tmpResponseCode = null;
        } else {
          _tmpResponseCode = _cursor.getInt(_cursorIndexOfResponseCode);
        }
        final String _tmpResponseMessage;
        if (_cursor.isNull(_cursorIndexOfResponseMessage)) {
          _tmpResponseMessage = null;
        } else {
          _tmpResponseMessage = _cursor.getString(_cursorIndexOfResponseMessage);
        }
        final String _tmpError;
        if (_cursor.isNull(_cursorIndexOfError)) {
          _tmpError = null;
        } else {
          _tmpError = _cursor.getString(_cursorIndexOfError);
        }
        final Long _tmpResponsePayloadSize;
        if (_cursor.isNull(_cursorIndexOfResponsePayloadSize)) {
          _tmpResponsePayloadSize = null;
        } else {
          _tmpResponsePayloadSize = _cursor.getLong(_cursorIndexOfResponsePayloadSize);
        }
        final String _tmpResponseContentType;
        if (_cursor.isNull(_cursorIndexOfResponseContentType)) {
          _tmpResponseContentType = null;
        } else {
          _tmpResponseContentType = _cursor.getString(_cursorIndexOfResponseContentType);
        }
        final String _tmpResponseHeaders;
        if (_cursor.isNull(_cursorIndexOfResponseHeaders)) {
          _tmpResponseHeaders = null;
        } else {
          _tmpResponseHeaders = _cursor.getString(_cursorIndexOfResponseHeaders);
        }
        final Long _tmpResponseHeadersSize;
        if (_cursor.isNull(_cursorIndexOfResponseHeadersSize)) {
          _tmpResponseHeadersSize = null;
        } else {
          _tmpResponseHeadersSize = _cursor.getLong(_cursorIndexOfResponseHeadersSize);
        }
        final String _tmpResponseBody;
        if (_cursor.isNull(_cursorIndexOfResponseBody)) {
          _tmpResponseBody = null;
        } else {
          _tmpResponseBody = _cursor.getString(_cursorIndexOfResponseBody);
        }
        final boolean _tmpIsResponseBodyEncoded;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfIsResponseBodyEncoded);
        _tmpIsResponseBodyEncoded = _tmp_1 != 0;
        final byte[] _tmpResponseImageData;
        if (_cursor.isNull(_cursorIndexOfResponseImageData)) {
          _tmpResponseImageData = null;
        } else {
          _tmpResponseImageData = _cursor.getBlob(_cursorIndexOfResponseImageData);
        }
        final boolean _tmpGraphQlDetected;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfGraphQlDetected);
        _tmpGraphQlDetected = _tmp_2 != 0;
        final String _tmpGraphQlOperationName;
        if (_cursor.isNull(_cursorIndexOfGraphQlOperationName)) {
          _tmpGraphQlOperationName = null;
        } else {
          _tmpGraphQlOperationName = _cursor.getString(_cursorIndexOfGraphQlOperationName);
        }
        _item = new HttpTransaction(_tmpId,_tmpRequestDate,_tmpResponseDate,_tmpTookMs,_tmpProtocol,_tmpMethod,_tmpUrl,_tmpHost,_tmpPath,_tmpScheme,_tmpResponseTlsVersion,_tmpResponseCipherSuite,_tmpRequestPayloadSize,_tmpRequestContentType,_tmpRequestHeaders,_tmpRequestHeadersSize,_tmpRequestBody,_tmpIsRequestBodyEncoded,_tmpResponseCode,_tmpResponseMessage,_tmpError,_tmpResponsePayloadSize,_tmpResponseContentType,_tmpResponseHeaders,_tmpResponseHeadersSize,_tmpResponseBody,_tmpIsResponseBodyEncoded,_tmpResponseImageData,_tmpGraphQlDetected,_tmpGraphQlOperationName);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
