/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import com.chuckerteam.chucker.internal.data.entity.HttpHeader;
import com.chuckerteam.chucker.internal.support.FormatUtils;
import com.chuckerteam.chucker.internal.support.JsonConverter;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00072\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/chuckerteam/chucker/internal/support/FormatUtils;", "", "()V", "BASE_TWO_MULTIPLE", "", "SI_MULTIPLE", "formatByteCount", "", "bytes", "", "si", "", "formatHeaders", "httpHeaders", "", "Lcom/chuckerteam/chucker/internal/data/entity/HttpHeader;", "withMarkup", "formatJson", "json", "formatThrowable", "throwable", "", "formatUrlEncodedForm", "form", "formatXml", "xml", "com.github.ChuckerTeam.Chucker.library"})
public final class FormatUtils {
    @NotNull
    public static final FormatUtils INSTANCE = new FormatUtils();
    private static final int SI_MULTIPLE = 1000;
    private static final int BASE_TWO_MULTIPLE = 1024;

    private FormatUtils() {
    }

    @NotNull
    public final String formatHeaders(@Nullable List<HttpHeader> httpHeaders, boolean withMarkup) {
        String string;
        List<HttpHeader> list = httpHeaders;
        return list == null ? "" : ((string = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<HttpHeader, CharSequence>(withMarkup){
            final /* synthetic */ boolean $withMarkup;
            {
                this.$withMarkup = $withMarkup;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull HttpHeader header) {
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                return this.$withMarkup ? (CharSequence)("<b> " + header.getName() + ": </b>" + header.getValue() + " <br />") : (CharSequence)(header.getName() + ": " + header.getValue() + '\n');
            }
        }), (int)30, null)) == null ? "" : string);
    }

    @NotNull
    public final String formatByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        double d = bytes;
        boolean bl = false;
        double d2 = Math.log(d);
        d = unit;
        bl = false;
        int exp = (int)(d2 / Math.log(d));
        char c = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1);
        Object object = si ? "" : "i";
        boolean bl2 = false;
        String pre = String.valueOf(c) + (String)object;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        object = Locale.US;
        String string = "%.1f %sB";
        Object[] objectArray = new Object[2];
        double d3 = unit;
        double d4 = exp;
        boolean bl3 = false;
        objectArray[0] = (double)bytes / Math.pow(d3, d4);
        objectArray[1] = pre;
        boolean bl4 = false;
        String string2 = String.format((Locale)object, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
        return string2;
    }

    @NotNull
    public final String formatJson(@NotNull String json) {
        String string;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            JsonElement je = JsonParser.parseString((String)json);
            string = JsonConverter.INSTANCE.getInstance().toJson(je);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            val je = JsonParser.parseString(json)\n            JsonConverter.instance.toJson(je)\n        }");
        }
        catch (JsonParseException e) {
            string = json;
        }
        return string;
    }

    @NotNull
    public final String formatXml(@NotNull String xml) {
        String string;
        Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Intrinsics.checkNotNullExpressionValue((Object)documentBuilderFactory, (String)"newInstance()");
            DocumentBuilderFactory documentFactory = documentBuilderFactory;
            documentFactory.setExpandEntityReferences(false);
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)documentBuilder, (String)"documentFactory.newDocumentBuilder()");
            DocumentBuilder documentBuilder2 = documentBuilder;
            String string2 = xml;
            Object object = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"defaultCharset()");
            boolean bl = false;
            byte[] byArray = string2.getBytes((Charset)object);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            InputSource inputSource = new InputSource(new ByteArrayInputStream(byArray));
            object = documentBuilder2.parse(inputSource);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"documentBuilder.parse(inputSource)");
            Object document = object;
            DOMSource domSource = new DOMSource((Node)document);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Object object2 = TransformerFactory.newInstance();
            boolean bl2 = false;
            boolean bl3 = false;
            TransformerFactory $this$formatXml_u24lambda_u2d0 = object2;
            boolean bl4 = false;
            $this$formatXml_u24lambda_u2d0.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            object2 = ((TransformerFactory)object2).newTransformer();
            bl2 = false;
            bl3 = false;
            Object $this$formatXml_u24lambda_u2d1 = object2;
            boolean bl5 = false;
            ((Transformer)$this$formatXml_u24lambda_u2d1).setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            ((Transformer)$this$formatXml_u24lambda_u2d1).setOutputProperty("indent", "yes");
            ((Transformer)$this$formatXml_u24lambda_u2d1).transform(domSource, result);
            string = writer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            val documentFactory: DocumentBuilderFactory = DocumentBuilderFactory.newInstance()\n            // This flag is required for security reasons\n            documentFactory.isExpandEntityReferences = false\n\n            val documentBuilder: DocumentBuilder = documentFactory.newDocumentBuilder()\n            val inputSource = InputSource(ByteArrayInputStream(xml.toByteArray(Charset.defaultCharset())))\n            val document: Document = documentBuilder.parse(inputSource)\n\n            val domSource = DOMSource(document)\n            val writer = StringWriter()\n            val result = StreamResult(writer)\n\n            TransformerFactory.newInstance().apply {\n                setFeature(XMLConstants.FEATURE_SECURE_PROCESSING, true)\n            }.newTransformer().apply {\n                setOutputProperty(\"{http://xml.apache.org/xslt}indent-amount\", \"2\")\n                setOutputProperty(OutputKeys.INDENT, \"yes\")\n                transform(domSource, result)\n            }\n            writer.toString()\n        }");
        }
        catch (SAXParseException _) {
            string = xml;
        }
        catch (IOException _) {
            string = xml;
        }
        catch (TransformerException _) {
            string = xml;
        }
        return string;
    }

    @NotNull
    public final String formatUrlEncodedForm(@NotNull String form) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        try {
            if (StringsKt.isBlank((CharSequence)((CharSequence)form))) {
                return form;
            }
            object = new String[]{"&"};
            object = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)((CharSequence)form), (String[])object, (boolean)false, (int)0, (int)6, null), (CharSequence)"\n", null, null, (int)0, null, (Function1)formatUrlEncodedForm.1.INSTANCE, (int)30, null);
        }
        catch (IllegalArgumentException _) {
            object = form;
        }
        catch (UnsupportedEncodingException _) {
            object = form;
        }
        return object;
    }

    @NotNull
    public final String formatThrowable(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        return string;
    }
}

