/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.data.repository;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.chuckerteam.chucker.internal.data.repository.HttpTransactionDatabaseRepository;
import com.chuckerteam.chucker.internal.data.repository.HttpTransactionRepository;
import com.chuckerteam.chucker.internal.data.repository.RecordedThrowableDatabaseRepository;
import com.chuckerteam.chucker.internal.data.repository.RecordedThrowableRepository;
import com.chuckerteam.chucker.internal.data.room.ChuckerDatabase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/chuckerteam/chucker/internal/data/repository/RepositoryProvider;", "", "()V", "throwableRepository", "Lcom/chuckerteam/chucker/internal/data/repository/RecordedThrowableRepository;", "transactionRepository", "Lcom/chuckerteam/chucker/internal/data/repository/HttpTransactionRepository;", "close", "", "initialize", "applicationContext", "Landroid/content/Context;", "throwable", "transaction", "com.github.ChuckerTeam.Chucker.library"})
public final class RepositoryProvider {
    private static HttpTransactionRepository transactionRepository;
    private static RecordedThrowableRepository throwableRepository;
    public static final RepositoryProvider INSTANCE;

    @NotNull
    public final HttpTransactionRepository transaction() {
        HttpTransactionRepository httpTransactionRepository = transactionRepository;
        boolean bl = false;
        boolean bl2 = false;
        if (httpTransactionRepository == null) {
            boolean bl3 = false;
            String string2 = "You can't access the transaction repository if you don't initialize it!";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return httpTransactionRepository;
    }

    @NotNull
    public final RecordedThrowableRepository throwable() {
        RecordedThrowableRepository recordedThrowableRepository = throwableRepository;
        boolean bl = false;
        boolean bl2 = false;
        if (recordedThrowableRepository == null) {
            boolean bl3 = false;
            String string2 = "You can't access the throwable repository if you don't initialize it!";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return recordedThrowableRepository;
    }

    public final void initialize(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        if (transactionRepository == null || throwableRepository == null) {
            ChuckerDatabase db = ChuckerDatabase.Companion.create(applicationContext);
            transactionRepository = new HttpTransactionDatabaseRepository(db);
            throwableRepository = new RecordedThrowableDatabaseRepository(db);
        }
    }

    @VisibleForTesting
    public final void close() {
        transactionRepository = null;
        throwableRepository = null;
    }

    private RepositoryProvider() {
    }

    static {
        RepositoryProvider repositoryProvider;
        INSTANCE = repositoryProvider = new RepositoryProvider();
    }
}

