/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.data.room;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.entity.HttpTransactionTuple;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\ba\u0018\u00002\u00020\u0001J\u0011\u0010\u0002\u001a\u00020\u0003H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u0007H'J$\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\n0\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H'J\u0014\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\n0\rH'J\u001b\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u000bH'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcom/chuckerteam/chucker/internal/data/room/HttpTransactionDao;", "", "deleteAll", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteBefore", "threshold", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAll", "", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "getById", "Landroidx/lifecycle/LiveData;", "id", "getFilteredTuples", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransactionTuple;", "codeQuery", "", "pathQuery", "getSortedTuples", "insert", "transaction", "(Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "update", "", "com.github.ChuckerTeam.Chucker.library"})
@Dao
public interface HttpTransactionDao {
    @Query(value="SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestPayloadSize, responsePayloadSize, error FROM transactions ORDER BY requestDate DESC")
    @NotNull
    public LiveData<List<HttpTransactionTuple>> getSortedTuples();

    @Query(value="SELECT id, requestDate, tookMs, protocol, method, host, path, scheme, responseCode, requestPayloadSize, responsePayloadSize, error FROM transactions WHERE responseCode LIKE :codeQuery AND path LIKE :pathQuery ORDER BY requestDate DESC")
    @NotNull
    public LiveData<List<HttpTransactionTuple>> getFilteredTuples(@NotNull String var1, @NotNull String var2);

    @Insert
    @Nullable
    public Object insert(@NotNull HttpTransaction var1, @NotNull Continuation<? super Long> var2);

    @Update(onConflict=1)
    public int update(@NotNull HttpTransaction var1);

    @Query(value="DELETE FROM transactions")
    @Nullable
    public Object deleteAll(@NotNull Continuation<? super Unit> var1);

    @Query(value="SELECT * FROM transactions WHERE id = :id")
    @NotNull
    public LiveData<HttpTransaction> getById(long var1);

    @Query(value="DELETE FROM transactions WHERE requestDate <= :threshold")
    @Nullable
    public Object deleteBefore(long var1, @NotNull Continuation<? super Unit> var3);

    @Query(value="SELECT * FROM transactions")
    @Nullable
    public Object getAll(@NotNull Continuation<? super List<HttpTransaction>> var1);
}

