/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import androidx.core.widget.ImageViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.databinding.ChuckerListItemTransactionBinding;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.entity.HttpTransactionTuple;
import com.chuckerteam.chucker.internal.ui.transaction.ProtocolResources;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0002\u001d\u001eB\u0019\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\tH\u0016J\u001c\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u001c\u0010\u0017\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0014\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$TransactionViewHolder;", "context", "Landroid/content/Context;", "listener", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$TransactionClickListListener;", "(Landroid/content/Context;Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$TransactionClickListListener;)V", "color300", "", "color400", "color500", "colorDefault", "colorError", "colorRequested", "transactions", "", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransactionTuple;", "getItemCount", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setData", "httpTransactions", "TransactionClickListListener", "TransactionViewHolder", "com.github.ChuckerTeam.Chucker.library"})
public final class TransactionAdapter
extends RecyclerView.Adapter<TransactionViewHolder> {
    private List<HttpTransactionTuple> transactions;
    private final int colorDefault;
    private final int colorRequested;
    private final int colorError;
    private final int color500;
    private final int color400;
    private final int color300;
    private final TransactionClickListListener listener;

    public int getItemCount() {
        return this.transactions.size();
    }

    @NotNull
    public TransactionViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        ChuckerListItemTransactionBinding chuckerListItemTransactionBinding = ChuckerListItemTransactionBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)chuckerListItemTransactionBinding, (String)"ChuckerListItemTransacti\u2026.context), parent, false)");
        ChuckerListItemTransactionBinding viewBinding = chuckerListItemTransactionBinding;
        return new TransactionViewHolder(viewBinding);
    }

    public void onBindViewHolder(@NotNull TransactionViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        holder.bind(this.transactions.get(position));
    }

    public final void setData(@NotNull List<HttpTransactionTuple> httpTransactions) {
        Intrinsics.checkParameterIsNotNull(httpTransactions, (String)"httpTransactions");
        this.transactions = httpTransactions;
        this.notifyDataSetChanged();
    }

    public TransactionAdapter(@NotNull Context context, @Nullable TransactionClickListListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.listener = listener;
        TransactionAdapter transactionAdapter = this;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        transactionAdapter.transactions = arrayList;
        this.colorDefault = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_default);
        this.colorRequested = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_requested);
        this.colorError = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_error);
        this.color500 = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_500);
        this.color400 = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_400);
        this.color300 = ContextCompat.getColor((Context)context, (int)R.color.chucker_status_300);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$TransactionViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Landroid/view/View$OnClickListener;", "itemBinding", "Lcom/chuckerteam/chucker/databinding/ChuckerListItemTransactionBinding;", "(Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter;Lcom/chuckerteam/chucker/databinding/ChuckerListItemTransactionBinding;)V", "transactionId", "", "Ljava/lang/Long;", "bind", "", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransactionTuple;", "onClick", "v", "Landroid/view/View;", "setProtocolImage", "resources", "Lcom/chuckerteam/chucker/internal/ui/transaction/ProtocolResources;", "setStatusColor", "com.github.ChuckerTeam.Chucker.library"})
    public final class TransactionViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private Long transactionId;
        private final ChuckerListItemTransactionBinding itemBinding;

        public void onClick(@Nullable View v) {
            block1: {
                Long l = this.transactionId;
                if (l == null) break block1;
                Long l2 = l;
                boolean bl = false;
                boolean bl2 = false;
                long it = ((Number)l2).longValue();
                boolean bl3 = false;
                TransactionClickListListener transactionClickListListener = TransactionAdapter.this.listener;
                if (transactionClickListListener != null) {
                    transactionClickListListener.onTransactionClick(it, this.getAdapterPosition());
                }
            }
        }

        @SuppressLint(value={"SetTextI18n"})
        public final void bind(@NotNull HttpTransactionTuple transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            this.transactionId = transaction.getId();
            ChuckerListItemTransactionBinding chuckerListItemTransactionBinding = this.itemBinding;
            boolean bl = false;
            boolean bl2 = false;
            ChuckerListItemTransactionBinding $this$apply = chuckerListItemTransactionBinding;
            boolean bl3 = false;
            TextView textView = $this$apply.path;
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"path");
            textView.setText((CharSequence)(transaction.getMethod() + ' ' + transaction.getFormattedPath(false)));
            TextView textView2 = $this$apply.host;
            Intrinsics.checkExpressionValueIsNotNull((Object)textView2, (String)"host");
            textView2.setText((CharSequence)transaction.getHost());
            TextView textView3 = $this$apply.timeStart;
            Intrinsics.checkExpressionValueIsNotNull((Object)textView3, (String)"timeStart");
            textView3.setText((CharSequence)DateFormat.getTimeInstance().format(transaction.getRequestDate()));
            this.setProtocolImage(transaction.isSsl() ? (ProtocolResources)new ProtocolResources.Https() : (ProtocolResources)new ProtocolResources.Http());
            if (transaction.getStatus() == HttpTransaction.Status.Complete) {
                TextView textView4 = $this$apply.code;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView4, (String)"code");
                textView4.setText((CharSequence)String.valueOf(transaction.getResponseCode()));
                TextView textView5 = $this$apply.duration;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView5, (String)"duration");
                textView5.setText((CharSequence)transaction.getDurationString());
                TextView textView6 = $this$apply.size;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView6, (String)"size");
                textView6.setText((CharSequence)transaction.getTotalSizeString());
            } else {
                TextView textView7 = $this$apply.code;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView7, (String)"code");
                textView7.setText((CharSequence)"");
                TextView textView8 = $this$apply.duration;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView8, (String)"duration");
                textView8.setText((CharSequence)"");
                TextView textView9 = $this$apply.size;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView9, (String)"size");
                textView9.setText((CharSequence)"");
            }
            if (transaction.getStatus() == HttpTransaction.Status.Failed) {
                TextView textView10 = $this$apply.code;
                Intrinsics.checkExpressionValueIsNotNull((Object)textView10, (String)"code");
                textView10.setText((CharSequence)"!!!");
            }
            this.setStatusColor(transaction);
        }

        private final void setProtocolImage(ProtocolResources resources) {
            ImageView imageView = this.itemBinding.ssl;
            View view = this.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
            imageView.setImageDrawable(AppCompatResources.getDrawable((Context)view.getContext(), (int)resources.getIcon()));
            ImageView imageView2 = this.itemBinding.ssl;
            View view2 = this.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView");
            ImageViewCompat.setImageTintList((ImageView)imageView2, (ColorStateList)ColorStateList.valueOf((int)ContextCompat.getColor((Context)view2.getContext(), (int)resources.getColor())));
        }

        private final void setStatusColor(HttpTransactionTuple transaction) {
            int n;
            if (transaction.getStatus() == HttpTransaction.Status.Failed) {
                n = TransactionAdapter.this.colorError;
            } else if (transaction.getStatus() == HttpTransaction.Status.Requested) {
                n = TransactionAdapter.this.colorRequested;
            } else if (transaction.getResponseCode() == null) {
                n = TransactionAdapter.this.colorDefault;
            } else {
                Integer n2 = transaction.getResponseCode();
                if (n2 == null) {
                    Intrinsics.throwNpe();
                }
                if (n2 >= 500) {
                    n = TransactionAdapter.this.color500;
                } else {
                    Integer n3 = transaction.getResponseCode();
                    if (n3 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (n3 >= 400) {
                        n = TransactionAdapter.this.color400;
                    } else {
                        Integer n4 = transaction.getResponseCode();
                        if (n4 == null) {
                            Intrinsics.throwNpe();
                        }
                        n = n4 >= 300 ? TransactionAdapter.this.color300 : TransactionAdapter.this.colorDefault;
                    }
                }
            }
            int color2 = n;
            this.itemBinding.code.setTextColor(color2);
            this.itemBinding.path.setTextColor(color2);
        }

        public TransactionViewHolder(ChuckerListItemTransactionBinding itemBinding) {
            Intrinsics.checkParameterIsNotNull((Object)itemBinding, (String)"itemBinding");
            super((View)itemBinding.getRoot());
            this.itemBinding = itemBinding;
            this.itemView.setOnClickListener((View.OnClickListener)this);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter$TransactionClickListListener;", "", "onTransactionClick", "", "transactionId", "", "position", "", "com.github.ChuckerTeam.Chucker.library"})
    public static interface TransactionClickListListener {
        public void onTransactionClick(long var1, int var3);
    }
}

