/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.data.room;

import android.content.Context;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.chuckerteam.chucker.internal.data.room.ChuckerDatabase;
import com.chuckerteam.chucker.internal.data.room.HttpTransactionDao;
import com.chuckerteam.chucker.internal.data.room.HttpTransactionDao_Impl;
import com.chuckerteam.chucker.internal.data.room.RecordedThrowableDao;
import com.chuckerteam.chucker.internal.data.room.RecordedThrowableDao_Impl;
import java.util.HashMap;
import java.util.HashSet;

public final class ChuckerDatabase_Impl
extends ChuckerDatabase {
    private volatile RecordedThrowableDao _recordedThrowableDao;
    private volatile HttpTransactionDao _httpTransactionDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(3){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `throwables` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `tag` TEXT, `date` INTEGER, `clazz` TEXT, `message` TEXT, `content` TEXT)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `transactions` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `requestDate` INTEGER, `responseDate` INTEGER, `tookMs` INTEGER, `protocol` TEXT, `method` TEXT, `url` TEXT, `host` TEXT, `path` TEXT, `scheme` TEXT, `responseTlsVersion` TEXT, `responseCipherSuite` TEXT, `requestContentLength` INTEGER, `requestContentType` TEXT, `requestHeaders` TEXT, `requestBody` TEXT, `isRequestBodyPlainText` INTEGER NOT NULL, `responseCode` INTEGER, `responseMessage` TEXT, `error` TEXT, `responseContentLength` INTEGER, `responseContentType` TEXT, `responseHeaders` TEXT, `responseBody` TEXT, `isResponseBodyPlainText` INTEGER NOT NULL, `responseImageData` BLOB)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '408ac458a1c84450978e60e9b189226b')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `throwables`");
                _db.execSQL("DROP TABLE IF EXISTS `transactions`");
                if (ChuckerDatabase_Impl.this.mCallbacks != null) {
                    int _size = ChuckerDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)ChuckerDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (ChuckerDatabase_Impl.this.mCallbacks != null) {
                    int _size = ChuckerDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)ChuckerDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                ChuckerDatabase_Impl.this.mDatabase = _db;
                ChuckerDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (ChuckerDatabase_Impl.this.mCallbacks != null) {
                    int _size = ChuckerDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)ChuckerDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsThrowables = new HashMap<String, TableInfo.Column>(6);
                _columnsThrowables.put("id", new TableInfo.Column("id", "INTEGER", false, 1, null, 1));
                _columnsThrowables.put("tag", new TableInfo.Column("tag", "TEXT", false, 0, null, 1));
                _columnsThrowables.put("date", new TableInfo.Column("date", "INTEGER", false, 0, null, 1));
                _columnsThrowables.put("clazz", new TableInfo.Column("clazz", "TEXT", false, 0, null, 1));
                _columnsThrowables.put("message", new TableInfo.Column("message", "TEXT", false, 0, null, 1));
                _columnsThrowables.put("content", new TableInfo.Column("content", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysThrowables = new HashSet(0);
                HashSet _indicesThrowables = new HashSet(0);
                TableInfo _infoThrowables = new TableInfo("throwables", _columnsThrowables, _foreignKeysThrowables, _indicesThrowables);
                TableInfo _existingThrowables = TableInfo.read((SupportSQLiteDatabase)_db, (String)"throwables");
                if (!_infoThrowables.equals((Object)_existingThrowables)) {
                    return new RoomOpenHelper.ValidationResult(false, "throwables(com.chuckerteam.chucker.internal.data.entity.RecordedThrowable).\n Expected:\n" + _infoThrowables + "\n Found:\n" + _existingThrowables);
                }
                HashMap<String, TableInfo.Column> _columnsTransactions = new HashMap<String, TableInfo.Column>(26);
                _columnsTransactions.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsTransactions.put("requestDate", new TableInfo.Column("requestDate", "INTEGER", false, 0, null, 1));
                _columnsTransactions.put("responseDate", new TableInfo.Column("responseDate", "INTEGER", false, 0, null, 1));
                _columnsTransactions.put("tookMs", new TableInfo.Column("tookMs", "INTEGER", false, 0, null, 1));
                _columnsTransactions.put("protocol", new TableInfo.Column("protocol", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("method", new TableInfo.Column("method", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("url", new TableInfo.Column("url", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("host", new TableInfo.Column("host", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("path", new TableInfo.Column("path", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("scheme", new TableInfo.Column("scheme", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("responseTlsVersion", new TableInfo.Column("responseTlsVersion", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("responseCipherSuite", new TableInfo.Column("responseCipherSuite", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("requestContentLength", new TableInfo.Column("requestContentLength", "INTEGER", false, 0, null, 1));
                _columnsTransactions.put("requestContentType", new TableInfo.Column("requestContentType", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("requestHeaders", new TableInfo.Column("requestHeaders", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("requestBody", new TableInfo.Column("requestBody", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("isRequestBodyPlainText", new TableInfo.Column("isRequestBodyPlainText", "INTEGER", true, 0, null, 1));
                _columnsTransactions.put("responseCode", new TableInfo.Column("responseCode", "INTEGER", false, 0, null, 1));
                _columnsTransactions.put("responseMessage", new TableInfo.Column("responseMessage", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("error", new TableInfo.Column("error", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("responseContentLength", new TableInfo.Column("responseContentLength", "INTEGER", false, 0, null, 1));
                _columnsTransactions.put("responseContentType", new TableInfo.Column("responseContentType", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("responseHeaders", new TableInfo.Column("responseHeaders", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("responseBody", new TableInfo.Column("responseBody", "TEXT", false, 0, null, 1));
                _columnsTransactions.put("isResponseBodyPlainText", new TableInfo.Column("isResponseBodyPlainText", "INTEGER", true, 0, null, 1));
                _columnsTransactions.put("responseImageData", new TableInfo.Column("responseImageData", "BLOB", false, 0, null, 1));
                HashSet _foreignKeysTransactions = new HashSet(0);
                HashSet _indicesTransactions = new HashSet(0);
                TableInfo _infoTransactions = new TableInfo("transactions", _columnsTransactions, _foreignKeysTransactions, _indicesTransactions);
                TableInfo _existingTransactions = TableInfo.read((SupportSQLiteDatabase)_db, (String)"transactions");
                if (!_infoTransactions.equals((Object)_existingTransactions)) {
                    return new RoomOpenHelper.ValidationResult(false, "transactions(com.chuckerteam.chucker.internal.data.entity.HttpTransaction).\n Expected:\n" + _infoTransactions + "\n Found:\n" + _existingTransactions);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "408ac458a1c84450978e60e9b189226b", "d0ec917f8254fe30b3808a014163f60f");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"throwables", "transactions"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `throwables`");
            _db.execSQL("DELETE FROM `transactions`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordedThrowableDao throwableDao() {
        if (this._recordedThrowableDao != null) {
            return this._recordedThrowableDao;
        }
        ChuckerDatabase_Impl chuckerDatabase_Impl = this;
        synchronized (chuckerDatabase_Impl) {
            if (this._recordedThrowableDao == null) {
                this._recordedThrowableDao = new RecordedThrowableDao_Impl(this);
            }
            return this._recordedThrowableDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpTransactionDao transactionDao() {
        if (this._httpTransactionDao != null) {
            return this._httpTransactionDao;
        }
        ChuckerDatabase_Impl chuckerDatabase_Impl = this;
        synchronized (chuckerDatabase_Impl) {
            if (this._httpTransactionDao == null) {
                this._httpTransactionDao = new HttpTransactionDao_Impl(this);
            }
            return this._httpTransactionDao;
        }
    }
}

