/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0018\u0010\u000e\u001a\u00020\u0001*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0018\u0010\u0010\u001a\u00020\u0001*\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\"\u0018\u0010\u0010\u001a\u00020\u0001*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0013"}, d2={"containsGzip", "", "Lokhttp3/Headers;", "getContainsGzip", "(Lokhttp3/Headers;)Z", "contentLenght", "", "Lokhttp3/Response;", "getContentLenght", "(Lokhttp3/Response;)J", "contentType", "", "getContentType", "(Lokhttp3/Response;)Ljava/lang/String;", "isChunked", "(Lokhttp3/Response;)Z", "isGzipped", "Lokhttp3/Request;", "(Lokhttp3/Request;)Z", "com.github.ChuckerTeam.Chucker.library"})
@JvmName(name="OkHttpUtils")
public final class OkHttpUtils {
    public static final long getContentLenght(@NotNull Response $this$contentLenght) {
        Intrinsics.checkParameterIsNotNull((Object)$this$contentLenght, (String)"$this$contentLenght");
        Object object = $this$contentLenght.header("Content-Length");
        return object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : -1L;
    }

    public static final boolean isChunked(@NotNull Response $this$isChunked) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isChunked, (String)"$this$isChunked");
        return StringsKt.equals((String)$this$isChunked.header("Transfer-Encoding"), (String)"chunked", (boolean)true);
    }

    @Nullable
    public static final String getContentType(@NotNull Response $this$contentType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$contentType, (String)"$this$contentType");
        return $this$contentType.header("Content-Type");
    }

    public static final boolean isGzipped(@NotNull Response $this$isGzipped) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isGzipped, (String)"$this$isGzipped");
        Headers headers = $this$isGzipped.headers();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers, (String)"this.headers()");
        return OkHttpUtils.getContainsGzip(headers);
    }

    public static final boolean isGzipped(@NotNull Request $this$isGzipped) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isGzipped, (String)"$this$isGzipped");
        Headers headers = $this$isGzipped.headers();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers, (String)"this.headers()");
        return OkHttpUtils.getContainsGzip(headers);
    }

    private static final boolean getContainsGzip(@NotNull Headers $this$containsGzip) {
        return StringsKt.equals((String)$this$containsGzip.get("Content-Encoding"), (String)"gzip", (boolean)true);
    }
}

